import java.util.*;

import org.kde.qt.*;
import org.kde.koala.*;

/**	KBaseDoc provides a document object for a document-view model.
  *
  * The KBaseDoc class provides a document object that can be used in conjunction with the classes JavaApiTestApp and KBaseView
  * to create a document-view model for standard KDE applications based on KApplication and KMainWindow. Thereby, the document object
  * is created by the JavaApiTestApp instance and contains the document structure with the according methods for manipulation of the document
  * data by KBaseView objects. Also, KBaseDoc contains the methods for serialization of the document data from and to files.
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 1.2 code generation
  */
public class KBaseDoc extends QObject {

    /** the list of the views currently connected to the document */
  public ArrayList pViewList;

	/** the modified flag of the current document */
  private boolean modified;
  private KURL doc_url;

    /** Constructor for the fileclass of the application */
public KBaseDoc(QWidget parent, String name)
{
  super(parent, name);
  setURL(new KURL());

  if(pViewList == null)
  {
    pViewList = new ArrayList();
  }

//  pViewList.setAutoDelete(true);
}

    /** adds a view to the document which represents the document contents. Usually this is your main view. */
public void addView(KBaseView view)
{
  pViewList.add(view);
}

    /** removes a view from the list of currently connected views */
public void removeView(KBaseView view)
{
  pViewList.remove(view);
}

	/** sets the modified flag for the document after a modifying action on the view connected to the document.*/
public void setModified(boolean _m){ modified=_m; }
public void setModified(){ modified=true; }

	/** returns if the document is modified or not. Use this to determine if your document needs saving by the user on closing.*/
public boolean isModified(){ return modified; }

   /** sets the URL of the document */
public void setURL(KURL url)
{
  doc_url=url;
}

    /** returns the KURL of the document */
public KURL URL()
{
  return doc_url;
}

    /** calls repaint() on all views connected to the document object and is called by the view by which the document has been changed.
     * As this view normally repaints itself, it is excluded from the paintEvent.
     */
public void slotUpdateAllViews(KBaseView sender)
{
  KBaseView w;
  if(pViewList != null)
  {
    Iterator it = pViewList.iterator();
    while(it.hasNext())
    {
      w=(KBaseView)it.next();
      if(w!=sender)
        w.repaint();
    }
  }

}

    /** "save modified" - asks the user for saving if the document is modified */
public boolean saveModified()
{
  boolean completed=true;

  if(modified)
  {
    KBase win=(KBase ) parent();
    int want_save = KMessageBox.warningYesNoCancel(win, tr("Warning"),
                                         tr("The current file has been modified.\n"
                                              + "Do you want to save it?"));
    switch(want_save)
    {
      case 1:
           if (doc_url.fileName() == tr("Untitled"))
           {
             win.slotFileSaveAs();
           }
           else
           {
             saveDocument(URL());
       	   };

       	   deleteContents();
           completed=true;
           break;

      case 2:
           setModified(false);
           deleteContents();
           completed=true;
           break;

      case 3:
           completed=false;
           break;

      default:
           completed=false;
           break;
    }
  }

  return completed;
}

    /** closes the acutal document */
public void closeDocument()
{
  deleteContents();
}

    /** initializes the document generally */
public boolean newDocument()
{
  /////////////////////////////////////////////////
  // TODO: Add your document initialization code here
  /////////////////////////////////////////////////
  modified=false;
  doc_url.setFileName(tr("Untitled"));

  return true;
}

    /** loads the document by filename and format and emits the updateViews() signal */
public boolean openDocument(KURL url, String format)
{
  StringBuffer tmpfile = new StringBuffer("");
  NetAccess.download( url, tmpfile );
  /////////////////////////////////////////////////
  // TODO: Add your document opening code here
  /////////////////////////////////////////////////

  NetAccess.removeTempFile( tmpfile.toString() );

  modified=false;
  return true;
}

public boolean openDocument(KURL url)
{
	return openDocument(url, null);
}

    /** saves the document under filename and format.*/
public boolean saveDocument(KURL url, String format)
{
  /////////////////////////////////////////////////
  // TODO: Add your document saving code here
  /////////////////////////////////////////////////

  modified=false;
  return true;
}

public boolean saveDocument(KURL url)
{
	return saveDocument(url, null);
}

    /** deletes the document's contents */
public void deleteContents()
{
  /////////////////////////////////////////////////
  // TODO: Add implementation to delete the document contents
  /////////////////////////////////////////////////

}

}
