/***************************************************************************
                            KTar.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**


 @author Torben Weis <weis@kde.org>, David Faure <faure@kde.org>
 
 @short A class for reading/writing (optionnally compressed) tar archives.

*/
public class KTar extends KArchive  {
	protected KTar(Class dummy){super((Class) null);}

	private native void newKTar( String filename, String mimetype);

/** 
 Creates an instance that operates on the given filename.
 using the compression filter associated to given mimetype.

*/
	public KTar( String filename, String mimetype) {
		super((Class) null);
		newKTar( filename, mimetype);
	}
	private native void newKTar( String filename);
	public KTar( String filename) {
		super((Class) null);
		newKTar( filename);
	}
	private native void newKTar( QIODeviceInterface dev);

/** 
 Creates an instance that operates on the given device.
 The device can be compressed (KFilterDev) or not (QFile, etc.).
 WARNING: don't assume that giving a QFile here will decompress the file,
 in case it's compressed!
     
*/
	public KTar( QIODeviceInterface dev) {
		super((Class) null);
		newKTar( dev);
	}

/** 
 If the tar ball is still opened, then it will be
 closed automatically by the destructor.
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 The name of the tar file, as passed to the constructor
 Null if you used the QIODevice constructor.
     
*/
	public native String fileName();

/** 
 Special function for setting the "original file name" in the gzip header,
 when writing a tar.gz file. It appears when using in the "file" command,
 for instance. Should only be called if the underlying device is a KFilterDev!
     
*/
	public native void setOrigFileName( String fileName);
	public native boolean writeDir( String name, String user, String group);
	public native boolean prepareWriting( String name, String user, String group, int size);
	public native boolean doneWriting( int size);

/** 
 Opens the archive for reading.
 Parses the directory listing of the archive
 and creates the KArchiveDirectory/KArchiveFile entries.

     
*/
	protected native boolean openArchive( int mode);
	protected native boolean closeArchive();
}
