package org.kde.koala;
import org.kde.qt.*;


/** {@link KSocket} emits these signals */
public interface KSocketSignals {
	void destroyed( QObject obj );

/**  
 Data has arrived for reading.

 This signal will only be raised if {@link KSocket#enableRead} was called
 first.
     
*/
	void readEvent( KSocket arg1 );

/**  
 Raised when the connection is broken.
     
*/
	void closeEvent( KSocket arg1 );

/**  
 Socket is ready for writing.

 This signal will only be raised if {@link KSocket#enableWrite} was 
 called first.

 Warning: If you forget to call enableWrite(false) when you are
 not ready to send data, you will get lots of writeEvent() signals,
 in the order of thousands a second !
     
*/
	void writeEvent( KSocket arg1 );
}

