/***************************************************************************
                            KLed.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**
 
 Displays a round  or rectangular light emitting diode.

 It is configurable to five colors, the two on/off states and three
 styles (or "looks");

 It may display itself in a performant flat view, a round view with
 light spot or a round view sunken in the screen.

 See {@link KLedSignals} for signals emitted by KLed.

 See {@link KLedEventHandling} for event handlers to override in subclasses of KLed.

 @author Joerg Habenicht, Richard J. Moore (rich@kde.org) 1998, 1999
 
 @short An LED widget.

*/
public class KLed extends QWidget  {
	protected KLed(Class dummy){super((Class) null);}

	private native void newKLed( QWidget parent, String name);

/** 
 Constructs a green, round LED widget which will initially
 be turned on.
   
*/
	public KLed( QWidget parent, String name) {
		super((Class) null);
		newKLed( parent, name);
	}
	private native void newKLed();
	public KLed() {
		super((Class) null);
		newKLed();
	}
	private native void newKLed( QColor col, QWidget parent, String name);

/** 
 Constructor with the ledcolor, the parent widget, and the name.

 The State will be defaulted On and the Look round.

*/
	public KLed( QColor col, QWidget parent, String name) {
		super((Class) null);
		newKLed( col, parent, name);
	}
//	private native void newKLed();
//	public KLed() {
//		super((Class) null);
//		newKLed();
//	}
	private native void newKLed( QColor col, int st, int look, int shape, QWidget parent, String name);

/** 
 Constructor with the ledcolor, ledstate, ledlook,
 the parent widget, and the name.

 Differs from above only in the parameters, which configure all settings.

*/
	public KLed( QColor col, int st, int look, int shape, QWidget parent, String name) {
		super((Class) null);
		newKLed( col, st, look, shape, parent, name);
	}
	private native void newKLed( QColor col, int st, int look, int shape);
	public KLed( QColor col, int st, int look, int shape) {
		super((Class) null);
		newKLed( col, st, look, shape);
	}

/** 
 Destructor

*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Returns the current state of the widget (on/off).

*/
	public native int state();
	public native int shape();

/** 
 Returns the color of the widget

*/
	public native QColor color();

/** 
 Returns the look of the widget.

*/
	public native int look();

/** 
 Returns the factor to darken the LED.

*/
	public native int darkFactor();

/** 
 Sets the state of the widget to On or Off.

 The widget will be painted immediately.

*/
	public native void setState( int state);

/** 
 Set the shape of the LED to <code>s.</code>
   
*/
	public native void setShape( int s);

/** 
 Toggle the state of the LED from Off to On and vice versa.

 The widget will be repainted when returning to the main
 event loop.

   
*/
	public native void toggleState();

/** 
 Set the color of the widget.
 The Color is shown with the KLed.On state.
 The KLed.Off state is shown with QColor.dark() method

 The widget calls the update() method, so it will
 be updated when entering the main event loop.

*/
	public native void setColor( QColor color);

/** 
 Sets the factor to darken the LED in OFF state.
 Same as {@link QColor#dark}.
 "darkfactor should be greater than 100, else the LED gets lighter
 in OFF state.
 Defaults to 300.

*/
	public native void setDarkFactor( int darkfactor);

/** 
 Sets the look of the widget.

 The look may be flat, round or sunken.
 The widget calls the update() method, so it will
 be updated when entering the main event loop.

*/
	public native void setLook( int look);
	public native QSize sizeHint();
	public native QSize minimumSizeHint();

/** 
 Toggles the state of the led from Off to On or vice versa.

 The widget repaints itself immediately.
   
*/
	public native void toggle();

/** 
 Sets the state of the widget to On.

 The widget will be painted immediately.

*/
	public native void on();

/** 
 Sets the state of the widget to Off.

 The widget will be painted immediately.

*/
	public native void off();

/** 
 Paints a circular, flat LED.
   
*/
	protected native void paintFlat();

/** 
 Paints a circular, raised LED.
   
*/
	protected native void paintRound();

/** 
 Paints a circular, sunken LED.
   
*/
	protected native void paintSunken();

/** 
 Paints a rectangular, flat LED.
   
*/
	protected native void paintRect();

/** 
 Paints a rectangular LED, either raised or 
 sunken, depending on its argument.
   
*/
	protected native void paintRectFrame( boolean raised);
	public static final int Off = 0;
	public static final int On = 1;
	public static final int Rectangular = 0;
	public static final int Circular = 1;
	public static final int Flat = 0;
	public static final int Raised = 1;
	public static final int Sunken = 2;
}
