/***************************************************************************
                            KFileIconView.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 An icon-view capable of showing {@link KFileItem}'s. Used in the filedialog
 for example. Most of the documentation is in {@link KFileView} class.

 See {@link KFileIconViewSignals} for signals emitted by KFileIconView.

 See {@link KFileIconViewEventHandling} for event handlers to override in subclasses of KFileIconView.

 @short 
 An icon-view capable of showing @ref KFileItem's.
*/
public class KFileIconView extends KIconView implements  KFileViewInterface {
	protected KFileIconView(Class dummy){super((Class) null);}

	private native void newKFileIconView( QWidget parent, String name);
	public KFileIconView( QWidget parent, String name) {
		super((Class) null);
		newKFileIconView( parent, name);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();
	public native QWidget widget();
	public native void clearView();
	public native void setAutoUpdate( boolean arg1);
	public native void updateView( boolean arg1);
	public native void updateView( KFileItem arg1);
	public native void removeItem( KFileItem arg1);
	public native void listingCompleted();
	public native void insertItem( KFileItem i);
	public native void setSelectionMode( int sm);
	public native void setSelected( KFileItem arg1, boolean arg2);
	public native boolean isSelected( KFileItem i);
	public native void clearSelection();
	public native void selectAll();
	public native void invertSelection();
	public native void setCurrentItem( KFileItem arg1);
	public native KFileItem currentFileItem();
	public native KFileItem firstFileItem();
	public native KFileItem nextItem( KFileItem arg1);
	public native KFileItem prevItem( KFileItem arg1);

/** 
 Sets the size of the icons to show. Defaults to {@link KIcon#SizeSmall}.
     
*/
	public native void setIconSize( int size);

/** 
 Sets the size of the previews. Defaults to {@link KIcon#SizeLarge}.
     
*/
	public native void setPreviewSize( int size);

/** 

*/
	public native int iconSize();
	public native void ensureItemVisible( KFileItem arg1);
	public native void setSorting( int sort);
	public native void readConfig( KConfig arg1, String group);
	public native void readConfig( KConfig arg1);
	public native void writeConfig( KConfig arg1, String group);
	public native void writeConfig( KConfig arg1);
	public native void mimeTypeDeterminationFinished();
	public native void determineIcon( KFileIconViewItem item);
	public native QScrollView scrollWidget();

/** 
 Starts loading previews for all files shown and shows them. Switches
 into 'large rows' mode, if that isn't the current mode yet.
     
*/
	public native void showPreviews();

/** 
 Reimplemented to not let QIconView eat return-key events
     
*/
	protected native void keyPressEvent( QKeyEvent arg1);

/** 
 Reimplemented to remove an eventual tooltip
     
*/
	protected native void hideEvent( QHideEvent arg1);
	public native void showEvent( QShowEvent arg1);
	
	// From KFileViewInterface
/**
 inserts a list of items.

*/
//	public native void addItemList( ArrayList list);


/**
 ### As const-method, to be fixed in 3.0

*/
//	public native QWidget widget();

/**
 Sets <code>filename</code> the current item in the view, if available.

*/
	public native void setCurrentItem( String filename);

/**
 Clears the view and all item lists.

*/
	public native void clear();

/**
 does a repaint of the view.

 The default implementation calls
 <pre>widget().repaint(f)</pre>

*/
	public native void updateView();


/**
 Returns the sorting order of the internal list. Newly added files
 are added through this sorting.

*/
	public native boolean sorting();


/**
 Tells whether the current items are in reversed order (shortcut to
 sorting() & QDir.Reversed).

*/
	public native boolean isReversed();
	public native void sortReversed();

/**

*/
	public native int count();

/**

*/
	public native int numFiles();

/**

*/
	public native int numDirs();
	public native int selectionMode();
	public native void setViewMode( int vm);
	public native int viewMode();

/**

*/
	public native String viewName();

/**
 Sets the name of the view, which could be displayed somewhere.
 E.g. "Image Preview".

*/
	public native void setViewName( String name);
	public native void setParentView( KFileViewInterface parent);


/**

*/
	public native ArrayList selectedItems();

/**

*/
	public native ArrayList items();

/**
 This is a KFileDialog specific hack: we want to select directories with
 single click, but not files. But as a generic class, we have to be able
 to select files on single click as well.

 This gives us the opportunity to do both.

 Every view has to decide when to call select( item ) when a file was
 single-clicked, based on {@link #onlyDoubleClickSelectsFiles}.

*/
	public native void setOnlyDoubleClickSelectsFiles( boolean enable);

/**

*/
	public native boolean onlyDoubleClickSelectsFiles();

/**
 increases the number of dirs and files.

*/
	public native boolean updateNumbers( KFileItem i);

/**

*/
	public native KActionCollection actionCollection();
	public native KFileViewSignaler signaler();
	public static native String sortingKey( String value, boolean isDir, int sortSpec);
	public static native String sortingKey( int value, boolean isDir, int sortSpec);

}
