/***************************************************************************
                            KAboutData.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This class is used to store information about a program. It can store
 such values as version number, program name, home page, email address
 for bug reporting, multiple authors and contributors
 (using {@link KAboutPerson}), license and copyright information.

 Currently, the values set here are shown by the "About" box
 (see {@link KAboutDialog}), used by the bug report dialog (see {@link KBugReport}),
 and by the help shown on command line (see {@link KCmdLineArgs}).

 @author Espen Sand (espen@kde.org), David Faure (faure@kde.org)

 @version $Id: KAboutData.java,v 1.5 2002/01/31 04:48:54 rdale Exp $
 
 @short Holds information needed by the "About" box and other
 classes.

*/
public class  KAboutData implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KAboutData(Class dummy){}

	private native void newKAboutData( String appName, String programName, String version, String shortDescription, int licenseType, String copyrightStatement, String text, String homePageAddress, String bugsEmailAddress);

/** 
 Constructor.

     
*/
	public KAboutData( String appName, String programName, String version, String shortDescription, int licenseType, String copyrightStatement, String text, String homePageAddress, String bugsEmailAddress) {
		newKAboutData( appName, programName, version, shortDescription, licenseType, copyrightStatement, text, homePageAddress, bugsEmailAddress);
	}
	public KAboutData( String appName, String programName, String version, String shortDescription, int licenseType, String copyrightStatement) {
		newKAboutData( appName, programName, version, shortDescription, licenseType, copyrightStatement, null, null, null);
	}
	private native void newKAboutData( String appName, String programName, String version);
	public KAboutData( String appName, String programName, String version) {
		newKAboutData( appName, programName, version);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Defines an author. You can call this function as many times you
 need. Each entry is appended to a list. The person in the first entry
 is assumed to be the leader of the project.

     
*/
	public native void addAuthor( String name, String task, String emailAddress, String webAddress);
	public void addAuthor( String name, String task, String emailAddress)
	{
		addAuthor(name, task, emailAddress, null);
		return;
	}
	public native void addAuthor( String name);

/** 
 Defines a person that deserves credit. You can call this function
 as many times you need. Each entry is appended to a list.

     
*/
	public native void addCredit( String name, String task, String emailAddress, String webAddress);
	public native void addCredit( String name);

/** 
 Sets the name of the translator of the gui. Since this depends
 on the language, just use a dummy text marked for translation.

 For example:
 setTranslator(I18N_NOOP("_: NAME OF TRANSLATORS\nYour names")
 ,I18N_NOOP("_: EMAIL OF TRANSLATORS\nYour emails"));

 The translator can then translate this dummy text with his name
 or with a list of names separated with ",".
 If there is no translation or the application is used with the
 default language, this function call is ignored.

 Note: If you are using the default KDE automake environment,
 there is no need to use this function, because the two
 default strings above are added to the applications po file
 automatically.

*/
	public native void setTranslator( String name, String emailAddress);

/** 
 Defines a licence text.

 The text will be translated if it got marked for
 translations with the I18N_NOOP() macro.

 Example:
 setLicenseText( I18N_NOOP("This is my license"));

 NOTE: No copy of the text is made.
     
*/
	public native void setLicenseText( String license);

/** 
 Defines a licence text. 

*/
	public native void setLicenseTextFile( String file);

/** 

*/
	public native String appName();

/** 

*/
	public native String programName();

/** 

*/
	public native String version();

/** 

*/
	public native String shortDescription();

/** 

*/
	public native String homepage();

/** 

*/
	public native String bugAddress();

/** 

*/
//	public native QValueList<KAboutPerson> authors();

/** 

*/
//	public native QValueList<KAboutPerson> credits();

/** 

*/
//	public native QValueList<KAboutTranslator> translators();

/** 

*/
	public native String otherText();

/** 
 Returns the license. If the licenseType argument of the constructor has been
 used, any text defined by {@link setLicenseText} is ignored,
 and the standard text for the chosen license will be returned.

*/
	public native String license();

/** 

*/
	public native String copyrightStatement();

/**  

*/
	public static native String aboutTranslationTeam();
	public static final int License_Custom = -2;
	public static final int License_File = -1;
	public static final int License_Unknown = 0;
	public static final int License_GPL = 1;
	public static final int License_GPL_V2 = 1;
	public static final int License_LGPL = 2;
	public static final int License_LGPL_V2 = 2;
	public static final int License_BSD = 3;
	public static final int License_Artistic = 4;
	public static final int License_QPL = 5;
	public static final int License_QPL_V1_0 = 5;
}
