/***************************************************************************
                            kde_KURLRequester.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KURLREQUESTER
#define KDE_KURLREQUESTER

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 This class is a widget showing a lineedit and a button, which invokes a
 filedialog. File name completion is available in the lineedit.

 The defaults for the filedialog are to ask for one existing local file, i.e.
 KFileDialog::setMode( KFile::File | KFile::ExistingOnly | KFile::LocalOnly )
 The default filter is "*", i.e. show all files, and the start directory is
 the current working directory, or the last directory where a file has been
 selected.

 You can change this behavior by using @ref setMode() or @ref setFilter().

 @author Carsten Pfeiffer <pfeiffer@kde.org>
 
 @short A widget to request a filename/url from the user.
*/

/** 
 Constructs a KURLRequester widget.
     
*/
kde_KURLRequester * kde_new_KURLRequester(qt_QWidget * parent, char* name);

/** 
 Constructs a KURLRequester widget with the initial URL @p url.
     
*/
kde_KURLRequester * kde_new_KURLRequester1(qt_QString * url, qt_QWidget * parent, char* name);

/** 
 Special constructor, which creates a KURLRequester widget with a custom
 edit-widget. The edit-widget can be either a KComboBox or a KLineEdit
 (or inherited thereof). Note: for geometry management reasons, the
 edit-widget is reparented to have the KURLRequester as parent.

*/
kde_KURLRequester * kde_new_KURLRequester2(qt_QWidget * editWidget, qt_QWidget * parent, char* name);

/** 
 Destructs the KURLRequester.
     
*/
void kde_del_KURLRequester( kde_KURLRequester* p );

/** 

*/
qt_QString * kde_KURLRequester_url(kde_KURLRequester* instPointer);

/** 
 Enables/disables showing file:/ in the lineedit, when a local file has
 been selected in the filedialog or was set via @ref setURL().
 Default is false, not showing file:/

*/
void kde_KURLRequester_setShowLocalProtocol(kde_KURLRequester* instPointer,int b);

/** 
 Sets the mode of the file dialog.
 Note: you can only select one file with the filedialog,
 so KFile::Files doesn't make much sense.

*/
void kde_KURLRequester_setMode(kde_KURLRequester* instPointer,unsigned int m);

/** 
 Sets the filter for the file dialog.

*/
void kde_KURLRequester_setFilter(kde_KURLRequester* instPointer,qt_QString * filter);

/** 

*/
int kde_KURLRequester_showLocalProtocol(kde_KURLRequester* instPointer);

/** 

*/
kde_KFileDialog* kde_KURLRequester_fileDialog(kde_KURLRequester* instPointer);

/** 

 It is provided so that you can e.g. set an own completion object
 (e.g. @ref KShellCompletion) into it.
     
*/
kde_KLineEdit* kde_KURLRequester_lineEdit(kde_KURLRequester* instPointer);

/** 

*/
kde_KComboBox* kde_KURLRequester_comboBox(kde_KURLRequester* instPointer);

/** 

*/
qt_QPushButton* kde_KURLRequester_button(kde_KURLRequester* instPointer);

/** 

*/
kde_KURLCompletion* kde_KURLRequester_completionObject(kde_KURLRequester* instPointer);

/** 
 Sets the url in the lineedit to @p url. Depending on the state of
 @ref showLocalProtocol(), file:/ on local files will be shown or not.
     
*/
void kde_KURLRequester_setURL(kde_KURLRequester* instPointer,qt_QString * url);

/** 
 Clears the lineedit/combobox.
     
*/
void kde_KURLRequester_clear(kde_KURLRequester* instPointer);
void kde_KURLRequester_init(kde_KURLRequester* instPointer);

/** 
 Called when the button is pressed to open the filedialog.
 Also called when @ref KStdAccel::Open (default is Ctrl-O) is pressed.
     
*/
void kde_KURLRequester_slotOpenDialog(kde_KURLRequester* instPointer);

#endif
