/***************************************************************************
                            kde_KURIFilterData.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KURIFILTERDATA
#define KDE_KURIFILTERDATA

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 This is a basic message object used for exchanging filtering
 information between the filter plugins and the application
 whenever the application requires more information about the
 URI than just a filtered version of it.  Any application can
 create an instance of this class and send it to @ref KURIFilter
 to have the filter plugins fill the necessary information.

 The above code should yield the following output:
 <pre>
   URI: kde.org
   Filtered URI: http://kde.org
   URI Type: 0            <== means NET_PROTOCOL
   Was Filtered: 1        <== means the URL was successfully filtered
 </pre>

 @short A message object for exchanging filtering URI info.

*/
#define KURIFILTERDATA_NET_PROTOCOL	0
#define KURIFILTERDATA_LOCAL_FILE	0
#define KURIFILTERDATA_LOCAL_DIR	1
#define KURIFILTERDATA_EXECUTABLE	2
#define KURIFILTERDATA_HELP	3
#define KURIFILTERDATA_SHELL	4
#define KURIFILTERDATA_BLOCKED	5
#define KURIFILTERDATA_ERROR	6
#define KURIFILTERDATA_UNKNOWN	7

/** 
 Default constructor.

 Creates a URIFilterData object.
     
*/
kde_KURIFilterData * kde_new_KURIFilterData();

/** 
 Creates a URIFilterData object from the given URL.

*/
kde_KURIFilterData * kde_new_KURIFilterData1(kde_KURL* url);

/** 
 Creates a URIFilterData object from the given string.

*/
kde_KURIFilterData * kde_new_KURIFilterData2(qt_QString * url);

/** 
 Copy constructor.

 Creates a URIFilterData object from another
 URI filter data object.

*/
kde_KURIFilterData * kde_new_KURIFilterData3(kde_KURIFilterData* arg1);

/** 
 Destructor.
     
*/
void kde_del_KURIFilterData( kde_KURIFilterData* p );

/** 
 This method has been deprecated and will always return
 TRUE.  You should instead use the result from the
 @ref KURIFilter::filterURI() calls.

     
*/
int kde_KURIFilterData_hasBeenFiltered(kde_KURIFilterData* instPointer);

/** 
 Returns the filtered or the original URL.

 This function returns the filtered url if one
 of the plugins sucessfully filtered the original
 URL.  Otherwise, it returns the original URL.
 See @ref #hasBeenFiltered() and

*/
kde_KURL* kde_KURIFilterData_uri(kde_KURIFilterData* instPointer);

/** 
 Returns an error message.

 This functions returns the error message set
 by the plugin whenever the uri type is set to
 KURIFilterData::ERROR.  Otherwise, it returns
 a QString::null.

*/
qt_QString * kde_KURIFilterData_errorMsg(kde_KURIFilterData* instPointer);

/** 
 Returns the URI type.

 This method always returns KURIFilterData::UNKNOWN
 if the given URL was not filtered.
     
*/
int kde_KURIFilterData_uriType(kde_KURIFilterData* instPointer);

/** 
 Sets the URL to be filtered.

 Use this function to set the string to be
 filtered when you construct an empty filter
 object.

*/
void kde_KURIFilterData_setData(kde_KURIFilterData* instPointer,qt_QString * url);

/** 
 Same as above except the argument is a URL.

 Use this function to set the string to be
 filtered when you construct an empty filter
 object.

*/
void kde_KURIFilterData_setData1(kde_KURIFilterData* instPointer,kde_KURL* url);

/** 
 Sets the absolute path to be used whenever the supplied
 data is a relative local URL.

 NOTE: This function works only for a local resource and
 expects the absolute path to the relative URL set in this
 meta object.  If you are extracting the absolute path from
 a KURL object, make sure you always set the argument below
 using KURL::path() instead of KURL::url() so that "file:/"
 would not be appended! Otherwise, the filter might not be
 able to make correct determination whether the relative URL
 locally exists!

*/
int kde_KURIFilterData_setAbsolutePath(kde_KURIFilterData* instPointer,qt_QString * arg1);

/** 
 Returns the absolute path if one has already been set.
     
*/
qt_QString * kde_KURIFilterData_absolutePath(kde_KURIFilterData* instPointer);

/** 
 Returns true if the supplied data has an absolute path.
     
*/
int kde_KURIFilterData_hasAbsolutePath(kde_KURIFilterData* instPointer);

/** 
 Returns the command line options and arguments for a
 local resource when present.

*/
qt_QString * kde_KURIFilterData_argsAndOptions(kde_KURIFilterData* instPointer);

/** 
 Returns true if the current data is a local resource with
 command line options and arguments.
     
*/
int kde_KURIFilterData_hasArgsAndOptions(kde_KURIFilterData* instPointer);

/** 
 Returns the name of the icon that matches
 the current filtered URL.

 NOTE that this function will return a NULL
 string by default and when no associated icon
 is found.

*/
qt_QString * kde_KURIFilterData_iconName(kde_KURIFilterData* instPointer);

/** 
 Initializes the KURIFilterData on construction.
     
*/
void kde_KURIFilterData_init(kde_KURIFilterData* instPointer,kde_KURL* url);

#endif
