/***************************************************************************
                            kde_KStartupInfoId.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KSTARTUPINFOID
#define KDE_KSTARTUPINFOID

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Class representing an identification of application startup notification.

 Every existing notification about a starting application has its own unique
 identification, that's used to identify and manipulate the notification.

 @author Lubos Lunak <l.lunak@kde.org>

 @version $Id: kde_KStartupInfoId.h,v 1.3 2002/02/21 00:43:13 rdale Exp $
 
 @short 
 Class representing an identification of application startup notification.
*/

/** 

*/
int kde_KStartupInfoId_none(kde_KStartupInfoId* instPointer);

/** 
 Initializes this object with the given identification ( which may be also "0"
 for no notification ), or if "" is given, tries to read it from the startup
 notification environment variable, and if it's not set, creates a new one.
	 
*/
void kde_KStartupInfoId_initId(kde_KStartupInfoId* instPointer,qt_QCString* identifier);

/** 

*/
qt_QCString* kde_KStartupInfoId_id(kde_KStartupInfoId* instPointer);

/** 
 Sets the startup notification environment variable to this identification.
	 
*/
int kde_KStartupInfoId_setupStartupEnv(kde_KStartupInfoId* instPointer);

/** 
 Creates an empty identification
	 
*/
kde_KStartupInfoId * kde_new_KStartupInfoId();
kde_KStartupInfoId * kde_new_KStartupInfoId1(kde_KStartupInfoId* data);
void kde_del_KStartupInfoId( kde_KStartupInfoId* p );

#endif
