/***************************************************************************
                            kde_KSpell.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KSPELL
#define KDE_KSPELL

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 KDE Spellchecker

 A KDE programmer's interface to International ISpell 3.1.  (GPL 1997)
 A static method, @ref modalCheck() is provided for convenient
  access to the spellchecker.

 @author David Sweet <dsweet@kde.org>

 @version $Id: kde_KSpell.h,v 1.3 2002/02/21 00:43:13 rdale Exp $

 @short 
 KDE Spellchecker

*/
#define KSPELL_Starting	0
#define KSPELL_Running	0
#define KSPELL_Cleaning	1
#define KSPELL_Finished	2
#define KSPELL_Error	3
#define KSPELL_Crashed	4

/** 
 Starts the spellchecker.

 KSpell emits @ref ready() when it has verified that 
 ISpell/ASpell is working properly. Pass the name of a slot -- do not pass zero!
 Be sure to call @ref cleanUp() when you are done with KSpell.

 If KSpell could not be started correctly, @ref death() is emitted.

*/
kde_KSpell * kde_new_KSpell(qt_QWidget * _parent, qt_QString * _caption, qt_QObject * obj, char* slot, kde_KSpellConfig* _kcs, int _progressbar, int _modal);

/** 
 Returns the status of KSpell.

*/
int kde_KSpell_status(kde_KSpell* instPointer);

/** 
 Cleans up ISpell.

 Write out the personal dictionary and close ISpell's
  stdin.  A @ref death() signal will be emitted when the cleanup is
  complete, but this method will return immediately.

*/
void kde_KSpell_cleanUp(kde_KSpell* instPointer);

/**  
 Sets the auto-delete flag. If this is set, the KSpell object
 is automatically deleted after emitting @ref death().
   
*/
void kde_KSpell_setAutoDelete(kde_KSpell* instPointer,int _autoDelete);

/** 
  Spellchecks a buffer of many words in plain text 
  format.

 The @p _buffer is not modified.  The signal @ref done() will be
  sent when @ref check() is finished and the argument will be a 
  spell-corrected version of @p _buffer.  

 The spell check may be stopped by the user before the entire buffer
  has been checked.  You can check @ref lastPosition() to see how far
  in @p _buffer @ref check() reached before stopping.
   
*/
int kde_KSpell_check(kde_KSpell* instPointer,qt_QString * _buffer);

/** 
 Returns the position (when using @ref check())  or word 
 number (when using @ref checkList()) of
 the last word checked.

*/
int kde_KSpell_lastPosition(kde_KSpell* instPointer);

/** 
 Spellchecks a list of words.

 @ref checkList() is more flexible than @ref check().  You could parse
  any type
  of document (HTML, TeX, etc.) into a list of spell-checkable words
  and send the list to @ref checkList().  Sending a marked-up document
  to @ref check() would result in the mark-up tags being
  spell checked.
   
*/
int kde_KSpell_checkList(kde_KSpell* instPointer,qt_QStringList* _wordlist);

/** 
 Spellchecks a single word.

 checkWord() is the most flexible function.  Some applications
  might need this flexibility but will sacrifice speed when
  checking large numbers of words.  Consider @ref checkList() for
  checking many words.

  Use this method for implementing  "online" spellchecking (i.e.,
  spellcheck as-you-type).

 checkWord() returns @p false if @p buffer is not a single word (e.g.
  if it contains white space), otherwise it returns @p true;

 If @p usedialog is set to @p true, KSpell will open the standard
  dialog if the word is not found.  The dialog results can be queried
  by using  @ref dlgResult() and @ref replacement(). 

  The signal @ref corrected() is emitted when the check is
  complete.  You can look at @ref suggestions() to see what the
  suggested replacements were. 
   
*/
int kde_KSpell_checkWord(kde_KSpell* instPointer,qt_QString * _buffer, int usedialog);

/** 
 Hides the dialog box.

 You'll need to do this when you are done with @ref checkWord();
   
*/
void kde_KSpell_hide(kde_KSpell* instPointer);

/** 
 Returns list of suggested word replacements.

 After calling @ref checkWord() (an in response to
  a @ref misspelled() signal you can
  use this to get the list of
  suggestions (if any were available).
   
*/
qt_QStringList* kde_KSpell_suggestions(kde_KSpell* instPointer);

/** 
 Gets the result code of the dialog box.

 After calling checkWord, you can use this to get the dialog box's
  result code.
 The possible
  values are (from kspelldlg.h):

   
*/
int kde_KSpell_dlgResult(kde_KSpell* instPointer);

/** 
 Moves the dialog.

 If the dialog is not currently visible, it will
   be placed at this position when it becomes visible.
 Use this to get the dialog out of the way of a highlighted
 misspelled word in a document.
   
*/
void kde_KSpell_moveDlg(kde_KSpell* instPointer,int x, int y);

/** 
 Returns the height of the dialog box.

*/
int kde_KSpell_heightDlg(kde_KSpell* instPointer);

/** 
 Returns the width of the dialog box.

*/
int kde_KSpell_widthDlg(kde_KSpell* instPointer);

/** 
 Returns the partially spellchecked buffer.

 You might want the full buffer in its partially-checked state.
   
*/
qt_QString * kde_KSpell_intermediateBuffer(kde_KSpell* instPointer);

/** 
 Tells ISpell/ASpell to ignore this word for the life of this KSpell instance.

  @ref ignore() returns @p false if word is not a word or there was an error
  communicating with ISpell/ASpell.
   
*/
int kde_KSpell_ignore(kde_KSpell* instPointer,qt_QString * word);

/** 
 Adds a word to the user's personal dictionary. 

 Returns @p false if @p word
  is not a word or there was an error communicating with ISpell/ASpell.
   
*/
int kde_KSpell_addPersonal(kde_KSpell* instPointer,qt_QString * word);

/** 
 Retrurns the @ref KSpellConfig object being used by this KSpell instance.
   
*/
kde_KSpellConfig* kde_KSpell_ksConfig(kde_KSpell* instPointer);

/** 
 Sets the resolution (in percent) of the @ref progress() signals.

 E.g. @ref setProgressResolution (10) instructs KSpell to send progress
  signals (at most) every 10% (10%, 20%, 30%...).
 The default is 10%.
   
*/
void kde_KSpell_setProgressResolution(kde_KSpell* instPointer,unsigned int res);

/** 
 The destructor instructs ISpell/ASpell to write out the personal
  dictionary and then terminates ISpell/ASpell.
   
*/
void kde_del_KSpell( kde_KSpell* p );
void kde_KSpell_setIgnoreUpperWords(kde_KSpell* instPointer,int _b);
void kde_KSpell_setIgnoreTitleCase(kde_KSpell* instPointer,int _b);

/** 
 Performs a sychronous spellcheck.

 This method does not return until spellchecking is done or canceled.
 Your application's GUI will still be updated, however.
   
*/
int kde_KSpell_modalCheck( qt_QString * text);

/** 
 Used local spell config
   
*/
int kde_KSpell_modalCheck1( qt_QString * text, kde_KSpellConfig* _kcs);
int kde_KSpell_parseOneResponse(kde_KSpell* instPointer,qt_QString * _buffer, qt_QString * word, qt_QStringList* sugg);
qt_QString * kde_KSpell_funnyWord(kde_KSpell* instPointer,qt_QString * word);
void kde_KSpell_dialog(kde_KSpell* instPointer,qt_QString * word, qt_QStringList* sugg, char* _slot);
qt_QString * kde_KSpell_replacement(kde_KSpell* instPointer);
void kde_KSpell_setUpDialog(kde_KSpell* instPointer,int reallyusedialogbox);
void kde_KSpell_emitProgress(kde_KSpell* instPointer);
int kde_KSpell_cleanFputs(kde_KSpell* instPointer,qt_QString * s, int appendCR);
int kde_KSpell_cleanFputsWord(kde_KSpell* instPointer,qt_QString * s, int appendCR);
void kde_KSpell_startIspell(kde_KSpell* instPointer);
int kde_KSpell_writePersonalDictionary(kde_KSpell* instPointer);
void kde_KSpell_KSpell2(kde_KSpell* instPointer,kde_KProcIO* arg1);
void kde_KSpell_checkWord2(kde_KSpell* instPointer,kde_KProcIO* arg1);
void kde_KSpell_checkWord3(kde_KSpell* instPointer);
void kde_KSpell_check2(kde_KSpell* instPointer,kde_KProcIO* arg1);
void kde_KSpell_checkList2(kde_KSpell* instPointer);
void kde_KSpell_checkList3a(kde_KSpell* instPointer,kde_KProcIO* arg1);
void kde_KSpell_checkListReplaceCurrent(kde_KSpell* instPointer);
void kde_KSpell_checkList4(kde_KSpell* instPointer);
void kde_KSpell_dialog2(kde_KSpell* instPointer,int dlgresult);
void kde_KSpell_check3(kde_KSpell* instPointer);
void kde_KSpell_slotStopCancel(kde_KSpell* instPointer,int arg1);
void kde_KSpell_ispellExit(kde_KSpell* instPointer,kde_KProcess* arg1);
void kde_KSpell_emitDeath(kde_KSpell* instPointer);
void kde_KSpell_ispellErrors(kde_KSpell* instPointer,kde_KProcess* arg1, char* arg2, int arg3);

#endif
