/***************************************************************************
                            kde_KPalette.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KPALETTE
#define KDE_KPALETTE

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Class for handling Palettes.

 This class makes it easy to handle palettes.
 A palette is a set of colors. This class can read
 and write palettes from and to a file.

 This class uses the "GIMP" palette file format.

 This class is totally unrelated to QPalette.

 @author Waldo Bastian (bastian@kde.org)

 @version $Id: kde_KPalette.h,v 1.3 2002/02/21 00:43:12 rdale Exp $

 @short 
 Class for handling Palettes.
*/
#define KPALETTE_Yes	0
#define KPALETTE_No	1
#define KPALETTE_Ask	2

/** 
 KPalette constructor. Creates a KPalette from a file
 the filename is derived from the name.

*/
kde_KPalette * kde_new_KPalette(qt_QString * name);

/** 
 KPalette copy constructor.

*/
kde_KPalette * kde_new_KPalette1(kde_KPalette* arg1);

/** 
 KPalette destructor.

*/
void kde_del_KPalette( kde_KPalette* p );

/** 
 Save the palette

*/
int kde_KPalette_save(kde_KPalette* instPointer);

/** 
 Get the description of the palette.

*/
qt_QString * kde_KPalette_description(kde_KPalette* instPointer);

/**    	
 Set the description of the palette.

*/
void kde_KPalette_setDescription(kde_KPalette* instPointer,qt_QString * desc);

/** 
 Get the name of the palette. 

*/
qt_QString * kde_KPalette_name(kde_KPalette* instPointer);

/** 
 Set the name of the palette.

*/
void kde_KPalette_setName(kde_KPalette* instPointer,qt_QString * name);

/** 
 Returns whether the palette may be edited.

*/
int kde_KPalette_editable(kde_KPalette* instPointer);

/** 
 Change whether the palette may be edited.

*/
void kde_KPalette_setEditable(kde_KPalette* instPointer,int editable);

/** 
 Return the number of colors in the palette.

*/
int kde_KPalette_nrColors(kde_KPalette* instPointer);

/** 
 Find color by index.

*/
qt_QColor * kde_KPalette_color(kde_KPalette* instPointer,int index);

/** 
 Find index by @p color.

*/
int kde_KPalette_findColor(kde_KPalette* instPointer,qt_QColor * color);

/**  
 Find color name by @p index.

*/
qt_QString * kde_KPalette_colorName(kde_KPalette* instPointer,int index);

/** 
 Find color name by @p color.

*/
qt_QString * kde_KPalette_colorName1(kde_KPalette* instPointer,qt_QColor * color);

/** 
 Add a color.

*/
int kde_KPalette_addColor(kde_KPalette* instPointer,qt_QColor * newColor, qt_QString * newColorName);

/** 
 Change a color.

*/
int kde_KPalette_changeColor(kde_KPalette* instPointer,int index, qt_QColor * newColor, qt_QString * newColorName);

/** 
 Change a color.

*/
int kde_KPalette_changeColor1(kde_KPalette* instPointer,qt_QColor * oldColor, qt_QColor * newColor, qt_QString * newColorName);

/** 
 Query which KDE palettes are installed.

*/
qt_QStringList* kde_KPalette_getPaletteList( );

#endif
