/***************************************************************************
                            kde_KConfigGroupSaver.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KCONFIGGROUPSAVER
#define KDE_KCONFIGGROUPSAVER

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Helper class to facilitate working with @ref KConfig / @ref KSimpleConfig
 groups.

 Careful programmers always set the group of a
 @ref KConfig @ref KSimpleConfig object to the group they want to read from
 and set it back to the old one of afterwards. This is usually
 written as:
 <pre>

 QString oldgroup config->group();
 config->setGroup( "TheGroupThatIWant" );
 ...
 config->writeEntry( "Blah", "Blubb" );

 config->setGroup( oldgroup );
 </pre>

 In order to facilitate this task, you can use
 KConfigGroupSaver. Simply construct such an object ON THE STACK
 when you want to switch to a new group. Then, when the object goes
 out of scope, the group will automatically be restored. If you
 want to use several different groups within a function or method,
 you can still use KConfigGroupSaver: Simply enclose all work with
 one group (including the creation of the KConfigGroupSaver object)
 in one block.

 @author Matthias Kalle Dalheimer <kalle@kde.org>

 @version $Id: kde_KConfigGroupSaver.h,v 1.3 2002/02/21 00:43:09 rdale Exp $

 @short Helper class for easier use of KConfig/KSimpleConfig groups.
*/
void kde_del_KConfigGroupSaver( kde_KConfigGroupSaver* p );
kde_KConfigBase* kde_KConfigGroupSaver_config(kde_KConfigGroupSaver* instPointer);

#endif
