/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <qvalidator.h>

#include <kapplication.h>
#include <khelpmenu.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kglobal.h>
#include <kfiledialog.h>
#include <kprocess.h>
#include <kstandarddirs.h>
#include <kmessagebox.h>
#include <kpopupmenu.h>
#include <klineeditdlg.h>

#include "panelop_mnu.h"
#include "panelop_mnu.moc"

#include "addcontainer_mnu.h"
#include "removecontainer_mnu.h"
#include "panel.h"
#include "containerarea.h"
#include "global.h"
#include "kicker.h"

PanelOpMenu::PanelOpMenu( ::Panel* panel, QWidget* parent )
    : QPopupMenu( parent, "PanelOpMenu" )
    , _panel( panel )
    , sizeMnu( 0 )
{
    if (!Kicker::kicker()->isImmutable())
    {
        // setup size menu
        sizeMnu = new QPopupMenu(this);
        sizeMnu->insertItem(i18n("Tiny"), ::Tiny);
        sizeMnu->insertItem(i18n("Small"), ::Small);
        sizeMnu->insertItem(i18n("Normal"), ::Normal);
        sizeMnu->insertItem(i18n("Large"), ::Large);
        // FIXME: i18n("Custom") + "..." -> i18n("Custom...") after translation unfreeze
        sizeMnu->insertItem(i18n("Custom") + "...", ::Custom);
        connect(sizeMnu, SIGNAL(aboutToShow()), SLOT(slotSetupSizeMnu()));
        connect(sizeMnu, SIGNAL(activated(int)), SLOT(slotSetSize(int)));

        // build menu
        insertItem(i18n("&Add"),
		   new AddContainerMenu( _panel->containerArea(), TRUE, this));
	insertItem(i18n("&Remove"),
		   new RemoveContainerMenu( _panel->containerArea(), TRUE, this));
        insertSeparator();
        insertItem(i18n("Si&ze"), sizeMnu);

        insertItem(SmallIconSet("configure"), i18n("&Preferences..."),
		   this, SLOT(slotConfigure()));
        insertSeparator();
    }

    KHelpMenu* help = new KHelpMenu( _panel, KGlobal::instance()->aboutData(), false);
    insertItem(SmallIconSet("help"), i18n("&Help"), help->menu());

    adjustSize();
}

void PanelOpMenu::slotSetupSizeMnu()
{
    sizeMnu->setItemChecked(::Tiny,false);
    sizeMnu->setItemChecked(::Small,false);
    sizeMnu->setItemChecked(::Normal,false);
    sizeMnu->setItemChecked(::Large,false);
    sizeMnu->setItemChecked(::Custom,false);
    sizeMnu->setItemChecked(_panel->size(),true);
}

void PanelOpMenu::slotSetSize(int size)
{
    if( static_cast<Size>(size) == ::Custom ) {
        bool ok = false;
        QIntValidator validator( MIN_PANEL_SIZE, MAX_PANEL_SIZE, 0 );
        // FIXME: i18n("Size") + ":" -> i18n("Size:") after translation unfreeze
        QString result = KLineEditDlg::getText( i18n("Size") + ":",
             QString::number(_panel->panelSize()), &ok, _panel, &validator );
        if( !ok ) return;
        _panel->setSize( result.toInt() );
    } else {
        _panel->setSize(sizeValue(static_cast<Size>(size)));
    }
}

void PanelOpMenu::slotConfigure()
{
    QStringList args;
    QString prog = locate("exe", "kcmshell");
    args << "panel";
    args << "kcmtaskbar";
    kapp->kdeinitExec(prog, args);
}

