/*****************************************************************

Copyright (c) 2001 John Firebaugh <jfirebaugh@kde.org>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __taskbarcontainer_h__
#define __taskbarcontainer_h__

#include <kpanelapplet.h>
#include <kpanelextension.h>

#include "fittslawframe.h"

class QBoxLayout;

class KArrowButton;

class TaskBar;

class TaskBarContainer : public FittsLawFrame
{
    Q_OBJECT

public:
    TaskBarContainer( bool enableFrame, QWidget* parent = 0, const char* name = 0 );
    ~TaskBarContainer();

    void orientationChange( Orientation );
    // FIXME: need a globally defined enum Direction
    void popupDirectionChange( KPanelApplet::Direction );

    void preferences();
    // FIXME: need a globally defined enum Position
    QSize sizeHint( KPanelExtension::Position, QSize maxSize ) const;

signals:
    void containerCountChanged();

protected slots:
    void configure();
    void showWindowListMenu();
    void windowListMenuAboutToHide();

private:
    KPanelApplet::Direction      direction;
    bool                         showWindowListButton;
    QBoxLayout *                 layout;
    TaskBar *                    taskBar;
    KArrowButton *               windowListButton;
};

#endif
