/* This file is part of KDE PIM
   Copyright (C) 1999 Don Sanders <sanders@kde.org>

   License: BSD
*/

#ifndef UNDO_H 
#define UNDO_H 

#include <qptrstack.h>
#include <qstring.h>
#include <qobject.h>

class Command
{
public:
  virtual ~Command() {};
  virtual QString name() { return ""; };
  virtual void redo() {}; // egcs requires these methods to have 
  virtual void undo() {}; // implementations (Seems like a bug)
};

class StackBase : public QObject, protected QPtrStack< Command >
{
    Q_OBJECT
public:
  StackBase();

  void push( Command *command );
  Command *pop();
  void clear();

signals:
  void stackActionAvailable( bool yes );
};

class UndoStack : public StackBase
{
    Q_OBJECT
public:
  static UndoStack *instance();
  void undo();

protected:
  UndoStack();
  static UndoStack* instance_;
};

class RedoStack : public StackBase
{
    Q_OBJECT
public:
  static RedoStack *instance();
  void redo();

protected:
  RedoStack();
  static RedoStack* instance_;
};

#endif
