/************************************
 Contact detaching functions
 (c) 2002 Jeremy Wise
 GnomeICU
*************************************/

#include "common.h"
#include "detach.h"
#include "dragdrop.h"
#include "gnomeicu.h"
#include "gtkfunc.h"
#include "icons.h"
#include "response.h"
#include "util.h"

void detach_window_click( GtkWidget *widget, GdkEventButton *event, gpointer data )
{
    CONTACT_PTR contact = gtk_object_get_data( GTK_OBJECT( widget ), "contact" );
    GdkEventButton *new_event = g_new0( GdkEventButton, 1 );
    GSList *contact_list = NULL;

    /* Exit if not the left or right mouse buttons */
    if( event->button != 3 && event->button != 1 ) return;

    /* Forge the current listbox according to user status */
    select_clist_row_from_contact( contact );

    contact_list = g_slist_append( contact_list, contact );

/* Commented by jwise 1/13/02 -- does this do anything?? */
/*    if( (event->button == 3) && (event->type == GDK_BUTTON_PRESS) )
    {
        new_event->type = GDK_KEY_PRESS;
        ((GdkEventKey*)new_event)->keyval = ' ';
        icq_sendmessage_window( MainData->lb_userwin, new_event, contact_list );
    }
    else*/
    if( (event->button == 1) && (event->type == GDK_2BUTTON_PRESS) )
        show_contact_message (contact_list);

    /* Return the list box, and free the stuff */
    g_free( new_event );
}

gint detach_window_delete( GtkWidget *widget, GdkEvent *event, gpointer data )
{
    gtk_widget_hide( widget );
    return( TRUE );
}

void detach_contact_hide( GtkWidget *widget, gpointer data )
{
    CONTACT_PTR contact = (CONTACT_PTR)data;

    if( !GTK_WIDGET_VISIBLE( contact->detached_window ) )
    {
        gtk_widget_show( GTK_WIDGET( contact->detached_window ) );
    }
    else
    {
        gtk_widget_hide( GTK_WIDGET( contact->detached_window ) );
    }
}

void detach_contact( GtkWidget *widget, gpointer data )
{
    // GSList *contact_list = get_contact_from_clist();
    CONTACT_PTR contact = (CONTACT_PTR)data;
    GnomeWinState state;
    GnomeWinHints hints;
    GtkWidget *window, *label, *hbox, *gtk_pixmap, *eventbox;
    gchar *title;

    if( GTK_IS_WIDGET( contact->detached_window ) ) return;

    window = gtk_window_new( GTK_WINDOW_DIALOG );
    gtk_window_set_wmclass( GTK_WINDOW( window ),
                            "Contact_Shortcut", "GnomeICU" );
    title = g_strdup_printf( _("%s status"), contact->nick );
    gtk_window_set_title( GTK_WINDOW( window ), title );
    g_free( title );
    contact->detached_window = window;

    eventbox = gtk_event_box_new();

    gtk_signal_connect( GTK_OBJECT( window ), "delete-event",
                        GTK_SIGNAL_FUNC( detach_window_delete ), NULL );
    gtk_signal_connect( GTK_OBJECT( eventbox ), "button-press-event",
                        GTK_SIGNAL_FUNC( detach_window_click ), NULL );
    gtk_container_add( GTK_CONTAINER( window ), eventbox );
    init_contact_list_drag_drop( eventbox );

    hbox = gtk_hbox_new( FALSE, 0 );
    gtk_pixmap = gtk_pixmap_new( icon_blank_pixmap, icon_blank_bitmap );
    gtk_box_pack_start( GTK_BOX( hbox ), gtk_pixmap, FALSE, FALSE, 0 );
    gtk_widget_show( gtk_pixmap );
    label = gtk_label_new( contact->nick );
    gtk_box_pack_end( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );
    gtk_misc_set_padding( GTK_MISC( label ), 3, 0 );
    gtk_container_add( GTK_CONTAINER( eventbox ), hbox );

    gtk_object_set_data( GTK_OBJECT( window ), "pixmap", gtk_pixmap );
    gtk_object_set_data( GTK_OBJECT( window ), "label", label );
    gtk_object_set_data( GTK_OBJECT( window ), "event_box", eventbox );
    gtk_object_set_data( GTK_OBJECT( eventbox ), "contact", contact );

    gtk_widget_show_all( GTK_WIDGET( window ) );

    gnome_win_hints_set_layer( GTK_WIDGET( window ),
                               WIN_LAYER_ABOVE_DOCK );

    state = gnome_win_hints_get_state( GTK_WIDGET( window ) );
    state = state | WIN_STATE_STICKY;
    gnome_win_hints_set_state( GTK_WIDGET( window ), state );

    hints = gnome_win_hints_get_hints( GTK_WIDGET( window ) );
    hints = hints | WIN_HINTS_SKIP_TASKBAR | WIN_HINTS_SKIP_WINLIST;
    gnome_win_hints_set_hints( GTK_WIDGET( window ), hints );

    Shortcut_Update( contact );
}
