/*
 *  Copyright (C) 2000-2001 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __print_h
#define __print_h

#ifdef __cplusplus
extern "C"
{
#endif

#include "galeon.h"
#include <glib.h>

typedef struct
{
	gboolean print_to_file;
	gchar *printer;
	gchar *file;
	gint paper;
	gdouble top_margin;
	gdouble bottom_margin;
	gdouble left_margin;
	gdouble right_margin;
	gint pages;
	gint from_page;
	gint to_page;
	gint frame_type;
	gint orientation;
	gboolean reversed;
	gboolean print_color;

	 /* 
	 * &T - title
	 * &U - Document URL
	 * &D - Date/Time
	 * &P - Page Number
	 * &PT - Page Number with total Number of Pages (example: 1 of 34)
	 *
	 * So, if headerLeftStr = "&T" the title and the document URL
	 * will be printed out on the top left-hand side of each page.
	 */
	gchar *header_left_string;
	gchar *header_center_string;
	gchar *header_right_string;
	gchar *footer_left_string;
	gchar *footer_center_string;
	gchar *footer_right_string;
}
PrintInfo;

void print_show_dialog (GaleonEmbed *embed);
void print_show_preview_controls (GaleonEmbed *embed);

#ifdef __cplusplus
}
#endif 

#endif /* __print_h */
