/*
	xcdroast.h
*/

#define XCDROAST_VERSION "0.98alpha10"
#define MAXLINE 1024
#define CDDAFRAME 2352
#define DATASECTORSIZE 2048
#define SUNDATASECTORSIZE 512
#define XCDRLOGO "icons/xcdrlogo.gif"
#define CDDBLOGO "icons/cddblogo.gif"
#define BURNPROOFLOGO "icons/burnproof.gif"
#define IMG_EXTENSIONS { ".iso", ".raw", ".img", ".wav", ".toc", NULL }
#define CDR_TYPES_MIN {20,21,34,63,74,-80,89,99,0} /* negative value is default */
#define DVD_TYPES_MB { 2600, 3950, 4700, 5200, 9400, 0 }

#define TMP_XCDR_DIR "/tmp"
#define XCDROAST_INFO_EXT ".xinf"
#define CDDA2WAV_INFO_EXT ".inf"

/* texts to write/blank modes */
#define WRITE_MODES { 178, 179, 276, 521, 522, 523, 0 }
#define HELP_WRITE_MODES { 68, 69, 70, 194, 195, 196, 0 }
#define BLANK_MODES { 511, 512, 513, 514, 515, 516, 517, 0 }

/* icons for dialogs (borrowed from gnome) */
#define ICO_ERROR "icons/dialog_error.png"
#define ICO_INFO "icons/dialog_information.png"
#define ICO_WARN "icons/dialog_warning.png"
#define ICO_QUEST "icons/dialog_question.png"
#define ICO_DEF "icons/dialog_default.png"

/* external called programms */
#ifndef hpux
# define DF "/bin/df -k" 
# define DF2 "/usr/bin/df -k" 
#else
# define DF "/bin/df -b" 
# define DF2 "/usr/bin/df -b" 
#endif
#define UNAME "/bin/uname -a"
#define UNAME2 "/usr/bin/uname -a"
#define CHOWN "/bin/chown"
#define CHOWN2 "/usr/bin/chown"
#define CHGRP "/bin/chgrp"
#define CHGRP2 "/usr/bin/chgrp"
#define CHMOD "/bin/chmod"
#define CHMOD2 "/usr/bin/chmod"
#define GROUPADD "/usr/sbin/groupadd"

#define WAVPLAY "bin/wavplay"
#define RMTOOL "bin/rmtool"
#define VRFYTOOL "bin/vrfytool"
#define CDDBTOOL "bin/cddbtool"
#define WRAPPER "bin/xcdrwrap"

/* this paths can be specified relative to lib-dir or absolute */
/* xcdroast will look for these first in $LIBDIR/ and if not found
   then in $PREFIX (e.g. /usr/bin/cdrecord instead of 
   /usr/local/lib/xcdroast-0.98/bin/cdrecord) */

#define CDRECORD "bin/cdrecord" 
#define CDDA2WAV "bin/cdda2wav"
#define READCD "bin/readcd"
#define MKISOFS "bin/mkisofs"

/* MINIMUM required versions. Greater versions are now silently
   accepted. 
   Distribution-Vendors: DO NOT TOUCH THESE!
   IT WONT WORK WITH LOWER VERSIONS, EVEN WHEN YOU THINK IT DOES! */
 
#define CDRECORD_VERSION "1.11a19"
#define MKISOFS_VERSION "1.15a17"
#define CDDA2WAV_VERSION "1.11a19"
#define READCD_VERSION "1.11a19"

/* group to use for non-root-mode */
#define NONROOTMODEGROUP "xcdwrite"

/* demo sound */
#define DSPTESTSOUND "sound/test.wav"

/* max scanned scsi devices */
#define MAXDEVICES 128

/* max support for cdrecord-drivers (as in cdrecord driver=help) */ 
#define MAXDRIVERS 64 

/* max support for blank-modes (as in cdrecord blank=help) */
#define MAXBLANKMODES 16

/* max support for joliet charsets */
#define MAXCHARSETS 64

/* max tracks a CD can have */
#define MAXTRACKS 100

/* max CDDB matches */
#define MAXCDDB 100

/* max args for pipes */
#define MAXPIPEARGS 1024 

/* timeout in seconds for CDDB queries over network */
#define NETIOTIMEOUT 10;

/* default image-file-prefix */
#define IMGFILEPREFIX "track"

/* default filenames for process-output-savefiles */
#define SAVEOUTCDRECORD "cdrecord.out"
#define SAVEREADTRACKS "readtracks.out"
#define SAVEVERIFYTRACKS "verifytracks.out"
#define SAVEMASTERTRACK "mkisofs.out"

#define SAVEMASTERLIST "xcdrmaster.lst"

/* default paths/configfile */
#define PREFIX "/usr/local"
#define LIBDIR "lib/xcdroast-0.98"
#define CONFIGDIR "~/.xcdroast"
#define CONFFILE "xcdr098.cfg"
#define LOGFILE "xcdr098.log"
#define ISOOPTFILE "isoopt.cfg"
#define ISOHEADERFILE "isoheader.cfg"
#define ROOTCONFIG "/etc/xcdroast.conf"
#define NONROOTBAK "nonrootflags.cfg"

/* language stuff*/
#define MAXENTRIES 640 
#define MAXLANG 40 

/* font definitions */
/* - old definitions, not working with fontsets 
#define NORMFONT "-*-helvetica-medium-r-normal-*-*-120-*-*-p-*-*"
#define BOLDFONT "-*-helvetica-bold-r-normal-*-*-120-*-*-p-*-*"
#define BIGFONT "-*-helvetica-bold-r-normal-*-*-240-*-*-p-*-*"
#define SLANTFONT "-*-helvetica-medium-o-normal-*-*-100-*-*-*-*-*-*"
*/ 

#define NORMFONT "-*-helvetica-medium-r-normal-*-*-120-*-*-p-*-*,-default-*-medium-r-*--14-*-*-*-*-*-*-*,*-medium-r-*,*"
#define BOLDFONT "-*-helvetica-bold-r-normal-*-*-120-*-*-p-*-*,-default-*-bold-r-*--16-*-*-*-*-*-*-*,*-bold-r-*,*"
#define BIGFONT "-*-helvetica-bold-r-normal-*-*-240-*-*-p-*-*,-default-*-bold-r-*--24-*-*-*-*-*-*-*,*-bold-r-*,*"
#define SLANTFONT "-*-helvetica-medium-o-normal-*-*-100-*-*-*-*-*-*,-default-*-medium-i-*--12-*-*-*-*-*-*-*,*-medium-i-*,*"

/* default window sizes - usage autodetected */
/* 75dpi fonts */
#define XCDR_TOPLEVEL_X0 790
#define XCDR_TOPLEVEL_Y0 540
/* 100dpi fonts */
#define XCDR_TOPLEVEL_X1 980
#define XCDR_TOPLEVEL_Y1 670

/* color definitions
   - may not be used at all because they interfere with themes */
#define TOOLTIPCOL "light yellow"
#define GTKLISTCOL "gray95"
#define SELECTEDCLISTCOL "gray70"
#define DISABLEDCOLOR "gray40"

/* text shortcuts */
#define T_YES text(8)
#define T_NO text(9)
#define T_CANCEL text(10)
#define T_OK text(11)
#define T_CLOSE text(195)
#define T_ANYWAY text(199)

/* predefined master iso-opitions */
/* there must be the same number of TYPES as TEXTS (minus the 0 element) */
#define MASTER_TEXTS { 384, 385, 386, 0 }
#define MASTER_TYPES { 	{ 1,1,0,0,1,0,1,1,0,0,0,0,0,0,0,0 }, \
			{ 1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0 }, \
			{ 0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0 } }

#define DEF_BOOT_CATALOG "boot.catalog"

