#!/bin/sh
#
# language extractor v0.2
# 21.01.00 tn
# 07.03.00 enhanced by Chih-Wei Huang
#

if [ "$1" = "" ]; then 
	echo "Usage: lang_extract.sh language-id"
	exit;
fi

# check if the backup files already exist..if not create them
if [ ! -f language.def.org -o ! -f langhelp.def.org ]; then
	echo "Creating backup files (.org)"
	cp language.def language.def.org 
	cp langhelp.def langhelp.def.org 
fi

# args: $1 language id
# this adds empty strings for non existing translations.

function extract_lang()
{
    cat - | awk -v i="$1" ' {
        if (match($1,/^[[:digit:]]*_0/)) {
            s=1
            split($1,a,"_")
        } else {
            if (s == 1) {
                if (!match($1,/^[[:digit:]]*_/))
                    print a[1]"_"i": \"\""
                s=0
            }
        }
        print
    } '
}

# extract lines with language 0 and given id to new language file
# including empty lines and comments
echo
echo "Creating new languages files for id $1..."
egrep "_0:|_$1:|^#|^\$" language.def.org | extract_lang $1 >language.def
egrep "_0:|_$1:|^#|^\$" langhelp.def.org | extract_lang $1 >langhelp.def

echo 
echo "----------"
echo " Please read TRANSLATION.HOWTO for further translation instructions"
echo "----------"


