/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.net.ssl.X509KeyManager;
import sun.security.x509.X500Name;

final class X509KeyManagerImpl
implements X509KeyManager {
    private HashMap a = new HashMap();
    private HashMap b = new HashMap();
    private static final Debug c = Debug.getInstance("ssl");
    private HashMap d = new HashMap();

    X509KeyManagerImpl(KeyStore keyStore, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (keyStore == null) {
            return;
        }
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Object object;
            Certificate[] certificateArray;
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string) || (certificateArray = keyStore.getCertificateChain(string)) == null || certificateArray.length <= 0 || !(certificateArray[0] instanceof X509Certificate)) continue;
            if (!(certificateArray instanceof X509Certificate[])) {
                object = new X509Certificate[certificateArray.length];
                System.arraycopy(certificateArray, 0, object, 0, certificateArray.length);
                certificateArray = object;
            }
            object = keyStore.getKey(string, cArray);
            this.b.put(string, certificateArray);
            this.a.put(string, object);
            if (c == null || !Debug.isOn("keymanager")) continue;
            System.out.println("***");
            System.out.println("found key for : " + string);
            int n = 0;
            while (n < certificateArray.length) {
                System.out.println("chain [" + n + "] = " + certificateArray[n]);
                ++n;
            }
            System.out.println("***");
        }
    }

    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        if (stringArray == null) {
            return null;
        }
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray2 = this.getClientAliases(stringArray[n], principalArray);
            if (stringArray2 != null && stringArray2.length > 0) {
                return stringArray2[0];
            }
            ++n;
        }
        return null;
    }

    public String[] getClientAliases(String string, Principal[] principalArray) {
        String[] stringArray;
        if (string == null) {
            return null;
        }
        Iterator iterator = this.b.keySet().iterator();
        HashMap<String[], String[]> hashMap = new HashMap<String[], String[]>();
        int n = principalArray != null ? principalArray.length : 0;
        X500Name[] x500NameArray = new X500Name[n];
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            X509Certificate[] x509CertificateArray = (X509Certificate[])this.b.get(stringArray);
            if (!string.equals(x509CertificateArray[0].getPublicKey().getAlgorithm())) continue;
            int n2 = 0;
            while (n2 < n) {
                int n3 = 0;
                while (n3 < x509CertificateArray.length) {
                    block9: {
                        Principal principal = x509CertificateArray[n3].getIssuerDN();
                        if (principal.equals(principalArray[n2])) {
                            hashMap.put(stringArray, stringArray);
                            if (c == null || !Debug.isOn("keymanager")) break;
                            System.out.println("matched client alias : " + (String)stringArray);
                            break;
                        }
                        X500Name x500Name = null;
                        X500Name x500Name2 = null;
                        try {
                            x500Name = new X500Name(principal.getName());
                            if (x500NameArray[n2] == null) {
                                x500NameArray[n2] = new X500Name(principalArray[n2].getName());
                            }
                            x500Name2 = x500NameArray[n2];
                        }
                        catch (IOException iOException) {
                            if (c == null || !Debug.isOn("keymanager")) break block9;
                            System.out.println("X500Name threw: " + iOException);
                            break block9;
                        }
                        if (x500Name.equals(x500Name2)) {
                            hashMap.put(stringArray, stringArray);
                            if (c == null || !Debug.isOn("keymanager")) break;
                            System.out.println("matching client alias : " + (String)stringArray);
                            break;
                        }
                    }
                    ++n3;
                }
                ++n2;
            }
            if (n != 0) continue;
            hashMap.put(stringArray, stringArray);
            if (c == null || !Debug.isOn("keymanager")) continue;
            System.out.println("matching client alias : " + (String)stringArray);
        }
        stringArray = hashMap.values().toArray(new String[hashMap.size()]);
        return stringArray.length == 0 ? null : stringArray;
    }

    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        String[] stringArray;
        if (string == null) {
            return null;
        }
        if (principalArray == null || principalArray.length == 0) {
            stringArray = (String[])this.d.get(string);
            if (stringArray == null && (stringArray = this.getServerAliases(string, principalArray)) != null && stringArray.length > 0) {
                this.d.put(string, stringArray);
            }
        } else {
            stringArray = this.getServerAliases(string, principalArray);
        }
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public String[] getServerAliases(String string, Principal[] principalArray) {
        String[] stringArray;
        if (string == null) {
            return null;
        }
        Iterator iterator = this.b.keySet().iterator();
        HashMap<String[], String[]> hashMap = new HashMap<String[], String[]>();
        int n = principalArray != null ? principalArray.length : 0;
        X500Name[] x500NameArray = new X500Name[n];
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            X509Certificate[] x509CertificateArray = (X509Certificate[])this.b.get(stringArray);
            if (!string.equals(x509CertificateArray[0].getPublicKey().getAlgorithm())) continue;
            int n2 = 0;
            while (n2 < n) {
                int n3 = 0;
                while (n3 < x509CertificateArray.length) {
                    block9: {
                        Principal principal = x509CertificateArray[n3].getIssuerDN();
                        if (principal.equals(principalArray[n2])) {
                            hashMap.put(stringArray, stringArray);
                            if (c == null || !Debug.isOn("keymanager")) break;
                            System.out.println("matched server alias : " + (String)stringArray);
                            break;
                        }
                        X500Name x500Name = null;
                        X500Name x500Name2 = null;
                        try {
                            x500Name = new X500Name(principal.getName());
                            if (x500NameArray[n2] == null) {
                                x500NameArray[n2] = new X500Name(principalArray[n2].getName());
                            }
                            x500Name2 = x500NameArray[n2];
                        }
                        catch (IOException iOException) {
                            if (c == null || !Debug.isOn("keymanager")) break block9;
                            System.out.println("X500Name threw: " + iOException);
                            break block9;
                        }
                        if (x500Name.equals(x500Name2)) {
                            hashMap.put(stringArray, stringArray);
                            if (c == null || !Debug.isOn("keymanager")) break;
                            System.out.println("matching server alias : " + (String)stringArray);
                            break;
                        }
                    }
                    ++n3;
                }
                ++n2;
            }
            if (n != 0) continue;
            hashMap.put(stringArray, stringArray);
            if (c == null || !Debug.isOn("keymanager")) continue;
            System.out.println("matching server alias : " + (String)stringArray);
        }
        stringArray = hashMap.values().toArray(new String[hashMap.size()]);
        return stringArray.length == 0 ? null : stringArray;
    }

    public X509Certificate[] getCertificateChain(String string) {
        if (string == null) {
            return null;
        }
        Object v = this.b.get(string);
        if (!(v instanceof X509Certificate[])) {
            return null;
        }
        return (X509Certificate[])((X509Certificate[])v).clone();
    }

    public PrivateKey getPrivateKey(String string) {
        if (string == null) {
            return null;
        }
        Object v = this.a.get(string);
        if (!(v instanceof PrivateKey)) {
            return null;
        }
        return (PrivateKey)v;
    }
}

