/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.security.action.GetPropertyAction;
import sun.security.krb5.Config;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.bo;
import sun.security.krb5.internal.ccache.ao;

class KinitOptions {
    public boolean validate = false;
    public short forwardable = 0;
    public short proxiable = 0;
    public boolean renew = false;
    public KerberosTime lifetime;
    public KerberosTime renewable_lifetime;
    public String target_service;
    public String keytab_file;
    public String cachename;
    public PrincipalName principal;
    public String realm;
    String a;
    public boolean keytab;
    private boolean b = bo.ea;

    public KinitOptions() throws RuntimeException, RealmException {
        this.cachename = this.b();
        if (this.cachename == null) {
            throw new RuntimeException("default cache name error");
        }
        this.principal = this.a();
    }

    public void setKDCRealm(String string) throws RealmException {
        this.realm = string;
    }

    public String getDefaultRealm() {
        if (this.realm == null && this.principal != null) {
            return this.principal.getRealmString();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public KinitOptions(String[] stringArray) throws KrbException, RuntimeException, IOException {
        String string = null;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equals("-f")) {
                this.forwardable = 1;
            } else if (stringArray[n2].equals("-F")) {
                this.forwardable = (short)-1;
            } else if (stringArray[n2].equals("-p")) {
                this.proxiable = 1;
            } else if (stringArray[n2].equals("-P")) {
                this.proxiable = (short)-1;
            } else if (stringArray[n2].equals("-c")) {
                if (n2 + 1 < stringArray.length && stringArray[n2 + 1].startsWith("-")) {
                    throw new IllegalArgumentException("input format not correct");
                }
                if (n2 == stringArray.length - 1) {
                    throw new IllegalArgumentException("Use format FILE:<cache file name> for -c option.");
                }
                if (!stringArray[n2 + 1].substring(0, 5).equalsIgnoreCase("FILE:")) {
                    throw new IllegalArgumentException("Use format FILE:<cache file name> for -c option.");
                }
                this.cachename = stringArray[n2 + 1].substring(5);
                ++n2;
            } else if (stringArray[n2].equalsIgnoreCase("-help")) {
                this.d();
                System.exit(0);
            } else if (string == null) {
                string = stringArray[n2];
                try {
                    this.principal = new PrincipalName(string);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("invalid Principal name");
                }
                if (this.principal.getRealm() == null) {
                    String string2 = Config.getInstance().getDefault("default_realm", "libdefaults");
                    if (string2 == null) throw new IllegalArgumentException("invalid Realm name");
                    this.principal.setRealm(string2);
                }
            } else {
                if (this.a != null) throw new IllegalArgumentException("too many parameters");
                this.a = stringArray[n2];
            }
            ++n2;
        }
        if (this.principal == null) {
            this.principal = this.a();
        }
        if (this.cachename != null) return;
        this.cachename = this.b();
        if (this.cachename != null) return;
        throw new RuntimeException("default cache name error");
    }

    PrincipalName a() {
        String string = null;
        try {
            string = Config.getInstance().getDefaultRealm();
        }
        catch (KrbException krbException) {
            return null;
        }
        String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("KRB5CCNAME"));
        if (string2 == null) {
            string2 = this.a(this.b("KRB5CCNAME"));
        }
        if (string2 != null) {
            if (string2.length() >= 5 && string2.substring(0, 5).equalsIgnoreCase("FILE:")) {
                string2 = string2.substring(5);
            }
            try {
                PrincipalName principalName;
                String string3;
                ao ao2 = new ao(new FileInputStream(string2));
                int n2 = ao2.h();
                if (n2 == 1284) {
                    ao2.a();
                }
                if ((string3 = (principalName = ao2.a(n2)).getRealmString()) == null) {
                    principalName.setRealm(string);
                } else if (!string3.equals(string)) {
                    try {
                        Config.getInstance().resetDefaultRealm(string3);
                    }
                    catch (KrbException krbException) {
                        // empty catch block
                    }
                }
                return principalName;
            }
            catch (IOException iOException) {
            }
            catch (RealmException realmException) {
                // empty catch block
            }
        }
        String string4 = (String)AccessController.doPrivileged(new GetPropertyAction("user.name"));
        if (this.b) {
            System.out.println(">>>KinitOptions default username is :" + string4);
        }
        if (string != null) {
            try {
                PrincipalName principalName = new PrincipalName(string4);
                if (principalName.getRealm() == null) {
                    principalName.setRealm(string);
                }
                return principalName;
            }
            catch (RealmException realmException) {
                // empty catch block
            }
        }
        return null;
    }

    String b() {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("KRB5CCNAME"));
        if (string == null) {
            string = this.b("KRB5CCNAME");
            if (string != null && (string = this.a(string)) != null) {
                System.setProperty("KRB5CCNAME", string);
            }
        } else if (string.length() >= 5 && string.substring(0, 5).equalsIgnoreCase("FILE:")) {
            string = this.a(string.substring(5));
        }
        if (string == null) {
            string = this.c();
        }
        if (this.b) {
            System.out.println(">>>KinitOptions cache name is " + string);
        }
        return string;
    }

    String a(String string) {
        String string2 = null;
        if (string == null) {
            return null;
        }
        try {
            File file;
            string2 = new File(string).getCanonicalPath();
            if (!new File(string2).exists() && !(file = new File(new File(string2).getParent())).isDirectory()) {
                string2 = null;
            }
        }
        catch (IOException iOException) {
            string2 = null;
        }
        return string2;
    }

    String c() {
        String string = null;
        String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("user.name"));
        try {
            string = string2 != null ? Config.getInstance().USER_HOME + File.separator + "krb5cc_" + string2 : Config.getInstance().USER_HOME + File.separator + "krb5cc";
        }
        catch (KrbException krbException) {
            // empty catch block
        }
        return string;
    }

    String b(String string) {
        String string2 = null;
        String string3 = (String)AccessController.doPrivileged(new GetPropertyAction("os.name"));
        if (string3.equals("Windows NT")) {
            if (this.b) {
                System.out.println(">>> KinitOptions: windows platform.");
            }
            string2 = this.c("cmd /c echo %" + string + "%");
            if (this.b) {
                System.out.println(">>> KinitOptions: name is " + string2);
            }
        } else if (string3.startsWith("Win")) {
            string2 = this.c("command.com /c echo %" + string + "%");
        } else if (string3.startsWith("Linux") || string3.startsWith("AIX") || string3.startsWith("SunOS")) {
            string2 = this.c("/usr/bin/env");
        }
        if (string2 != null && (string2.startsWith("%") || string2.startsWith("$"))) {
            string2 = null;
        }
        if (string2 != null && string2.substring(0, 5).equalsIgnoreCase("FILE:")) {
            string2 = string2.substring(5);
        }
        return string2;
    }

    String c(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Vector vector = new Vector();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        try {
            Process process = Runtime.getRuntime().exec((String[])objectArray);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string2 = null;
            if (objectArray.length == 1 && ((String)objectArray[0]).equals("/usr/bin/env")) {
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.length() < 11 || !string2.substring(0, 11).equalsIgnoreCase("KRB5CCNAME=")) continue;
                    string2 = string2.substring(11);
                    break;
                }
            } else {
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
            return string2;
        }
        catch (Exception exception) {
            if (this.b) {
                exception.printStackTrace();
            }
            return null;
        }
    }

    void d() {
        System.out.println("Usage: java sun.security.krb5.tools.Kinit [-f] [-F] [-p] [-P] [-c cachename] [principal] [password]");
        System.out.println("\tavailable options to Kerberos 5 ticket request:");
        System.out.println("\t    -f   forwardable");
        System.out.println("\t    -F   not forwardable");
        System.out.println("\t    -p   proxiable");
        System.out.println("\t    -P   not proxiable");
        System.out.println("\t    -c   cache name (i.e., FILE:d:\\myProfiles\\mykrb5cache)");
        System.out.println("\t    principal   the principal name (i.e., qweadf@ATHENA.MIT.EDU qweadf)");
        System.out.println("\t    password    the principal's Kerberos password");
    }
}

