/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import javax.print.CancelablePrintJob;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashPrintJobAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintJobAttribute;
import javax.print.attribute.PrintJobAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.TextSyntax;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.DocumentName;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobOriginatingUserName;
import javax.print.attribute.standard.JobSheets;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.event.PrintJobAttributeListener;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;
import sun.print.ImagePrinter;
import sun.print.PSPrinterJob;
import sun.print.PrintJobAttributeException;
import sun.print.PrintJobFlavorException;
import sun.print.UnixPrintService;
import sun.print.UnixPrintServiceLookup;

public class UnixPrintJob
implements CancelablePrintJob {
    private transient Vector jobListeners;
    private transient Vector attrListeners;
    private transient Vector listenedAttributeSets;
    private UnixPrintService service;
    private boolean fidelity;
    private boolean printing = false;
    private boolean printReturned = false;
    private PrintRequestAttributeSet reqAttrSet = null;
    private PrintJobAttributeSet jobAttrSet = null;
    private PrinterJob job;
    private Doc doc;
    private InputStream instream = null;
    private Reader reader = null;
    private String jobName = "Java Printing";
    private int copies = 1;
    private MediaSizeName mediaName = MediaSizeName.NA_LETTER;
    private MediaSize mediaSize = MediaSize.NA.LETTER;
    private OrientationRequested orient = OrientationRequested.PORTRAIT;
    private static int DESTPRINTER = 1;
    private static int DESTFILE = 2;
    private int mDestType = DESTPRINTER;
    private File spoolFile;
    private String mDestination;
    private String mOptions;
    private boolean mNoJobSheet = false;
    static /* synthetic */ Class class$javax$print$attribute$standard$RequestingUserName;
    static /* synthetic */ Class class$javax$print$attribute$standard$JobName;
    static /* synthetic */ Class class$javax$print$attribute$standard$DocumentName;
    static /* synthetic */ Class class$javax$print$attribute$standard$Fidelity;
    static /* synthetic */ Class class$javax$print$attribute$standard$Destination;
    static /* synthetic */ Class class$javax$print$attribute$standard$JobSheets;
    static /* synthetic */ Class class$javax$print$attribute$standard$Copies;
    static /* synthetic */ Class class$javax$print$attribute$standard$Media;
    static /* synthetic */ Class class$javax$print$attribute$standard$OrientationRequested;

    UnixPrintJob(UnixPrintService unixPrintService) {
        this.service = unixPrintService;
    }

    public PrintService getPrintService() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintJobAttributeSet getAttributes() {
        UnixPrintJob unixPrintJob = this;
        synchronized (unixPrintJob) {
            block4: {
                if (this.jobAttrSet != null) break block4;
                HashPrintJobAttributeSet hashPrintJobAttributeSet = new HashPrintJobAttributeSet();
                PrintJobAttributeSet printJobAttributeSet = AttributeSetUtilities.unmodifiableView(hashPrintJobAttributeSet);
                return printJobAttributeSet;
            }
            PrintJobAttributeSet printJobAttributeSet = this.jobAttrSet;
            return printJobAttributeSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrintJobListener(PrintJobListener printJobListener) {
        UnixPrintJob unixPrintJob = this;
        synchronized (unixPrintJob) {
            if (printJobListener == null) {
                return;
            }
            if (this.jobListeners == null) {
                this.jobListeners = new Vector();
            }
            this.jobListeners.add(printJobListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrintJobListener(PrintJobListener printJobListener) {
        UnixPrintJob unixPrintJob = this;
        synchronized (unixPrintJob) {
            if (printJobListener == null || this.jobListeners == null) {
                return;
            }
            this.jobListeners.remove(printJobListener);
            if (this.jobListeners.isEmpty()) {
                this.jobListeners = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDataStreams() {
        if (this.doc == null) {
            return;
        }
        Object object = null;
        try {
            object = this.doc.getPrintData();
        }
        catch (IOException iOException) {
            return;
        }
        if (this.instream != null) {
            try {
                try {
                    this.instream.close();
                }
                catch (IOException iOException) {
                    Object var4_8 = null;
                    this.instream = null;
                }
                Object var4_7 = null;
                this.instream = null;
            }
            catch (Throwable throwable) {
                Object var4_9 = null;
                this.instream = null;
                throw throwable;
            }
        } else if (this.reader != null) {
            try {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {
                    Object var6_12 = null;
                    this.reader = null;
                }
                Object var6_11 = null;
                this.reader = null;
            }
            catch (Throwable throwable) {
                Object var6_13 = null;
                this.reader = null;
                throw throwable;
            }
        } else if (object instanceof InputStream) {
            try {
                ((InputStream)object).close();
            }
            catch (IOException iOException) {}
        } else if (object instanceof Reader) {
            try {
                ((Reader)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEvent(int n2) {
        switch (n2) {
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: {
                this.closeDataStreams();
            }
        }
        UnixPrintJob unixPrintJob = this;
        synchronized (unixPrintJob) {
            if (this.jobListeners != null) {
                PrintJobEvent printJobEvent = new PrintJobEvent(this, n2);
                int n3 = 0;
                while (n3 < this.jobListeners.size()) {
                    PrintJobListener printJobListener = (PrintJobListener)this.jobListeners.elementAt(n3);
                    switch (n2) {
                        case 101: {
                            printJobListener.printJobCanceled(printJobEvent);
                            break;
                        }
                        case 103: {
                            printJobListener.printJobFailed(printJobEvent);
                            break;
                        }
                        case 106: {
                            printJobListener.printDataTransferCompleted(printJobEvent);
                            break;
                        }
                        case 105: {
                            printJobListener.printJobNoMoreEvents(printJobEvent);
                            break;
                        }
                    }
                    ++n3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrintJobAttributeListener(PrintJobAttributeListener printJobAttributeListener, PrintJobAttributeSet printJobAttributeSet) {
        UnixPrintJob unixPrintJob = this;
        synchronized (unixPrintJob) {
            if (printJobAttributeListener == null) {
                return;
            }
            if (this.attrListeners == null) {
                this.attrListeners = new Vector();
                this.listenedAttributeSets = new Vector();
            }
            this.attrListeners.add(printJobAttributeListener);
            if (printJobAttributeSet == null) {
                printJobAttributeSet = new HashPrintJobAttributeSet();
            }
            this.listenedAttributeSets.add(printJobAttributeSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrintJobAttributeListener(PrintJobAttributeListener printJobAttributeListener) {
        UnixPrintJob unixPrintJob = this;
        synchronized (unixPrintJob) {
            if (printJobAttributeListener == null || this.attrListeners == null) {
                return;
            }
            int n2 = this.attrListeners.indexOf(printJobAttributeListener);
            if (n2 == -1) {
                return;
            }
            this.attrListeners.remove(n2);
            this.listenedAttributeSets.remove(n2);
            if (this.attrListeners.isEmpty()) {
                this.attrListeners = null;
                this.listenedAttributeSets = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void print(Doc doc, PrintRequestAttributeSet printRequestAttributeSet) throws PrintException {
        Object object;
        block58: {
            OutputStream iOException4;
            block60: {
                Object iOException;
                String string;
                DocFlavor docFlavor;
                block57: {
                    Object object2;
                    UnixPrintJob unixPrintJob = this;
                    synchronized (unixPrintJob) {
                        if (this.printing) {
                            throw new PrintException("already printing");
                        }
                        this.printing = true;
                    }
                    this.doc = doc;
                    docFlavor = doc.getDocFlavor();
                    try {
                        object2 = doc.getPrintData();
                    }
                    catch (IOException iOException2) {
                        this.notifyEvent(103);
                        throw new PrintException("can't get print data: " + iOException2.toString());
                    }
                    if (docFlavor == null || !this.service.isDocFlavorSupported(docFlavor)) {
                        this.notifyEvent(103);
                        throw new PrintJobFlavorException("invalid flavor", docFlavor);
                    }
                    this.initializeAttributeSets(doc, printRequestAttributeSet);
                    this.getAttributeValues(docFlavor);
                    String iOException3 = docFlavor.getRepresentationClassName();
                    String string2 = docFlavor.getParameter("charset");
                    string = "us-ascii";
                    if (string2 != null && !string2.equals("")) {
                        string = string2;
                    }
                    if (docFlavor.equals(DocFlavor.INPUT_STREAM.GIF) || docFlavor.equals(DocFlavor.INPUT_STREAM.JPEG) || docFlavor.equals(DocFlavor.INPUT_STREAM.PNG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.GIF) || docFlavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.PNG)) {
                        try {
                            this.instream = doc.getStreamForBytes();
                            this.printableJob(new ImagePrinter(this.instream));
                            this.service.wakeNotifier();
                            return;
                        }
                        catch (ClassCastException classCastException) {
                            this.notifyEvent(103);
                            throw new PrintException(classCastException);
                        }
                        catch (IOException iOException5) {
                            this.notifyEvent(103);
                            throw new PrintException(iOException5);
                        }
                    }
                    if (docFlavor.equals(DocFlavor.URL.GIF) || docFlavor.equals(DocFlavor.URL.JPEG) || docFlavor.equals(DocFlavor.URL.PNG)) {
                        try {
                            this.printableJob(new ImagePrinter((URL)object2));
                            this.service.wakeNotifier();
                            return;
                        }
                        catch (ClassCastException classCastException) {
                            this.notifyEvent(103);
                            throw new PrintException(classCastException);
                        }
                    }
                    if (docFlavor.equals(DocFlavor.CHAR_ARRAY.TEXT_PLAIN) || docFlavor.equals(DocFlavor.READER.TEXT_PLAIN) || docFlavor.equals(DocFlavor.STRING.TEXT_PLAIN)) {
                        try {
                            this.reader = doc.getReaderForText();
                            if (this.reader == null) {
                                this.notifyEvent(103);
                                throw new PrintException("No reader for data");
                            }
                            break block57;
                        }
                        catch (IOException classCastException) {
                            this.notifyEvent(103);
                            throw new PrintException(classCastException.toString());
                        }
                    }
                    if (iOException3.equals("[B") || iOException3.equals("java.io.InputStream")) {
                        try {
                            this.instream = doc.getStreamForBytes();
                            if (this.instream == null) {
                                this.notifyEvent(103);
                                throw new PrintException("No stream for data");
                            }
                            break block57;
                        }
                        catch (IOException iOException6) {
                            this.notifyEvent(103);
                            throw new PrintException(iOException6.toString());
                        }
                    }
                    if (docFlavor.equals(DocFlavor.URL.AUTOSENSE) || docFlavor.equals(DocFlavor.URL.POSTSCRIPT) || docFlavor.equals(DocFlavor.URL.TEXT_PLAIN_HOST) || docFlavor.equals(DocFlavor.URL.TEXT_PLAIN_UTF_8) || docFlavor.equals(DocFlavor.URL.TEXT_PLAIN_UTF_16) || docFlavor.equals(DocFlavor.URL.TEXT_PLAIN_UTF_16BE) || docFlavor.equals(DocFlavor.URL.TEXT_PLAIN_UTF_16LE) || docFlavor.equals(DocFlavor.URL.TEXT_PLAIN_US_ASCII)) {
                        iOException = (URL)object2;
                        try {
                            this.instream = ((URL)iOException).openStream();
                        }
                        catch (IOException iOException2) {
                            this.notifyEvent(103);
                            throw new PrintException(iOException2.toString());
                        }
                    } else {
                        if (iOException3.equals("java.awt.print.Pageable")) {
                            try {
                                this.pageableJob((Pageable)doc.getPrintData());
                                this.service.wakeNotifier();
                                return;
                            }
                            catch (ClassCastException object22) {
                                this.notifyEvent(103);
                                throw new PrintException(object22);
                            }
                            catch (IOException iOException7) {
                                this.notifyEvent(103);
                                throw new PrintException(iOException7);
                            }
                        }
                        if (!iOException3.equals("java.awt.print.Printable")) {
                            this.notifyEvent(103);
                            throw new PrintException("unrecognized class: " + iOException3);
                        }
                        try {
                            this.printableJob((Printable)doc.getPrintData());
                            this.service.wakeNotifier();
                            return;
                        }
                        catch (ClassCastException classCastException) {
                            this.notifyEvent(103);
                            throw new PrintException(classCastException);
                        }
                        catch (IOException iOException32) {
                            this.notifyEvent(103);
                            throw new PrintException(iOException32);
                        }
                    }
                }
                iOException = new PrinterOpener();
                AccessController.doPrivileged((PrivilegedAction)iOException);
                if (((PrinterOpener)iOException).pex != null) {
                    throw ((PrinterOpener)iOException).pex;
                }
                iOException4 = ((PrinterOpener)iOException).result;
                BufferedWriter bufferedWriter = null;
                if (this.instream == null && this.reader != null) {
                    object = new BufferedReader(this.reader);
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(iOException4);
                    bufferedWriter = new BufferedWriter(outputStreamWriter);
                    char[] cArray = new char[1024];
                    try {
                        while (true) {
                            int n2;
                            if ((n2 = ((BufferedReader)object).read(cArray, 0, cArray.length)) < 0) {
                                ((BufferedReader)object).close();
                                bufferedWriter.flush();
                                bufferedWriter.close();
                                break block58;
                            }
                            bufferedWriter.write(cArray, 0, n2);
                        }
                    }
                    catch (IOException iOException8) {
                        this.notifyEvent(103);
                        throw new PrintException(iOException8);
                    }
                }
                if (this.instream == null || !docFlavor.getMediaType().equalsIgnoreCase("text")) break block60;
                try {
                    try {
                        object = new InputStreamReader(this.instream, string);
                        BufferedReader outputStreamWriter = new BufferedReader((Reader)object);
                        OutputStreamWriter cArray = new OutputStreamWriter(iOException4);
                        bufferedWriter = new BufferedWriter(cArray);
                        char[] n3 = new char[1024];
                        while (true) {
                            if ((iOException = outputStreamWriter.read(n3, 0, n3.length)) < 0) {
                                bufferedWriter.flush();
                                break;
                            }
                            bufferedWriter.write(n3, 0, iOException);
                        }
                    }
                    catch (IOException object3) {
                        this.notifyEvent(103);
                        throw new PrintException(object3);
                    }
                    Object var18_37 = null;
                    {
                    }
                }
                catch (Throwable throwable) {
                    Object var18_38 = null;
                    try {
                        if (bufferedWriter == null) throw throwable;
                        bufferedWriter.close();
                        throw throwable;
                    }
                    catch (IOException iOException9) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException iOException10) {}
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                break block58;
            }
            if (this.instream != null) {
                object = new BufferedInputStream(this.instream);
                BufferedOutputStream bufferedReader = new BufferedOutputStream(iOException4);
                byte[] outputStreamWriter = new byte[1024];
                int cArray = 0;
                try {
                    while (true) {
                        if ((cArray = ((FilterInputStream)object).read(outputStreamWriter)) < 0) {
                            ((BufferedInputStream)object).close();
                            bufferedReader.flush();
                            bufferedReader.close();
                            break;
                        }
                        bufferedReader.write(outputStreamWriter, 0, cArray);
                    }
                }
                catch (IOException n2) {
                    this.notifyEvent(103);
                    throw new PrintException(n2);
                }
            }
        }
        this.notifyEvent(106);
        if (this.mDestType == DESTPRINTER) {
            object = new PrinterSpooler();
            AccessController.doPrivileged((PrivilegedAction)object);
            if (((PrinterSpooler)object).pex != null) {
                throw ((PrinterSpooler)object).pex;
            }
        }
        this.notifyEvent(105);
        this.service.wakeNotifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printableJob(Printable printable) throws PrintException {
        try {
            try {
                UnixPrintJob unixPrintJob = this;
                synchronized (unixPrintJob) {
                    if (this.job != null) {
                        throw new PrintException("already printing");
                    }
                    this.job = new PSPrinterJob();
                }
                this.job.setPrintService(this.getPrintService());
                this.job.setCopies(this.copies);
                this.job.setJobName(this.jobName);
                PageFormat pageFormat = new PageFormat();
                if (this.mediaSize != null) {
                    Paper paper = new Paper();
                    paper.setSize((double)this.mediaSize.getX(25400) * 72.0, (double)this.mediaSize.getY(25400) * 72.0);
                    paper.setImageableArea(72.0, 72.0, paper.getWidth() - 144.0, paper.getHeight() - 144.0);
                    pageFormat.setPaper(paper);
                }
                if (this.orient == OrientationRequested.REVERSE_LANDSCAPE) {
                    pageFormat.setOrientation(2);
                } else if (this.orient == OrientationRequested.LANDSCAPE) {
                    pageFormat.setOrientation(0);
                }
                this.job.setPrintable(printable, pageFormat);
                this.job.print(this.reqAttrSet);
                this.notifyEvent(106);
                Object var6_7 = null;
                this.printReturned = true;
                this.notifyEvent(105);
                return;
            }
            catch (PrinterException printerException) {
                this.notifyEvent(103);
                throw new PrintException(printerException);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.printReturned = true;
            this.notifyEvent(105);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pageableJob(Pageable pageable) throws PrintException {
        try {
            try {
                UnixPrintJob unixPrintJob = this;
                synchronized (unixPrintJob) {
                    if (this.job != null) {
                        throw new PrintException("already printing");
                    }
                    this.job = new PSPrinterJob();
                }
                this.job.setPrintService(this.getPrintService());
                this.job.setCopies(this.copies);
                this.job.setJobName(this.jobName);
                this.job.setPageable(pageable);
                this.job.print(this.reqAttrSet);
                this.notifyEvent(106);
                Object var5_5 = null;
                this.printReturned = true;
                this.notifyEvent(105);
                return;
            }
            catch (PrinterException printerException) {
                this.notifyEvent(103);
                throw new PrintException(printerException);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.printReturned = true;
            this.notifyEvent(105);
            throw throwable;
        }
    }

    private synchronized void initializeAttributeSets(Doc doc, PrintRequestAttributeSet printRequestAttributeSet) {
        TextSyntax textSyntax;
        DocAttributeSet docAttributeSet;
        Attribute[] attributeArray;
        this.reqAttrSet = new HashPrintRequestAttributeSet();
        this.jobAttrSet = new HashPrintJobAttributeSet();
        if (printRequestAttributeSet != null) {
            this.reqAttrSet.addAll(printRequestAttributeSet);
            attributeArray = printRequestAttributeSet.toArray();
            int n2 = 0;
            while (n2 < attributeArray.length) {
                if (attributeArray[n2] instanceof PrintJobAttribute) {
                    this.jobAttrSet.add(attributeArray[n2]);
                }
                ++n2;
            }
        }
        if ((docAttributeSet = doc.getAttributes()) != null) {
            attributeArray = docAttributeSet.toArray();
            int n3 = 0;
            while (n3 < attributeArray.length) {
                if (attributeArray[n3] instanceof PrintRequestAttribute) {
                    this.reqAttrSet.add(attributeArray[n3]);
                }
                if (attributeArray[n3] instanceof PrintJobAttribute) {
                    this.jobAttrSet.add(attributeArray[n3]);
                }
                ++n3;
            }
        }
        String string = "";
        try {
            string = System.getProperty("user.name");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string == null || string.equals("")) {
            textSyntax = (RequestingUserName)printRequestAttributeSet.get(class$javax$print$attribute$standard$RequestingUserName == null ? (class$javax$print$attribute$standard$RequestingUserName = UnixPrintJob.class$("javax.print.attribute.standard.RequestingUserName")) : class$javax$print$attribute$standard$RequestingUserName);
            if (textSyntax != null) {
                this.jobAttrSet.add(new JobOriginatingUserName(textSyntax.getValue(), textSyntax.getLocale()));
            } else {
                this.jobAttrSet.add(new JobOriginatingUserName("", null));
            }
        } else {
            this.jobAttrSet.add(new JobOriginatingUserName(string, null));
        }
        if (this.jobAttrSet.get(class$javax$print$attribute$standard$JobName == null ? (class$javax$print$attribute$standard$JobName = UnixPrintJob.class$("javax.print.attribute.standard.JobName")) : class$javax$print$attribute$standard$JobName) == null) {
            if (docAttributeSet != null && docAttributeSet.get(class$javax$print$attribute$standard$DocumentName == null ? (class$javax$print$attribute$standard$DocumentName = UnixPrintJob.class$("javax.print.attribute.standard.DocumentName")) : class$javax$print$attribute$standard$DocumentName) != null) {
                DocumentName documentName = (DocumentName)docAttributeSet.get(class$javax$print$attribute$standard$DocumentName == null ? (class$javax$print$attribute$standard$DocumentName = UnixPrintJob.class$("javax.print.attribute.standard.DocumentName")) : class$javax$print$attribute$standard$DocumentName);
                textSyntax = new JobName(documentName.getValue(), documentName.getLocale());
                this.jobAttrSet.add((Attribute)((Object)textSyntax));
            } else {
                String string2 = "JPS Job:" + doc;
                try {
                    Object object = doc.getPrintData();
                    if (object instanceof URL) {
                        string2 = ((URL)doc.getPrintData()).toString();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                textSyntax = new JobName(string2, null);
                this.jobAttrSet.add((Attribute)((Object)textSyntax));
            }
        }
        this.jobAttrSet = AttributeSetUtilities.unmodifiableView(this.jobAttrSet);
    }

    private void getAttributeValues(DocFlavor docFlavor) throws PrintException {
        this.fidelity = this.reqAttrSet.get(class$javax$print$attribute$standard$Fidelity == null ? (class$javax$print$attribute$standard$Fidelity = UnixPrintJob.class$("javax.print.attribute.standard.Fidelity")) : class$javax$print$attribute$standard$Fidelity) == Fidelity.FIDELITY_TRUE;
        Attribute[] attributeArray = this.reqAttrSet.toArray();
        int n2 = 0;
        while (n2 < attributeArray.length) {
            Attribute attribute = attributeArray[n2];
            Class clazz = attribute.getCategory();
            if (this.fidelity) {
                if (!this.service.isAttributeCategorySupported(clazz)) {
                    this.notifyEvent(103);
                    throw new PrintJobAttributeException("unsupported category: " + clazz, clazz, null);
                }
                if (!this.service.isAttributeValueSupported(attribute, docFlavor, null)) {
                    this.notifyEvent(103);
                    throw new PrintJobAttributeException("unsupported attribute: " + attribute, null, attribute);
                }
            }
            if (clazz == (class$javax$print$attribute$standard$Destination == null ? UnixPrintJob.class$("javax.print.attribute.standard.Destination") : class$javax$print$attribute$standard$Destination)) {
                URI uRI = ((Destination)attribute).getURI();
                if (!"file".equals(uRI.getScheme())) {
                    this.notifyEvent(103);
                    throw new PrintException("Not a file: URI");
                }
                try {
                    this.mDestType = DESTFILE;
                    this.mDestination = new File(uRI).getPath();
                }
                catch (Exception exception) {
                    throw new PrintException(exception);
                }
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    try {
                        securityManager.checkWrite(this.mDestination);
                    }
                    catch (SecurityException securityException) {
                        this.notifyEvent(103);
                        throw new PrintException(securityException);
                    }
                }
            } else if (clazz == (class$javax$print$attribute$standard$JobSheets == null ? UnixPrintJob.class$("javax.print.attribute.standard.JobSheets") : class$javax$print$attribute$standard$JobSheets)) {
                if ((JobSheets)attribute == JobSheets.NONE) {
                    this.mNoJobSheet = true;
                }
            } else if (clazz == (class$javax$print$attribute$standard$JobName == null ? UnixPrintJob.class$("javax.print.attribute.standard.JobName") : class$javax$print$attribute$standard$JobName)) {
                this.jobName = ((JobName)attribute).getValue();
            } else if (clazz == (class$javax$print$attribute$standard$Copies == null ? UnixPrintJob.class$("javax.print.attribute.standard.Copies") : class$javax$print$attribute$standard$Copies)) {
                this.copies = ((Copies)attribute).getValue();
            } else if (clazz == (class$javax$print$attribute$standard$Media == null ? UnixPrintJob.class$("javax.print.attribute.standard.Media") : class$javax$print$attribute$standard$Media)) {
                if (attribute instanceof MediaSizeName) {
                    this.mediaName = (MediaSizeName)attribute;
                    if (!this.service.isAttributeValueSupported(attribute, null, null)) {
                        this.mediaSize = MediaSize.getMediaSizeForName(this.mediaName);
                    }
                }
            } else if (clazz == (class$javax$print$attribute$standard$OrientationRequested == null ? UnixPrintJob.class$("javax.print.attribute.standard.OrientationRequested") : class$javax$print$attribute$standard$OrientationRequested)) {
                this.orient = (OrientationRequested)attribute;
            }
            ++n2;
        }
    }

    private String[] printExecCmd(String string, String string2, boolean bl2, String string3, int n2, String string4) {
        String[] stringArray;
        int n3 = 1;
        int n4 = 2;
        int n5 = 4;
        int n6 = 8;
        int n7 = 16;
        int n8 = 0;
        int n9 = 2;
        int n10 = 0;
        if (string != null && !string.equals("") && !string.equals("lp")) {
            n8 |= n3;
            ++n9;
        }
        if (string2 != null && !string2.equals("")) {
            n8 |= n4;
            ++n9;
        }
        if (string3 != null && !string3.equals("")) {
            n8 |= n5;
            ++n9;
        }
        if (n2 > 1) {
            n8 |= n6;
            ++n9;
        }
        if (bl2) {
            n8 |= n7;
            ++n9;
        }
        if (UnixPrintServiceLookup.osname.equals("SunOS")) {
            stringArray = new String[++n9];
            stringArray[n10++] = "/usr/bin/lp";
            stringArray[n10++] = "-c";
            if ((n8 & n3) != 0) {
                stringArray[n10++] = new String("-d" + string);
            }
            if ((n8 & n5) != 0) {
                String string5 = "\"";
                stringArray[n10++] = new String("-t" + string5 + string3 + string5);
            }
            if ((n8 & n6) != 0) {
                stringArray[n10++] = new String("-n" + new Integer(n2).toString());
            }
            if ((n8 & n7) != 0) {
                stringArray[n10++] = new String("-o nobanner");
            }
            if ((n8 & n4) != 0) {
                stringArray[n10++] = new String("-o" + string2);
            }
        } else {
            stringArray = new String[n9];
            stringArray[n10++] = "/usr/bin/lpr";
            if ((n8 & n3) != 0) {
                stringArray[n10++] = new String("-P" + string);
            }
            if ((n8 & n5) != 0) {
                stringArray[n10++] = new String("-J" + string3);
            }
            if ((n8 & n6) != 0) {
                stringArray[n10++] = new String("-#" + new Integer(n2).toString());
            }
            if ((n8 & n7) != 0) {
                stringArray[n10++] = new String("-h");
            }
            if ((n8 & n4) != 0) {
                stringArray[n10++] = new String(string2);
            }
        }
        stringArray[n10++] = string4;
        return stringArray;
    }

    public void cancel() throws PrintException {
        UnixPrintJob unixPrintJob = this;
        synchronized (unixPrintJob) {
            if (!this.printing) {
                throw new PrintException("Job is not yet submitted.");
            }
            if (this.job != null && !this.printReturned) {
                this.job.cancel();
                this.notifyEvent(101);
                return;
            }
            throw new PrintException("Job could not be cancelled.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PrinterSpooler
    implements PrivilegedAction {
        PrintException pex;

        private PrinterSpooler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object run() {
            block8: {
                Object var1_1;
                block7: {
                    try {
                        try {
                            if (UnixPrintJob.this.spoolFile == null || !UnixPrintJob.this.spoolFile.exists()) {
                                this.pex = new PrintException("No spool file");
                                UnixPrintJob.this.notifyEvent(103);
                                var1_1 = null;
                                Object var5_4 = null;
                                break block7;
                            }
                            String string = UnixPrintJob.this.spoolFile.getAbsolutePath();
                            String[] stringArray = UnixPrintJob.this.printExecCmd(UnixPrintJob.this.mDestination, UnixPrintJob.this.mOptions, UnixPrintJob.this.mNoJobSheet, UnixPrintJob.this.jobName, UnixPrintJob.this.copies, string);
                            Process process = Runtime.getRuntime().exec(stringArray);
                            process.waitFor();
                            UnixPrintJob.this.spoolFile.delete();
                            UnixPrintJob.this.notifyEvent(106);
                            break block8;
                        }
                        catch (IOException iOException) {
                            UnixPrintJob.this.notifyEvent(103);
                            this.pex = new PrintException(iOException);
                            Object var5_6 = null;
                            UnixPrintJob.this.notifyEvent(105);
                            return null;
                        }
                        catch (InterruptedException interruptedException) {
                            UnixPrintJob.this.notifyEvent(103);
                            this.pex = new PrintException(interruptedException);
                            Object var5_7 = null;
                            UnixPrintJob.this.notifyEvent(105);
                            return null;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        UnixPrintJob.this.notifyEvent(105);
                        throw throwable;
                    }
                }
                UnixPrintJob.this.notifyEvent(105);
                return var1_1;
            }
            Object var5_5 = null;
            UnixPrintJob.this.notifyEvent(105);
            return null;
        }
    }

    private class PrinterOpener
    implements PrivilegedAction {
        PrintException pex;
        OutputStream result;

        private PrinterOpener() {
        }

        public Object run() {
            try {
                if (UnixPrintJob.this.mDestType == DESTFILE) {
                    UnixPrintJob.this.spoolFile = new File(UnixPrintJob.this.mDestination);
                } else {
                    UnixPrintJob.this.spoolFile = File.createTempFile("javaprint", ".ps", null);
                    UnixPrintJob.this.spoolFile.deleteOnExit();
                }
                this.result = new FileOutputStream(UnixPrintJob.this.spoolFile);
                return this.result;
            }
            catch (IOException iOException) {
                UnixPrintJob.this.notifyEvent(103);
                this.pex = new PrintException(iOException);
                return null;
            }
        }
    }
}

