/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOVecWrapper;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.Util;

class IOUtil {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$sun$nio$ch$IOUtil;

    private IOUtil() {
    }

    private static int remaining(ByteBuffer[] byteBufferArray) {
        int n2 = byteBufferArray.length;
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < n2) {
            if (byteBufferArray[n3].hasRemaining()) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private static ByteBuffer[] skipBufs(ByteBuffer[] byteBufferArray, int n2) {
        int n3 = byteBufferArray.length - n2;
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n3];
        int n4 = 0;
        while (n4 < n3) {
            byteBufferArray2[n4] = byteBufferArray[n4 + n2];
            ++n4;
        }
        return byteBufferArray2;
    }

    static int write(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l2, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        if (byteBuffer instanceof DirectBuffer) {
            return IOUtil.writeFromNativeBuffer(fileDescriptor, byteBuffer, l2, nativeDispatcher, object);
        }
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        ByteBuffer byteBuffer2 = Util.getTemporaryDirectBuffer(n4);
        byteBuffer2.put(byteBuffer);
        byteBuffer2.flip();
        byteBuffer.position(n2);
        int n5 = IOUtil.writeFromNativeBuffer(fileDescriptor, byteBuffer2, l2, nativeDispatcher, object);
        if (n5 > 0) {
            byteBuffer.position(n2 + n5);
        }
        return n5;
    }

    private static int writeFromNativeBuffer(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l2, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        int n5 = 0;
        if (n4 == 0) {
            return 0;
        }
        n5 = l2 != -1L ? nativeDispatcher.pwrite(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n2, n4, l2, object) : nativeDispatcher.write(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n2, n4);
        if (n5 > 0) {
            byteBuffer.position(n2 + n5);
        }
        return n5;
    }

    static int write(FileDescriptor fileDescriptor, ByteBuffer[] byteBufferArray, NativeDispatcher nativeDispatcher) throws IOException {
        int n2;
        int n3;
        int n4 = IOUtil.remaining(byteBufferArray);
        if (n4 < 0) {
            return 0;
        }
        if (n4 > 0) {
            byteBufferArray = IOUtil.skipBufs(byteBufferArray, n4);
        }
        int n5 = byteBufferArray.length;
        int n6 = 0;
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n5];
        int n7 = 0;
        while (n7 < n5) {
            if (!(byteBufferArray[n7] instanceof DirectBuffer)) {
                ByteBuffer byteBuffer;
                int n8 = byteBufferArray[n7].position();
                n3 = byteBufferArray[n7].limit();
                if (!$assertionsDisabled && n8 > n3) {
                    throw new AssertionError();
                }
                n2 = n8 <= n3 ? n3 - n8 : 0;
                byteBufferArray2[n7] = byteBuffer = ByteBuffer.allocateDirect(n2);
                byteBuffer.put(byteBufferArray[n7]);
                byteBufferArray[n7].position(n8);
                byteBuffer.flip();
            } else {
                byteBufferArray2[n7] = byteBufferArray[n7];
            }
            ++n7;
        }
        IOVecWrapper iOVecWrapper = new IOVecWrapper(n5);
        n3 = 0;
        while (n3 < n5) {
            ByteBuffer byteBuffer = byteBufferArray2[n3];
            long l2 = byteBuffer.position();
            long l3 = (long)byteBuffer.limit() - l2;
            n6 = (int)((long)n6 + l3);
            iOVecWrapper.putBase(n3, ((DirectBuffer)((Object)byteBuffer)).address() + l2);
            iOVecWrapper.putLen(n3, l3);
            ++n3;
        }
        int n9 = n2 = nativeDispatcher.writev(fileDescriptor, iOVecWrapper.address, n5);
        int n10 = 0;
        while (n10 < n5) {
            int n11;
            int n12;
            ByteBuffer byteBuffer = byteBufferArray[n10];
            int n13 = byteBuffer.position();
            int n14 = byteBuffer.limit();
            if (!$assertionsDisabled && n13 > n14) {
                throw new AssertionError();
            }
            int n15 = n12 = n13 <= n14 ? n14 - n13 : n14;
            if (n2 >= n12) {
                n2 -= n12;
            } else {
                if (n2 <= 0) break;
                n11 = n13 + n2;
                byteBuffer.position(n11);
                break;
            }
            n11 = n13 + n12;
            byteBuffer.position(n11);
            ++n10;
        }
        return n9;
    }

    static int read(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l2, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        if (byteBuffer instanceof DirectBuffer) {
            return IOUtil.readIntoNativeBuffer(fileDescriptor, byteBuffer, l2, nativeDispatcher, object);
        }
        ByteBuffer byteBuffer2 = Util.getTemporaryDirectBuffer(byteBuffer.remaining());
        int n2 = IOUtil.readIntoNativeBuffer(fileDescriptor, byteBuffer2, l2, nativeDispatcher, object);
        byteBuffer2.flip();
        if (n2 > 0) {
            byteBuffer.put(byteBuffer2);
        }
        return n2;
    }

    private static int readIntoNativeBuffer(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l2, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        int n2;
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        if (!$assertionsDisabled && n3 > n4) {
            throw new AssertionError();
        }
        int n5 = n2 = n3 <= n4 ? n4 - n3 : 0;
        if (n2 == 0) {
            return 0;
        }
        int n6 = 0;
        n6 = l2 != -1L ? nativeDispatcher.pread(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n3, n2, l2, object) : nativeDispatcher.read(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n3, n2);
        if (n6 > 0) {
            byteBuffer.position(n3 + n6);
        }
        return n6;
    }

    static int read(FileDescriptor fileDescriptor, ByteBuffer[] byteBufferArray, NativeDispatcher nativeDispatcher) throws IOException {
        int n2;
        int n3 = IOUtil.remaining(byteBufferArray);
        if (n3 < 0) {
            return 0;
        }
        if (n3 > 0) {
            byteBufferArray = IOUtil.skipBufs(byteBufferArray, n3);
        }
        int n4 = byteBufferArray.length;
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n4];
        int n5 = 0;
        while (n5 < n4) {
            byteBufferArray2[n5] = !(byteBufferArray[n5] instanceof DirectBuffer) ? ByteBuffer.allocateDirect(byteBufferArray[n5].remaining()) : byteBufferArray[n5];
            ++n5;
        }
        IOVecWrapper iOVecWrapper = new IOVecWrapper(n4);
        int n6 = 0;
        while (n6 < n4) {
            ByteBuffer byteBuffer = byteBufferArray2[n6];
            long l2 = byteBuffer.position();
            long l3 = byteBuffer.remaining();
            iOVecWrapper.putBase(n6, ((DirectBuffer)((Object)byteBuffer)).address() + l2);
            iOVecWrapper.putLen(n6, l3);
            ++n6;
        }
        int n7 = n2 = nativeDispatcher.readv(fileDescriptor, iOVecWrapper.address, n4);
        int n8 = 0;
        while (n8 < n4) {
            int n9;
            ByteBuffer byteBuffer = byteBufferArray2[n8];
            int n10 = byteBuffer.position();
            int n11 = byteBuffer.remaining();
            if (n2 >= n11) {
                n2 -= n11;
            } else {
                if (n2 <= 0) break;
                n9 = n10 + n2;
                byteBuffer.limit(n9);
                byteBuffer.position(n9);
                break;
            }
            n9 = n10 + n11;
            byteBuffer.limit(n9);
            byteBuffer.position(n9);
            ++n8;
        }
        int n12 = 0;
        while (n12 < n4) {
            if (!(byteBufferArray[n12] instanceof DirectBuffer)) {
                byteBufferArray2[n12].flip();
                byteBufferArray[n12].put(byteBufferArray2[n12]);
            }
            ++n12;
        }
        return n7;
    }

    static FileDescriptor newFD(int n2) {
        FileDescriptor fileDescriptor = new FileDescriptor();
        IOUtil.setfdVal(fileDescriptor, n2);
        return fileDescriptor;
    }

    static native void initPipe(int[] var0, boolean var1);

    static native boolean drain(int var0) throws IOException;

    static native void configureBlocking(FileDescriptor var0, boolean var1) throws IOException;

    static native int fdVal(FileDescriptor var0);

    static native void setfdVal(FileDescriptor var0, int var1);

    private static native void initIDs();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$sun$nio$ch$IOUtil == null ? (class$sun$nio$ch$IOUtil = IOUtil.class$("sun.nio.ch.IOUtil")) : class$sun$nio$ch$IOUtil).desiredAssertionStatus();
        Util.load();
        IOUtil.initIDs();
    }
}

