/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import sun.net.www.http.ClientVector;
import sun.net.www.http.HttpClient;
import sun.net.www.http.KeepAliveEntry;
import sun.net.www.http.KeepAliveKey;
import sun.security.action.GetIntegerAction;

public class KeepAliveCache
extends Hashtable
implements Runnable {
    static int result = -1;
    static final int LIFETIME = 5000;

    static int getMaxConnections() {
        if (result == -1 && (result = ((Integer)AccessController.doPrivileged(new GetIntegerAction("http.maxConnections", 2))).intValue()) <= 0) {
            result = 2;
        }
        return result;
    }

    public synchronized void put(URL uRL, Object object, HttpClient httpClient) {
        ClientVector clientVector;
        Object object2;
        if (this.size() == 0) {
            object2 = this;
            AccessController.doPrivileged(new PrivilegedAction((KeepAliveCache)object2){
                private final /* synthetic */ KeepAliveCache val$cache;
                {
                    this.val$cache = keepAliveCache2;
                }

                public Object run() {
                    Thread thread = null;
                    thread = new Thread(this.val$cache, "Keep-Alive-Timer");
                    thread.setDaemon(true);
                    thread.setPriority(8);
                    thread.start();
                    return null;
                }
            });
        }
        if ((clientVector = (ClientVector)super.get(object2 = new KeepAliveKey(uRL, object))) == null) {
            clientVector = new ClientVector(5000);
            clientVector.put(httpClient);
            super.put(object2, clientVector);
        } else {
            clientVector.put(httpClient);
        }
    }

    public synchronized void remove(HttpClient httpClient, Object object) {
        KeepAliveKey keepAliveKey = new KeepAliveKey(httpClient.url, object);
        ClientVector clientVector = (ClientVector)super.get(keepAliveKey);
        if (clientVector != null) {
            clientVector.remove(httpClient);
            if (clientVector.empty()) {
                this.removeVector(keepAliveKey);
            }
        }
    }

    synchronized void removeVector(KeepAliveKey keepAliveKey) {
        super.remove(keepAliveKey);
    }

    public Object get(URL uRL, Object object) {
        KeepAliveKey keepAliveKey = new KeepAliveKey(uRL, object);
        ClientVector clientVector = (ClientVector)super.get(keepAliveKey);
        if (clientVector == null) {
            return null;
        }
        return clientVector.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        do {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            KeepAliveCache keepAliveCache = this;
            synchronized (keepAliveCache) {
                Iterator iterator = this.keySet().iterator();
                ArrayList arrayList = new ArrayList();
                while (iterator.hasNext()) {
                    KeepAliveKey keepAliveKey = (KeepAliveKey)iterator.next();
                    ClientVector clientVector = (ClientVector)this.get(keepAliveKey);
                    long l2 = System.currentTimeMillis();
                    int n2 = 0;
                    while (n2 < clientVector.size()) {
                        KeepAliveEntry keepAliveEntry = (KeepAliveEntry)clientVector.elementAt(n2);
                        if (l2 - keepAliveEntry.startTime <= (long)clientVector.nap) break;
                        HttpClient httpClient = keepAliveEntry.hc;
                        httpClient.closeServer();
                        ++n2;
                    }
                    clientVector.subList(0, n2).clear();
                    if (clientVector.size() != 0) continue;
                    arrayList.add(keepAliveKey);
                }
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    this.removeVector((KeepAliveKey)iterator.next());
                }
            }
        } while (this.size() > 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        throw new NotSerializableException();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new NotSerializableException();
    }
}

