/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import sun.misc.CEStreamExhausted;

public abstract class CharacterDecoder {
    protected abstract int bytesPerAtom();

    protected abstract int bytesPerLine();

    protected void decodeBufferPrefix(PushbackInputStream pushbackInputStream, OutputStream outputStream) throws IOException {
    }

    protected void decodeBufferSuffix(PushbackInputStream pushbackInputStream, OutputStream outputStream) throws IOException {
    }

    protected int decodeLinePrefix(PushbackInputStream pushbackInputStream, OutputStream outputStream) throws IOException {
        return this.bytesPerLine();
    }

    protected void decodeLineSuffix(PushbackInputStream pushbackInputStream, OutputStream outputStream) throws IOException {
    }

    protected void decodeAtom(PushbackInputStream pushbackInputStream, OutputStream outputStream, int n2) throws IOException {
        throw new CEStreamExhausted();
    }

    protected int readFully(InputStream inputStream, byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 0;
        while (n4 < n3) {
            int n5 = inputStream.read();
            if (n5 == -1) {
                return n4 == 0 ? -1 : n4;
            }
            byArray[n4 + n2] = (byte)n5;
            ++n4;
        }
        return n3;
    }

    public void decodeBuffer(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2 = 0;
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
        this.decodeBufferPrefix(pushbackInputStream, outputStream);
        try {
            while (true) {
                int n3 = this.decodeLinePrefix(pushbackInputStream, outputStream);
                int n4 = 0;
                while (n4 + this.bytesPerAtom() < n3) {
                    this.decodeAtom(pushbackInputStream, outputStream, this.bytesPerAtom());
                    n2 += this.bytesPerAtom();
                    n4 += this.bytesPerAtom();
                }
                if (n4 + this.bytesPerAtom() == n3) {
                    this.decodeAtom(pushbackInputStream, outputStream, this.bytesPerAtom());
                    n2 += this.bytesPerAtom();
                } else {
                    this.decodeAtom(pushbackInputStream, outputStream, n3 - n4);
                    n2 += n3 - n4;
                }
                this.decodeLineSuffix(pushbackInputStream, outputStream);
            }
        }
        catch (CEStreamExhausted cEStreamExhausted) {
            this.decodeBufferSuffix(pushbackInputStream, outputStream);
            return;
        }
    }

    public byte[] decodeBuffer(String string) throws IOException {
        byte[] byArray = new byte[string.length()];
        string.getBytes(0, string.length(), byArray, 0);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.decodeBuffer(byteArrayInputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] decodeBuffer(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.decodeBuffer(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

