/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11SurfaceData;
import sun.awt.image.SunVolatileImage;
import sun.awt.motif.MComponentPeer;
import sun.java2d.SurfaceData;

public class X11VolatileImage
extends SunVolatileImage {
    private long drawable;

    public X11VolatileImage(Component component, int n2, int n3) {
        super(component, n2, n3);
    }

    public X11VolatileImage(Component component, int n2, int n3, long l2) {
        super(component, n2, n3, new Long(l2));
        if (l2 != 0L && !SunVolatileImage.accelerationEnabled) {
            this.initAcceleratedBackground();
        }
    }

    public X11VolatileImage(GraphicsConfiguration graphicsConfiguration, int n2, int n3) {
        super(graphicsConfiguration, n2, n3);
    }

    public void initAcceleratedBackground() {
        X11GraphicsConfig x11GraphicsConfig = this.comp != null ? X11SurfaceData.getGC((MComponentPeer)this.comp.getPeer()) : (X11GraphicsConfig)this.graphicsConfig;
        try {
            long l2 = 0L;
            if (this.context instanceof Long) {
                l2 = (Long)this.context;
            }
            this.surfaceData = this.surfaceDataHw = X11SurfaceData.X11PixmapSurfaceData.createData(x11GraphicsConfig, this.getWidth(), this.getHeight(), this.getColorModel(), this, l2, 0);
        }
        catch (NullPointerException nullPointerException) {
            this.surfaceDataHw = null;
            this.surfaceData = this.getSurfaceDataSw();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.surfaceDataHw = null;
            this.surfaceData = this.getSurfaceDataSw();
        }
    }

    protected boolean isGCValid(GraphicsConfiguration graphicsConfiguration) {
        return super.isGCValid(graphicsConfiguration) && (graphicsConfiguration == null || graphicsConfiguration == this.graphicsConfig);
    }

    protected boolean destSurfaceAccelerated(SurfaceData surfaceData) {
        return surfaceData instanceof X11SurfaceData;
    }

    static {
        SunVolatileImage.accelerationEnabled = X11SurfaceData.isAccelerationEnabled();
    }
}

