/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.patterns;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.Axis;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.SubContextList;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;

public class StepPattern
extends NodeTest
implements SubContextList {
    protected int m_axis;
    String m_targetString;
    StepPattern m_relativePathPattern;
    Expression[] m_predicates;
    private static final boolean DEBUG_MATCHES = false;

    public StepPattern(int n2, String string, String string2, int n3, int n4) {
        super(n2, string, string2);
        this.m_axis = n3;
    }

    public StepPattern(int n2, int n3, int n4) {
        super(n2);
        this.m_axis = n3;
    }

    public void calcTargetString() {
        int n2 = this.getWhatToShow();
        switch (n2) {
            case 128: {
                this.m_targetString = "#comment";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                this.m_targetString = "#text";
                break;
            }
            case -1: {
                this.m_targetString = "*";
                break;
            }
            case 256: 
            case 1280: {
                this.m_targetString = "/";
                break;
            }
            case 1: {
                if ("*" == this.m_name) {
                    this.m_targetString = "*";
                    break;
                }
                this.m_targetString = this.m_name;
                break;
            }
            default: {
                this.m_targetString = "*";
            }
        }
    }

    public String getTargetString() {
        return this.m_targetString;
    }

    public void fixupVariables(Vector vector, int n2) {
        super.fixupVariables(vector, n2);
        if (null != this.m_predicates) {
            int n3 = 0;
            while (n3 < this.m_predicates.length) {
                this.m_predicates[n3].fixupVariables(vector, n2);
                ++n3;
            }
        }
        if (null != this.m_relativePathPattern) {
            this.m_relativePathPattern.fixupVariables(vector, n2);
        }
    }

    public void setRelativePathPattern(StepPattern stepPattern) {
        this.m_relativePathPattern = stepPattern;
        this.calcScore();
    }

    public StepPattern getRelativePathPattern() {
        return this.m_relativePathPattern;
    }

    public Expression[] getPredicates() {
        return this.m_predicates;
    }

    public boolean canTraverseOutsideSubtree() {
        int n2 = this.getPredicateCount();
        int n3 = 0;
        while (n3 < n2) {
            if (this.getPredicate(n3).canTraverseOutsideSubtree()) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public Expression getPredicate(int n2) {
        return this.m_predicates[n2];
    }

    public final int getPredicateCount() {
        return null == this.m_predicates ? 0 : this.m_predicates.length;
    }

    public void setPredicates(Expression[] expressionArray) {
        this.m_predicates = expressionArray;
        this.calcScore();
    }

    public void calcScore() {
        if (this.getPredicateCount() > 0 || null != this.m_relativePathPattern) {
            this.m_score = NodeTest.SCORE_OTHER;
        } else {
            super.calcScore();
        }
        if (null == this.m_targetString) {
            this.calcTargetString();
        }
    }

    public XObject execute(XPathContext xPathContext, int n2) throws TransformerException {
        DTM dTM = xPathContext.getDTM(n2);
        if (dTM != null) {
            int n3 = dTM.getExpandedTypeID(n2);
            return this.execute(xPathContext, n2, dTM, n3);
        }
        return NodeTest.SCORE_NONE;
    }

    public XObject execute(XPathContext xPathContext) throws TransformerException {
        return this.execute(xPathContext, xPathContext.getCurrentNode());
    }

    public XObject execute(XPathContext xPathContext, int n2, DTM dTM, int n3) throws TransformerException {
        if (this.m_whatToShow == 65536) {
            if (null != this.m_relativePathPattern) {
                return this.m_relativePathPattern.execute(xPathContext);
            }
            return NodeTest.SCORE_NONE;
        }
        XObject xObject = super.execute(xPathContext, n2, dTM, n3);
        if (xObject == NodeTest.SCORE_NONE) {
            return NodeTest.SCORE_NONE;
        }
        if (this.getPredicateCount() != 0 && !this.executePredicates(xPathContext, dTM, n2)) {
            return NodeTest.SCORE_NONE;
        }
        if (null != this.m_relativePathPattern) {
            return this.m_relativePathPattern.executeRelativePathPattern(xPathContext, dTM, n2);
        }
        return xObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean checkProximityPosition(XPathContext xPathContext, int n2, DTM dTM, int n3, int n4) {
        try {
            DTMAxisTraverser dTMAxisTraverser = dTM.getAxisTraverser(12);
            int n5 = dTMAxisTraverser.first(n3);
            while (-1 != n5) {
                Object var18_15;
                block16: {
                    try {
                        Object var16_14;
                        int n6;
                        xPathContext.pushCurrentNode(n5);
                        if (NodeTest.SCORE_NONE == super.execute(xPathContext, n5)) break block16;
                        boolean bl2 = true;
                        try {
                            xPathContext.pushSubContextList(this);
                            n6 = 0;
                            while (n6 < n2) {
                                Object var14_13;
                                xPathContext.pushPredicatePos(n6);
                                try {
                                    Object var12_12;
                                    XObject xObject;
                                    block17: {
                                        xObject = this.m_predicates[n6].execute(xPathContext);
                                        try {
                                            if (2 == xObject.getType()) {
                                                throw new Error("Why: Should never have been called");
                                            }
                                            if (xObject.boolWithSideEffects()) break block17;
                                            bl2 = false;
                                            var12_12 = null;
                                            xObject.detach();
                                        }
                                        catch (Throwable throwable) {
                                            var12_12 = null;
                                            xObject.detach();
                                            throw throwable;
                                        }
                                        var14_13 = null;
                                        xPathContext.popPredicatePos();
                                        break;
                                    }
                                    var12_12 = null;
                                    xObject.detach();
                                }
                                catch (Throwable throwable) {
                                    var14_13 = null;
                                    xPathContext.popPredicatePos();
                                    throw throwable;
                                }
                                var14_13 = null;
                                xPathContext.popPredicatePos();
                                ++n6;
                            }
                            var16_14 = null;
                            xPathContext.popSubContextList();
                        }
                        catch (Throwable throwable) {
                            var16_14 = null;
                            xPathContext.popSubContextList();
                            throw throwable;
                        }
                        if (bl2) {
                            --n4;
                        }
                        if (n4 >= 1) break block16;
                        n6 = 0;
                        var18_15 = null;
                        xPathContext.popCurrentNode();
                        return n6 != 0;
                    }
                    catch (Throwable throwable) {
                        var18_15 = null;
                        xPathContext.popCurrentNode();
                        throw throwable;
                    }
                }
                var18_15 = null;
                xPathContext.popCurrentNode();
                n5 = dTMAxisTraverser.next(n3, n5);
            }
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException.getMessage());
        }
        return n4 == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getProximityPosition(XPathContext xPathContext, int n2, boolean bl2) {
        int n3 = 0;
        int n4 = xPathContext.getCurrentNode();
        DTM dTM = xPathContext.getDTM(n4);
        int n5 = dTM.getParent(n4);
        try {
            DTMAxisTraverser dTMAxisTraverser = dTM.getAxisTraverser(3);
            int n6 = dTMAxisTraverser.first(n5);
            while (-1 != n6) {
                Object var20_17;
                block16: {
                    try {
                        Object var18_16;
                        int n7;
                        xPathContext.pushCurrentNode(n6);
                        if (NodeTest.SCORE_NONE == super.execute(xPathContext, n6)) break block16;
                        boolean bl3 = true;
                        try {
                            xPathContext.pushSubContextList(this);
                            n7 = 0;
                            while (n7 < n2) {
                                Object var16_15;
                                Object var14_14;
                                XObject xObject;
                                xPathContext.pushPredicatePos(n7);
                                try {
                                    block17: {
                                        xObject = this.m_predicates[n7].execute(xPathContext);
                                        if (2 != xObject.getType()) break block17;
                                        if (n3 + 1 == (int)xObject.numWithSideEffects()) break block18;
                                        bl3 = false;
                                        var14_14 = null;
                                        xObject.detach();
                                        var16_15 = null;
                                        xPathContext.popPredicatePos();
                                        break;
                                    }
                                    if (xObject.boolWithSideEffects()) break block18;
                                    bl3 = false;
                                    var14_14 = null;
                                    xObject.detach();
                                }
                                catch (Throwable throwable) {
                                    var16_15 = null;
                                    xPathContext.popPredicatePos();
                                    throw throwable;
                                }
                                var16_15 = null;
                                xPathContext.popPredicatePos();
                                {
                                    block18: {
                                        break;
                                    }
                                    try {
                                        var14_14 = null;
                                        xObject.detach();
                                    }
                                    catch (Throwable throwable) {
                                        var14_14 = null;
                                        xObject.detach();
                                        throw throwable;
                                    }
                                }
                                var16_15 = null;
                                xPathContext.popPredicatePos();
                                ++n7;
                            }
                            var18_16 = null;
                            xPathContext.popSubContextList();
                        }
                        catch (Throwable throwable) {
                            var18_16 = null;
                            xPathContext.popSubContextList();
                            throw throwable;
                        }
                        if (bl3) {
                            ++n3;
                        }
                        if (bl2 || n6 != n4) break block16;
                        n7 = n3;
                        var20_17 = null;
                        xPathContext.popCurrentNode();
                        return n7;
                    }
                    catch (Throwable throwable) {
                        var20_17 = null;
                        xPathContext.popCurrentNode();
                        throw throwable;
                    }
                }
                var20_17 = null;
                xPathContext.popCurrentNode();
                n6 = dTMAxisTraverser.next(n5, n6);
            }
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException.getMessage());
        }
        return n3;
    }

    public int getProximityPosition(XPathContext xPathContext) {
        return this.getProximityPosition(xPathContext, xPathContext.getPredicatePos(), false);
    }

    public int getLastPos(XPathContext xPathContext) {
        return this.getProximityPosition(xPathContext, xPathContext.getPredicatePos(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final XObject executeRelativePathPattern(XPathContext xPathContext, DTM dTM, int n2) throws TransformerException {
        XObject xObject = NodeTest.SCORE_NONE;
        int n3 = n2;
        DTMAxisTraverser dTMAxisTraverser = dTM.getAxisTraverser(this.m_axis);
        int n4 = dTMAxisTraverser.first(n3);
        while (-1 != n4) {
            Object var9_8;
            try {
                xPathContext.pushCurrentNode(n4);
                xObject = this.execute(xPathContext);
                if (xObject != NodeTest.SCORE_NONE) {
                    var9_8 = null;
                    xPathContext.popCurrentNode();
                    break;
                }
                var9_8 = null;
                xPathContext.popCurrentNode();
            }
            catch (Throwable throwable) {
                var9_8 = null;
                xPathContext.popCurrentNode();
                throw throwable;
            }
            n4 = dTMAxisTraverser.next(n3, n4);
        }
        return xObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean executePredicates(XPathContext xPathContext, DTM dTM, int n2) throws TransformerException {
        boolean bl2 = true;
        boolean bl3 = false;
        int n3 = this.getPredicateCount();
        try {
            xPathContext.pushSubContextList(this);
            int n4 = 0;
            while (n4 < n3) {
                Object var13_11;
                Object var11_10;
                XObject xObject;
                xPathContext.pushPredicatePos(n4);
                try {
                    int n5;
                    block11: {
                        xObject = this.m_predicates[n4].execute(xPathContext);
                        if (2 != xObject.getType()) break block10;
                        n5 = (int)xObject.num();
                        if (!bl3) break block11;
                        bl2 = n5 == 1;
                        var11_10 = null;
                        xObject.detach();
                        var13_11 = null;
                        xPathContext.popPredicatePos();
                        break;
                    }
                    bl3 = true;
                    if (this.checkProximityPosition(xPathContext, n4, dTM, n2, n5)) break block12;
                    bl2 = false;
                    var11_10 = null;
                    xObject.detach();
                }
                catch (Throwable throwable) {
                    var13_11 = null;
                    xPathContext.popPredicatePos();
                    throw throwable;
                }
                var13_11 = null;
                xPathContext.popPredicatePos();
                {
                    block10: {
                        break;
                    }
                    if (xObject.boolWithSideEffects()) break block12;
                    bl2 = false;
                    var11_10 = null;
                    xObject.detach();
                }
                var13_11 = null;
                xPathContext.popPredicatePos();
                {
                    block12: {
                        break;
                    }
                    try {
                        var11_10 = null;
                        xObject.detach();
                    }
                    catch (Throwable throwable) {
                        var11_10 = null;
                        xObject.detach();
                        throw throwable;
                    }
                }
                var13_11 = null;
                xPathContext.popPredicatePos();
                ++n4;
            }
            Object var15_14 = null;
            xPathContext.popSubContextList();
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            xPathContext.popSubContextList();
            throw throwable;
        }
        return bl2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        StepPattern stepPattern = this;
        while (stepPattern != null) {
            if (stepPattern != this) {
                stringBuffer.append("/");
            }
            stringBuffer.append(Axis.names[stepPattern.m_axis]);
            stringBuffer.append("::");
            if (20480 == stepPattern.m_whatToShow) {
                stringBuffer.append("doc()");
            } else if (65536 == stepPattern.m_whatToShow) {
                stringBuffer.append("function()");
            } else if (-1 == stepPattern.m_whatToShow) {
                stringBuffer.append("node()");
            } else if (4 == stepPattern.m_whatToShow) {
                stringBuffer.append("text()");
            } else if (64 == stepPattern.m_whatToShow) {
                stringBuffer.append("processing-instruction(");
                if (null != stepPattern.m_name) {
                    stringBuffer.append(stepPattern.m_name);
                }
                stringBuffer.append(")");
            } else if (128 == stepPattern.m_whatToShow) {
                stringBuffer.append("comment()");
            } else if (null != stepPattern.m_name) {
                if (2 == stepPattern.m_whatToShow) {
                    stringBuffer.append("@");
                }
                if (null != stepPattern.m_namespace) {
                    stringBuffer.append("{");
                    stringBuffer.append(stepPattern.m_namespace);
                    stringBuffer.append("}");
                }
                stringBuffer.append(stepPattern.m_name);
            } else if (2 == stepPattern.m_whatToShow) {
                stringBuffer.append("@");
            } else if (1280 == stepPattern.m_whatToShow) {
                stringBuffer.append("doc-root()");
            } else {
                stringBuffer.append("?" + Integer.toHexString(stepPattern.m_whatToShow));
            }
            if (null != stepPattern.m_predicates) {
                int n2 = 0;
                while (n2 < stepPattern.m_predicates.length) {
                    stringBuffer.append("[");
                    stringBuffer.append(stepPattern.m_predicates[n2]);
                    stringBuffer.append("]");
                    ++n2;
                }
            }
            stepPattern = stepPattern.m_relativePathPattern;
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMatchScore(XPathContext xPathContext, int n2) throws TransformerException {
        xPathContext.pushCurrentNode(n2);
        xPathContext.pushCurrentExpressionNode(n2);
        try {
            XObject xObject = this.execute(xPathContext);
            double d2 = xObject.num();
            Object var7_5 = null;
            xPathContext.popCurrentNode();
            xPathContext.popCurrentExpressionNode();
            return d2;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            xPathContext.popCurrentNode();
            xPathContext.popCurrentExpressionNode();
            throw throwable;
        }
    }

    public void setAxis(int n2) {
        this.m_axis = n2;
    }

    public int getAxis() {
        return this.m_axis;
    }
}

