/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SpinnerUI;
import javax.swing.plaf.basic.BasicArrowButton;

public class BasicSpinnerUI
extends SpinnerUI {
    protected JSpinner spinner;
    private static final PropertyChangeListener propertyChangeListener = new PropertyChangeHandler();
    private static final ArrowButtonHandler nextButtonHandler = new ArrowButtonHandler(true);
    private static final ArrowButtonHandler previousButtonHandler = new ArrowButtonHandler(false);
    private static final Dimension zeroSize = new Dimension(0, 0);

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicSpinnerUI();
    }

    private void maybeAdd(Component component, String string) {
        if (component != null) {
            this.spinner.add(component, string);
        }
    }

    public void installUI(JComponent jComponent) {
        this.spinner = (JSpinner)jComponent;
        this.installDefaults();
        this.installListeners();
        this.maybeAdd(this.createNextButton(), "Next");
        this.maybeAdd(this.createPreviousButton(), "Previous");
        this.maybeAdd(this.createEditor(), "Editor");
        this.updateEnabledState();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.spinner = null;
        jComponent.removeAll();
    }

    protected void installListeners() {
        this.spinner.addPropertyChangeListener(propertyChangeListener);
    }

    protected void uninstallListeners() {
        this.spinner.removePropertyChangeListener(propertyChangeListener);
    }

    protected void installDefaults() {
        this.spinner.setLayout(this.createLayout());
        LookAndFeel.installBorder(this.spinner, "Spinner.border");
        LookAndFeel.installColorsAndFont(this.spinner, "Spinner.background", "Spinner.foreground", "Spinner.font");
    }

    protected void uninstallDefaults() {
        this.spinner.setLayout(null);
    }

    protected LayoutManager createLayout() {
        return new SpinnerLayout();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected Component createPreviousButton() {
        BasicArrowButton basicArrowButton = new BasicArrowButton(5);
        basicArrowButton.addActionListener(previousButtonHandler);
        basicArrowButton.addMouseListener(previousButtonHandler);
        return basicArrowButton;
    }

    protected Component createNextButton() {
        BasicArrowButton basicArrowButton = new BasicArrowButton(1);
        basicArrowButton.addActionListener(nextButtonHandler);
        basicArrowButton.addMouseListener(nextButtonHandler);
        return basicArrowButton;
    }

    protected JComponent createEditor() {
        return this.spinner.getEditor();
    }

    protected void replaceEditor(JComponent jComponent, JComponent jComponent2) {
        this.spinner.remove(jComponent);
        this.spinner.add((Component)jComponent2, "Editor");
    }

    private void updateEnabledState() {
        this.updateEnabledState(this.spinner, this.spinner.isEnabled());
    }

    private void updateEnabledState(Container container, boolean bl2) {
        int n2 = container.getComponentCount() - 1;
        while (n2 >= 0) {
            Component component = container.getComponent(n2);
            component.setEnabled(bl2);
            if (component instanceof Container) {
                this.updateEnabledState((Container)component, bl2);
            }
            --n2;
        }
    }

    private void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.spinner, 1, inputMap);
    }

    private InputMap getInputMap(int n2) {
        if (n2 == 1) {
            return (InputMap)UIManager.get("Spinner.ancestorInputMap");
        }
        return null;
    }

    private static class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            JSpinner jSpinner = (JSpinner)propertyChangeEvent.getSource();
            SpinnerUI spinnerUI = jSpinner.getUI();
            if (spinnerUI instanceof BasicSpinnerUI) {
                BasicSpinnerUI basicSpinnerUI = (BasicSpinnerUI)spinnerUI;
                if ("editor".equals(string)) {
                    JComponent jComponent = (JComponent)propertyChangeEvent.getOldValue();
                    JComponent jComponent2 = (JComponent)propertyChangeEvent.getNewValue();
                    basicSpinnerUI.replaceEditor(jComponent, jComponent2);
                    basicSpinnerUI.updateEnabledState();
                } else if ("enabled".equals(string)) {
                    basicSpinnerUI.updateEnabledState();
                }
            }
        }
    }

    private static class SpinnerLayout
    implements LayoutManager {
        private Component nextButton = null;
        private Component previousButton = null;
        private Component editor = null;

        private SpinnerLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
            if ("Next".equals(string)) {
                this.nextButton = component;
            } else if ("Previous".equals(string)) {
                this.previousButton = component;
            } else if ("Editor".equals(string)) {
                this.editor = component;
            }
        }

        public void removeLayoutComponent(Component component) {
            if (component == this.nextButton) {
                component = null;
            } else if (component == this.previousButton) {
                this.previousButton = null;
            } else if (component == this.editor) {
                this.editor = null;
            }
        }

        private Dimension preferredSize(Component component) {
            return component == null ? zeroSize : component.getPreferredSize();
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = this.preferredSize(this.nextButton);
            Dimension dimension2 = this.preferredSize(this.previousButton);
            Dimension dimension3 = this.preferredSize(this.editor);
            dimension3.height = (dimension3.height + 1) / 2 * 2;
            Dimension dimension4 = new Dimension(dimension3.width, dimension3.height);
            dimension4.width += Math.max(dimension.width, dimension2.width);
            Insets insets = container.getInsets();
            dimension4.width += insets.left + insets.right;
            dimension4.height += insets.top + insets.bottom;
            return dimension4;
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        private void setBounds(Component component, int n2, int n3, int n4, int n5) {
            if (component != null) {
                component.setBounds(n2, n3, n4, n5);
            }
        }

        public void layoutContainer(Container container) {
            int n2;
            int n3;
            Insets insets = container.getInsets();
            int n4 = container.getWidth() - (insets.left + insets.right);
            int n5 = container.getHeight() - (insets.top + insets.bottom);
            Dimension dimension = this.preferredSize(this.nextButton);
            Dimension dimension2 = this.preferredSize(this.previousButton);
            int n6 = n5 / 2;
            int n7 = n5 - n6;
            int n8 = Math.max(dimension.width, dimension2.width);
            int n9 = n4 - n8;
            if (container.getComponentOrientation().isLeftToRight()) {
                n3 = insets.left;
                n2 = n3 + n9;
            } else {
                n2 = insets.left;
                n3 = n2 + n8;
            }
            int n10 = insets.top + n6;
            this.setBounds(this.editor, n3, insets.top, n9, n5);
            this.setBounds(this.nextButton, n2, insets.top, n8, n6);
            this.setBounds(this.previousButton, n2, n10, n8, n7);
        }
    }

    private static class ArrowButtonHandler
    extends MouseAdapter
    implements ActionListener {
        final Timer autoRepeatTimer;
        final boolean isNext;
        JSpinner spinner = null;

        ArrowButtonHandler(boolean bl2) {
            this.isNext = bl2;
            this.autoRepeatTimer = new Timer(60, this);
            this.autoRepeatTimer.setInitialDelay(300);
        }

        private JSpinner eventToSpinner(AWTEvent aWTEvent) {
            Object object = aWTEvent.getSource();
            while (object instanceof Component && !(object instanceof JSpinner)) {
                object = ((Component)object).getParent();
            }
            return object instanceof JSpinner ? (JSpinner)object : null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.spinner != null) {
                try {
                    Object object;
                    this.spinner.commitEdit();
                    Object object2 = object = this.isNext ? this.spinner.getNextValue() : this.spinner.getPreviousValue();
                    if (object != null) {
                        this.spinner.setValue(object);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(this.spinner);
                }
                catch (ParseException parseException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(this.spinner);
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getComponent().isEnabled()) {
                this.spinner = this.eventToSpinner(mouseEvent);
                this.autoRepeatTimer.start();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.autoRepeatTimer.stop();
            this.spinner = null;
        }
    }
}

