/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.Header;
import com.sun.jndi.dns.Packet;
import com.sun.jndi.dns.ResourceRecords;
import com.sun.jndi.dns.Tcp;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.naming.CommunicationException;
import javax.naming.ConfigurationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.ServiceUnavailableException;

public class DnsClient {
    private static final int IDENT_OFFSET = 0;
    private static final int FLAGS_OFFSET = 2;
    private static final int NUMQ_OFFSET = 4;
    private static final int NUMANS_OFFSET = 6;
    private static final int NUMAUTH_OFFSET = 8;
    private static final int NUMADD_OFFSET = 10;
    private static final int DNS_HDR_SIZE = 12;
    private static final int NO_ERROR = 0;
    private static final int FORMAT_ERROR = 1;
    private static final int SERVER_FAILURE = 2;
    private static final int NAME_ERROR = 3;
    private static final int NOT_IMPL = 4;
    private static final int REFUSED = 5;
    private static final String[] rcodeDescription = new String[]{"No error", "DNS format error", "DNS server failure", "DNS name not found", "DNS operation not supported", "DNS service refused"};
    private static final int QR_BIT = 32768;
    private static final int OPCODE_MASK = 30720;
    private static final int AA_BIT = 1024;
    private static final int TC_BIT = 512;
    private static final int RD_BIT = 256;
    private static final int RA_BIT = 128;
    private static final int RCODE_MASK = 15;
    private static final int DEFAULT_PORT = 53;
    private InetAddress[] servers;
    private int[] serverPorts;
    private DatagramSocket udpSocket;
    private short ident = 0;
    private Object identLock = new Object();
    private static final int MAX_TIMEOUTS = 4;
    private static final int LOOKUP_TIMEOUT = 1000;

    public DnsClient(String[] stringArray) throws NamingException {
        try {
            this.udpSocket = new DatagramSocket();
        }
        catch (SocketException socketException) {
            ConfigurationException configurationException = new ConfigurationException();
            configurationException.setRootCause(socketException);
            throw configurationException;
        }
        this.servers = new InetAddress[stringArray.length];
        this.serverPorts = new int[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            int n3 = stringArray[n2].indexOf(58, stringArray[n2].indexOf(93) + 1);
            this.serverPorts[n2] = n3 < 0 ? 53 : Integer.parseInt(stringArray[n2].substring(n3 + 1));
            String string = n3 < 0 ? stringArray[n2] : stringArray[n2].substring(0, n3);
            try {
                this.servers[n2] = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                ConfigurationException configurationException = new ConfigurationException("Unknown DNS server: " + string);
                configurationException.setRootCause(unknownHostException);
                throw configurationException;
            }
            ++n2;
        }
    }

    protected void finalize() {
        this.close();
    }

    public void close() {
        this.udpSocket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceRecords query(String string, int n2, int n3, boolean bl2, boolean bl3) throws NamingException {
        short s2;
        Object object = this.identLock;
        synchronized (object) {
            s2 = this.ident = (short)(this.ident + 1);
        }
        Packet packet = this.makeQueryPacket(string, s2, n2, n3, bl2);
        Exception exception = null;
        boolean[] blArray = new boolean[this.servers.length];
        int n4 = 0;
        while (n4 < 4) {
            int n5 = 0;
            while (n5 < this.servers.length) {
                block24: {
                    if (!blArray[n5]) {
                        try {
                            DatagramPacket datagramPacket = this.doUdpQuery(packet, this.servers[n5], this.serverPorts[n5], n4);
                            byte[] byArray = datagramPacket.getData();
                            int n6 = datagramPacket.getLength();
                            Header header = new Header(byArray, n6);
                            this.checkHeader(header, s2);
                            if (bl3 && !header.authoritative) {
                                exception = new NameNotFoundException("DNS response not authoritative");
                                blArray[n5] = true;
                                break block24;
                            }
                            if (header.truncated) {
                                int n7 = 0;
                                while (n7 < this.servers.length) {
                                    int n8 = (n5 + n7) % this.servers.length;
                                    if (!blArray[n8]) {
                                        try {
                                            Object var22_30;
                                            byte[] byArray2;
                                            Tcp tcp = new Tcp(this.servers[n8], this.serverPorts[n8]);
                                            try {
                                                byArray2 = this.doTcpQuery(tcp, packet);
                                                var22_30 = null;
                                            }
                                            catch (Throwable throwable) {
                                                var22_30 = null;
                                                tcp.close();
                                                throw throwable;
                                            }
                                            tcp.close();
                                            Header header2 = new Header(byArray2, byArray2.length);
                                            this.checkHeader(header2, s2);
                                            if (!bl3 || header2.authoritative) {
                                                header = header2;
                                                byArray = byArray2;
                                                n6 = byArray2.length;
                                                break;
                                            }
                                            blArray[n8] = true;
                                        }
                                        catch (Exception exception2) {
                                            // empty catch block
                                        }
                                    }
                                    ++n7;
                                }
                            }
                            return new ResourceRecords(byArray, n6, header, false);
                        }
                        catch (IOException iOException) {
                            if (exception == null) {
                                exception = iOException;
                            }
                        }
                        catch (NameNotFoundException nameNotFoundException) {
                            throw nameNotFoundException;
                        }
                        catch (CommunicationException communicationException) {
                            if (exception == null) {
                                exception = communicationException;
                            }
                        }
                        catch (NamingException namingException) {
                            if (exception == null) {
                                exception = namingException;
                            }
                            blArray[n5] = true;
                        }
                    }
                }
                ++n5;
            }
            ++n4;
        }
        if (exception instanceof NamingException) {
            throw (NamingException)exception;
        }
        CommunicationException communicationException = new CommunicationException("DNS error");
        communicationException.setRootCause(exception);
        throw communicationException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceRecords queryZone(String string, int n2, boolean bl2) throws NamingException {
        short s2;
        Object object = this.identLock;
        synchronized (object) {
            s2 = this.ident = (short)(this.ident + 1);
        }
        Packet packet = this.makeQueryPacket(string, s2, n2, 252, bl2);
        Exception exception = null;
        int n3 = 0;
        while (n3 < this.servers.length) {
            try {
                ResourceRecords resourceRecords;
                Tcp tcp = new Tcp(this.servers[n3], this.serverPorts[n3]);
                try {
                    byte[] byArray = this.doTcpQuery(tcp, packet);
                    Header header = new Header(byArray, byArray.length);
                    this.checkResponseCode(header);
                    ResourceRecords resourceRecords2 = new ResourceRecords(byArray, byArray.length, header, true);
                    if (resourceRecords2.getFirstAnsType() != 6) {
                        throw new CommunicationException("DNS error: zone xfer doesn't begin with SOA");
                    }
                    if (resourceRecords2.answer.size() == 1 || resourceRecords2.getLastAnsType() != 6) {
                        do {
                            if ((byArray = this.continueTcpQuery(tcp)) == null) {
                                throw new CommunicationException("DNS error: incomplete zone transfer");
                            }
                            header = new Header(byArray, byArray.length);
                            this.checkResponseCode(header);
                            resourceRecords2.add(byArray, byArray.length, header);
                        } while (resourceRecords2.getLastAnsType() != 6);
                    }
                    resourceRecords2.answer.removeElementAt(resourceRecords2.answer.size() - 1);
                    resourceRecords = resourceRecords2;
                    Object var15_19 = null;
                }
                catch (Throwable throwable) {
                    Object var15_20 = null;
                    tcp.close();
                    throw throwable;
                }
                tcp.close();
                return resourceRecords;
            }
            catch (IOException iOException) {
                exception = iOException;
            }
            catch (NameNotFoundException nameNotFoundException) {
                throw nameNotFoundException;
            }
            catch (NamingException namingException) {
                exception = namingException;
            }
            ++n3;
        }
        if (exception instanceof NamingException) {
            throw (NamingException)exception;
        }
        CommunicationException communicationException = new CommunicationException("DNS error during zone transfer");
        communicationException.setRootCause(exception);
        throw communicationException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatagramPacket doUdpQuery(Packet packet, InetAddress inetAddress, int n2, int n3) throws IOException {
        DatagramSocket datagramSocket = this.udpSocket;
        synchronized (datagramSocket) {
            DatagramPacket datagramPacket = new DatagramPacket(packet.getData(), packet.length(), inetAddress, n2);
            this.udpSocket.send(datagramPacket);
            this.udpSocket.setSoTimeout(1000 * (1 << n3));
            DatagramPacket datagramPacket2 = new DatagramPacket(new byte[8000], 8000);
            this.udpSocket.receive(datagramPacket2);
            DatagramPacket datagramPacket3 = datagramPacket2;
            return datagramPacket3;
        }
    }

    private byte[] doTcpQuery(Tcp tcp, Packet packet) throws IOException {
        int n2 = packet.length();
        tcp.out.write(n2 >> 8);
        tcp.out.write(n2);
        tcp.out.write(packet.getData(), 0, n2);
        tcp.out.flush();
        byte[] byArray = this.continueTcpQuery(tcp);
        if (byArray == null) {
            throw new IOException("DNS error: no response");
        }
        return byArray;
    }

    private byte[] continueTcpQuery(Tcp tcp) throws IOException {
        int n2 = tcp.in.read();
        if (n2 == -1) {
            return null;
        }
        int n3 = tcp.in.read();
        if (n3 == -1) {
            throw new IOException("Corrupted DNS response: bad length");
        }
        int n4 = n2 << 8 | n3;
        byte[] byArray = new byte[n4];
        int n5 = 0;
        while (n4 > 0) {
            int n6 = tcp.in.read(byArray, n5, n4);
            if (n6 == -1) {
                throw new IOException("Corrupted DNS response: too little data");
            }
            n4 -= n6;
            n5 += n6;
        }
        return byArray;
    }

    private Packet makeQueryPacket(String string, int n2, int n3, int n4, boolean bl2) {
        byte[] byArray = new byte[string.length() + 2];
        int n5 = this.makeQueryName(string, byArray);
        int n6 = 12 + n5 + 4;
        Packet packet = new Packet(n6);
        int n7 = bl2 ? 256 : 0;
        packet.putShort(n2, 0);
        packet.putShort(n7, 2);
        packet.putShort(1, 4);
        packet.putShort(0, 6);
        packet.putInt(0, 8);
        packet.putBytes(byArray, 0, 12, n5);
        packet.putShort(n4, 12 + n5);
        packet.putShort(n3, 12 + n5 + 2);
        return packet;
    }

    private int makeQueryName(String string, byte[] byArray) {
        byte[] byArray2;
        if (string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            byArray2 = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return 0;
        }
        boolean bl2 = byArray2.length == 0;
        while (!bl2) {
            if ((n2 = string.indexOf(46, n2)) == -1) {
                n2 = string.length();
                bl2 = true;
            }
            int n5 = n2 - n3;
            byArray[n4] = (byte)n5;
            System.arraycopy(byArray2, n3, byArray, ++n4, n2 - n3);
            n4 += n5;
            if (n2 == -1) break;
            n3 = ++n2;
        }
        byArray[n4++] = 0;
        return n4;
    }

    private void checkHeader(Header header, int n2) throws NamingException {
        if (n2 != -1 && n2 != header.xid) {
            throw new CommunicationException("DNS error: ID doesn't match");
        }
        if (header.query) {
            throw new CommunicationException("DNS error: expecting response");
        }
        this.checkResponseCode(header);
    }

    private void checkResponseCode(Header header) throws NamingException {
        int n2 = header.rcode;
        if (n2 == 0) {
            return;
        }
        String string = n2 < rcodeDescription.length ? rcodeDescription[n2] : "DNS error";
        string = string + " [response code " + n2 + "]";
        switch (n2) {
            case 2: {
                throw new ServiceUnavailableException(string);
            }
            case 3: {
                throw new NameNotFoundException(string);
            }
            case 4: 
            case 5: {
                throw new OperationNotSupportedException(string);
            }
        }
        throw new NamingException(string);
    }
}

