/*
 * Decompiled with CFR 0.152.
 */
package java.rmi;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public final class Naming {
    public static Remote lookup(String name) throws NotBoundException, MalformedURLException, RemoteException {
        URL u = new URL("http:" + name);
        return Naming.getRegistry(u).lookup(u.getFile().substring(1));
    }

    public static void bind(String name, Remote obj) throws AlreadyBoundException, MalformedURLException, RemoteException {
        URL u = new URL("http:" + name);
        Naming.getRegistry(u).bind(u.getFile().substring(1), obj);
    }

    public static void unbind(String name) throws RemoteException, NotBoundException, MalformedURLException {
        URL u = new URL("http:" + name);
        Naming.getRegistry(u).unbind(u.getFile().substring(1));
    }

    public static void rebind(String name, Remote obj) throws RemoteException, MalformedURLException {
        URL u = new URL("http:" + name);
        Naming.getRegistry(u).rebind(u.getFile().substring(1), obj);
    }

    public static String[] list(String name) throws RemoteException, MalformedURLException {
        return Naming.getRegistry(new URL("http:" + name)).list();
    }

    private static Registry getRegistry(URL u) throws RemoteException {
        if (u.getPort() == -1) {
            return LocateRegistry.getRegistry(u.getHost());
        }
        return LocateRegistry.getRegistry(u.getHost(), u.getPort());
    }
}

