/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;

public final class DatagramPacket {
    private byte[] buffer;
    private int offset;
    private int length;
    private InetAddress address;
    private int port;

    public DatagramPacket(byte[] buf, int offset, int length) {
        if (buf == null) {
            throw new NullPointerException("Null buffer");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Invalid offset: " + offset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("Invalid length: " + length);
        }
        if (offset + length > buf.length) {
            throw new IllegalArgumentException("Potential buffer overflow - offset: " + offset + " length: " + length);
        }
        this.buffer = buf;
        this.offset = offset;
        this.length = length;
        this.address = null;
        this.port = -1;
    }

    public DatagramPacket(byte[] buf, int length) {
        this(buf, 0, length);
    }

    public DatagramPacket(byte[] buf, int offset, int length, InetAddress address, int port) {
        if (buf == null) {
            throw new NullPointerException("Null buffer");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Invalid offset: " + offset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("Invalid length: " + length);
        }
        if (offset + length > buf.length) {
            throw new IllegalArgumentException("Potential buffer overflow - offset: " + offset + " length: " + length);
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        if (address == null) {
            throw new NullPointerException("Null address");
        }
        this.buffer = buf;
        this.offset = offset;
        this.length = length;
        this.address = address;
        this.port = port;
    }

    public DatagramPacket(byte[] buf, int length, InetAddress address, int port) {
        this(buf, 0, length, address, port);
    }

    public synchronized InetAddress getAddress() {
        return this.address;
    }

    public synchronized int getPort() {
        return this.port;
    }

    public synchronized byte[] getData() {
        return this.buffer;
    }

    public synchronized int getOffset() {
        return this.offset;
    }

    public synchronized int getLength() {
        return this.length;
    }

    public synchronized void setAddress(InetAddress iaddr) {
        if (iaddr == null) {
            throw new NullPointerException("Null address");
        }
        this.address = iaddr;
    }

    public synchronized void setPort(int iport) {
        if (iport < 0 || iport > 65535) {
            throw new IllegalArgumentException("Invalid port: " + iport);
        }
        this.port = iport;
    }

    public synchronized void setData(byte[] buf) {
        if (buf == null) {
            throw new NullPointerException("Null buffer");
        }
        this.buffer = buf;
    }

    public synchronized void setData(byte[] buf, int offset, int length) {
        if (buf == null) {
            throw new NullPointerException("Null buffer");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Invalid offset: " + offset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("Invalid length: " + length);
        }
        if (offset + length > buf.length) {
            throw new IllegalArgumentException("Potential buffer overflow - offset: " + offset + " length: " + length);
        }
        this.buffer = buf;
        this.offset = offset;
        this.length = length;
    }

    public synchronized void setLength(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Invalid length: " + length);
        }
        if (this.offset + length > this.buffer.length) {
            throw new IllegalArgumentException("Potential buffer overflow - offset: " + this.offset + " length: " + length);
        }
        this.length = length;
    }
}

