/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Long
extends Number
implements Comparable {
    static final long serialVersionUID = 4290774380558885855L;
    public static final long MIN_VALUE = -9223372036854775808L;
    public static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFFL;
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('J');
    private final long value;

    public Long(long value) {
        this.value = value;
    }

    public Long(String s) throws NumberFormatException {
        this.value = Long.parseLong(s, 10);
    }

    public boolean equals(Object obj) {
        return obj instanceof Long && ((Long)obj).value == this.value;
    }

    public int hashCode() {
        return (int)this.value ^ (int)(this.value >>> 32);
    }

    public static Long getLong(String nm) {
        return Long.getLong(nm, null);
    }

    public static Long getLong(String nm, long val) {
        Long result = Long.getLong(nm, null);
        if (result == null) {
            return new Long(val);
        }
        return result;
    }

    public static Long getLong(String nm, Long def) {
        if ((nm = System.getProperty(nm)) == null || "".equals(nm)) {
            return def;
        }
        try {
            return Long.decode(nm);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    private static String toUnsignedString(long num, int exp) {
        int radix = 1 << (exp & 0x1F);
        int mask = radix - 1;
        char[] buffer = new char[64];
        int i = 64;
        do {
            buffer[--i] = Character.forDigit((int)num & mask, radix);
        } while ((num >>>= exp & 0x3F) != 0L);
        return String.valueOf(buffer, i, 64 - i);
    }

    public static String toHexString(long i) {
        return Long.toUnsignedString(i, 4);
    }

    public static String toOctalString(long i) {
        return Long.toUnsignedString(i, 3);
    }

    public static String toBinaryString(long i) {
        return Long.toUnsignedString(i, 1);
    }

    public static String toString(long num) {
        boolean isNeg;
        if (num <= Integer.MAX_VALUE && num >= Integer.MIN_VALUE) {
            return Integer.toString((int)num);
        }
        char[] buffer = new char[20];
        int i = 20;
        if (num < 0L) {
            isNeg = true;
            if ((num = -num) < 0L) {
                buffer[--i] = 56;
                num = 0xCCCCCCCCCCCCCCCL;
            }
        } else {
            isNeg = false;
        }
        do {
            buffer[--i] = (char)((long)48 + num % (long)10);
        } while ((num /= (long)10) > 0L);
        if (isNeg) {
            buffer[--i] = 45;
        }
        return String.valueOf(buffer, i, 20 - i);
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public static String toString(long num, int radix) {
        boolean isNeg;
        if (radix == 10 || radix < 2 || radix > 36) {
            return Long.toString(num);
        }
        if (num <= Integer.MAX_VALUE && num >= Integer.MIN_VALUE) {
            return Integer.toString((int)num, radix);
        }
        char[] buffer = new char[65];
        int i = 65;
        if (num < 0L) {
            isNeg = true;
            if ((num = -num) < 0L) {
                buffer[--i] = Character.forDigit((int)(-(num + (long)radix) % (long)radix), radix);
                num = -(num / (long)radix);
            }
        } else {
            isNeg = false;
        }
        do {
            buffer[--i] = Character.forDigit((int)(num % (long)radix), radix);
        } while ((num /= (long)radix) > 0L);
        if (isNeg) {
            buffer[--i] = 45;
        }
        return String.valueOf(buffer, i, 65 - i);
    }

    public static Long valueOf(String s) throws NumberFormatException {
        return new Long(Long.parseLong(s));
    }

    public static Long valueOf(String s, int radix) throws NumberFormatException {
        return new Long(Long.parseLong(s, radix));
    }

    public static long parseLong(String s) throws NumberFormatException {
        return Long.parseLong(s, 10);
    }

    public static long parseLong(String str, int radix) throws NumberFormatException {
        int len = str.length();
        if (len == 0 || radix < 2 || radix > 36) {
            throw new NumberFormatException();
        }
        boolean isNeg = false;
        int index = 0;
        if (str.charAt(index) == '-') {
            if (len > 1) {
                isNeg = true;
                ++index;
            } else {
                throw new NumberFormatException();
            }
        }
        return Long.parseLong(str, index, len, isNeg, radix);
    }

    public static Long decode(String str) throws NumberFormatException {
        boolean isNeg = false;
        int index = 0;
        int radix = 10;
        int len = str.length();
        if (len == 0) {
            throw new NumberFormatException();
        }
        if (str.charAt(0) == '-') {
            radix = 10;
            ++index;
            isNeg = true;
        } else if (str.charAt(index) == '#') {
            radix = 16;
            ++index;
        } else if (str.charAt(index) == '0') {
            if (len == 1) {
                return new Long(0L);
            }
            if (str.charAt(++index) == 'x') {
                radix = 16;
                ++index;
            } else {
                radix = 8;
            }
        }
        if (index >= len) {
            throw new NumberFormatException();
        }
        return new Long(Long.parseLong(str, index, len, isNeg, radix));
    }

    private static long parseLong(String str, int index, int len, boolean isNeg, int radix) throws NumberFormatException {
        long val = 0L;
        long max = Long.MAX_VALUE / (long)radix;
        if (isNeg && Long.MAX_VALUE % (long)radix == (long)(radix - 1)) {
            ++max;
        }
        while (index < len) {
            if (val < 0L || val > max) {
                throw new NumberFormatException();
            }
            int digval = Character.digit(str.charAt(index), radix);
            if (digval < 0) {
                throw new NumberFormatException();
            }
            if (!((val = val * (long)radix + (long)digval) >= 0L || isNeg && val == Long.MIN_VALUE)) {
                throw new NumberFormatException();
            }
            ++index;
        }
        if (isNeg) {
            return -val;
        }
        return val;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public int compareTo(Long l) {
        if (this.value == l.value) {
            return 0;
        }
        if (this.value > l.value) {
            return 1;
        }
        return -1;
    }

    public int compareTo(Object o) {
        return this.compareTo((Long)o);
    }
}

