/*
 * METALBASE 5.1
 *
 * Released January 1st, 1993 by Huan-Ti [ t-richj@microsoft.com ]
 *
 */

#include <mbase.h>

/*
 * PROTOTYPES -----------------------------------------------------------------
 *
 */

   static struct tm *_getlt XARGS( (void) );


/*
 * VARIABLES ------------------------------------------------------------------
 *
 */

static char *WordMonth[12] =
   {
   "Jan", "Feb", "Mar", "Apr", "May", "Jun",
   "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
   };

static char *WordDay[7] =
   {
   "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"
   };


/*
 * SERVICE ROUTINES -----------------------------------------------------------
 *
 */

static struct tm *
_getlt ()                 /* == Get LocalTime, in {struct tm *} */
{
   time_t date;
   time (&date);          /* If your compiler complains, try date=time(); */
   return localtime (&date);
}


/*
 * TIME/DATE FUNCTIONS --------------------------------------------------------
 *
 */

long
elap_t (tme)
mb_time tme;
{
   long     dif;
   mb_time  now;

   now = curtime();

   dif  = 3600L * (long)(GetHours(now)   - GetHours(tme));
   dif +=   60L * (long)(GetMinutes(now) - GetMinutes(tme));
   dif +=    1L * (long)(GetSeconds(now) - GetSeconds(tme));

   if (dif < 0)             /* If it's negative, then assume that the */
      dif += (3600L * 24);  /* day has changed, and add 24 hours.     */

   return dif;
}

mb_time
tmtotime  (tim)  /* Pass NULL to get current time */
struct tm *tim;
{
   struct tm  *ptr;
   mb_time     ret;
#ifndef NO_TIMEB
   struct timeb tb;
#endif

   ptr = (tim == (struct tm *)0) ? _getlt() : tim;

   SetHours   (ret, ptr->tm_hour);
   SetMinutes (ret, ptr->tm_min);
   SetSeconds (ret, ptr->tm_sec);
   SetMicros  (ret, 0);           /* No 100/sec precision from _getlt(). */

#ifndef NO_TIMEB
   if (tim == NULL)
      {
      ftime (&tb);
      SetMicros (ret, tb.millitm / 10);
      }
#endif

   return ret;
}

mb_date
tmtodate  (tim)  /* Pass NULL to get current date */
struct tm *tim;
{
   struct tm  *ptr;
   mb_date     ret;

   ptr = (tim == (struct tm *)0) ? _getlt() : tim;

   SetYear  (ret, ptr->tm_year + 1900L);  /* tm_year stored as 0==1900   */
   SetMonth (ret, ptr->tm_mon + 1L);      /* tm_mon stored as 0==january */
   SetDay   (ret, ptr->tm_mday);          /* tm_mday stored as 1==first  */

   return ret;
}

struct tm *
datetimetotm (dat, tim)
mb_date       dat;
mb_time            tim;
{
   static struct tm ret, *ptr;

   dat = (! dat) ? curdate() : dat;
   tim = (! tim) ? curtime() : tim;
   ptr = _getlt();

   ptr->tm_sec  = GetSeconds (tim);
   ptr->tm_min  = GetMinutes (tim);
   ptr->tm_hour = GetHours   (tim);
   ptr->tm_mday = GetDay   (dat);         /* tm_mday stored as 1==first  */
   ptr->tm_mon  = GetMonth (dat)-1;       /* tm_mon stored as 0==january */
   ptr->tm_year = GetYear  (dat)-1900;    /* tm_year stored as 0==1900   */

   ptr->tm_wday = DayOfWeek (dat);
   ptr->tm_yday = DayJulian (dat);
   ptr->tm_isdst = 0;                     /* Flag for daylight savings   */

   return &ret;
}

char *
fmt_date (dat, opt)
mb_date   dat;
int            opt;
{
   static char buf[20];

   switch (opt)
      {
      case 1:   sprintf ( buf, "%02d/%02d/%02d", GetMonth(dat),
                              GetDay(dat),
                              GetYear(dat) -1900);
               break;

      case 2:   sprintf ( buf, "%02d%02d%02d", GetYear(dat) -1900,
                              GetMonth(dat),
                              GetDay(dat));
               break;

      case 3:   sprintf ( buf, "%02d-%02d-%02d", GetMonth(dat),
                              GetDay(dat),
                              GetYear(dat) -1900);
               break;

      case 4:   sprintf ( buf, "%s %s %d %d", WordDay[DayOfWeek(dat)],
                              WordMonth[GetMonth(dat)-1],
                              GetDay(dat),
                              GetYear(dat) );
               break;

      default:  sprintf (buf, "%02d/%02d/%04d", GetMonth(dat),
                             GetDay(dat), GetYear(dat));
               break;
      }
   return buf;
}

char *
fmt_time (tim, opt)
mb_time   tim;
int            opt;
{
   static char buf[20];
   int         hr;

   hr = GetHours (tim);

   hr = (hr == 0) ? 12 : (hr > 12) ? hr-12 : hr;

   switch (opt)
      {
      case  1:  sprintf (buf, "%d:%02d %s", hr, GetMinutes(tim),
                              (GetHours(tim) >= 12) ? "pm" : "am");
               break;

      case  2:  sprintf (buf, "%02d:%02d", GetHours(tim), GetMinutes(tim));
               break;

      default:  sprintf (buf, "%02d:%02d:%02d", GetHours(tim),
                         GetMinutes(tim), GetSeconds(tim));
               break;
      }
   return buf;
}

mb_date
scn_date (str)
char     *str;
{
   char     buf[80];
   char    *a, *b;
   long     x;
   mb_date  rtn = (mb_date)0;

   if (! str || ! *str)  return rtn;
   strcpy (buf, str);
   if ((a=strpbrk (buf, "/-"))==NULL)
      {
      strzcpy (buf, &str[0], 2);  SetYear  (rtn, atol (buf)+1900L);
      strzcpy (buf, &str[2], 2);  SetMonth (rtn, atol (buf));
      strzcpy (buf, &str[4], 2);  SetDay   (rtn, atol (buf));
      return rtn;
      }
   b=strpbrk(str,"/-")+1;

   *a = 0;  SetMonth (rtn, atol (buf));  strcpy (buf, b);
   if ((b=strpbrk (b, "/-"))==NULL)  return rtn;

   a=strpbrk(buf, "/-"); *a = 0; SetDay (rtn, atol(buf));

   strcpy (buf, b+1);  x=atol(buf);
   if (strlen (buf) < 3)  x += 1900;
   SetYear (rtn, x);

   return rtn;
}

mb_time
scn_time (str)
char     *str;
{
   char     buf[80];
   char    *a, *b;
   long     x;
   mb_time  rtn = (mb_time)0;

   if (! str || ! *str)  return rtn;
   strcpy (buf, str);
   if ((a=strchr (buf, ':'))==NULL)  return rtn;
   b=strchr(str,':')+1;

   *a = 0;  SetHours(rtn, atol (buf));  strcpy (buf, b);
   if ((a=strchr (b, ':'))==NULL)
      {
      x=GetHours (rtn);  rtn=(mb_time)0;  SetMinutes (rtn, atol(buf));
      if ((a=strchr (str, 'p'))==NULL)  a=strchr (str, 'P');
      if (a)
         {
         if ((*(a+1) == 'm' || *(a+1) == 'M') && x < 12)
            x += 12;
         }
      else  /* Check for 12:XX:XX am, and change it to 00:XX:XX */
         {
         if ((a=strchr(str,'a')) != NULL || (a=strchr(str,'a')) != NULL)
            if (x == 12)
               x = 0;
         }
      SetHours (rtn, x);
      return rtn;
      }
   b=strchr(buf,':');  *b = 0;  SetMinutes (rtn, atol (buf));

   strcpy (buf, a+1);  SetSeconds (rtn, atol (buf));
   
   return rtn;
}

int
DaysPerMonth (dat)  /* 28-31, depending on dat's month and day */
mb_date       dat;
{
   switch (GetMonth(dat))
      {
      case  1:  return  31;
      case  2:  return  28 + (DaysPerYear (GetYear(dat)) == 366);
      case  3:  return  31;
      case  4:  return  30;
      case  5:  return  31;
      case  6:  return  30;
      case  7:  return  31;
      case  8:  return  31;
      case  9:  return  30;
      case 10:  return  31;
      case 11:  return  30;
      case 12:  return  31;
      }
   return 0;
}

int
DaysPerYear (year)  /* 365 or 366 */
int          year;
{
   if (year % 4   != 0)  return 365;  /* If it's not every fourth year, 365. */
   if (year % 400 == 0)  return 366;  /* Every 400 years IS a leap year.     */
   if (year % 100 == 0)  return 365;  /* Every 100 years ISN'T a leap year.  */
   return 366;
}

int
DayOfWeek (dat)  /* Returns 0==sunday; only works after the year 1 BC */
mb_date    dat;
{
   int   year;
   int   dow;   /* Day of week: 0=sun,1=mon,2=tue,3=wed,4=thr,5=fri,6=sat */

   dow = 6;      /* January 1st on 0 AD was a saturday */

   for (year = 0; year < GetYear(dat); year++)  /* Years left to skip */
      {
      dow += (DaysPerYear (year) == 365) ? 1 : 2;
      }

   dow += DayJulian (dat) -1;  /* Add nothing for january 1st */
   dow %= 7;                   /* And track it back into 0-6 */

   return dow;
}

int
DayJulian (dat)  /* Returns 1==January 1st */
mb_date    dat;
{
   mb_date tdat;
   int     d, m;

   SetYear  (tdat, GetYear(dat));
   SetDay   (tdat, GetDay(dat));

   d = 0;
   for (m = 1; m < GetMonth(dat); m++)
      {
      SetMonth (tdat, m);
      d += DaysPerMonth(tdat);
      }

   d += GetDay(dat);

   return d;
}


/*
 * PHONE ROUTINES -------------------------------------------------------------
 *
 */

mb_phone *
phncpy   (trg, src)
mb_phone *trg,*src;
{
   trg->area   = src->area;
   trg->prefix = src->prefix;
   trg->number = src->number;
   trg->ext    = src->ext;
   return trg;
}

char *
fmt_phone (ph, opt)    /* opt=1: use () for AC, opt=0: just use -'s */
mb_phone  *ph;
int            opt;
{
   static char buf[25];
   ulong       ac, pre, num, ext;

   buf[0] = 0;

   if (!ph)
      return buf;

   ac  = (ulong)ph->area;
   pre = (ulong)ph->prefix;
   num = (ulong)ph->number;
   ext =        ph->ext;

   if (!num)
      return buf;


   if (ext != 0 && ac == 0)  opt = 2;
   if (ext == 0 && ac == 0)  opt = 5;
   if (ext == 0 && ac != 0)  opt = (opt == 1) ? 3 : 4;

   switch (opt)
      {
      case  1: sprintf (buf, "(%ld) %ld-%04ld x%ld", ac, pre, num, ext); break;
      case  2: sprintf (buf,       "%ld-%04ld x%ld",     pre, num, ext); break;
      case  3: sprintf (buf, "(%ld) %ld-%04ld",      ac, pre, num);      break;
      case  4: sprintf (buf,   "%ld-%ld-%04ld",      ac, pre, num);      break;
      case  5: sprintf (buf,       "%ld-%04ld",          pre, num);      break;
      default: sprintf (buf,   "%ld-%ld-%04ld x%ld", ac, pre, num, ext); break;
      }
   return buf;
}

void
scn_phone (ph, str)
mb_phone  *ph;
char          *str;
{
   char  *a, *b, buf[128];

   ph->area = ph->prefix = ph->number = (ushort)0;
   ph->ext  = 0L;
   strcpy (buf, str);

   if ((a = strchr (buf, '(')) != NULL)
      {
      if ((b = strchr (a, ')')) == NULL)  return;
      *b = 0;  b++;
      ph->area = (ushort)atol (1+a);
      }
   else
      {
      if ((a = strchr (buf, '-')) == NULL)  return;
      if (strchr (1+a, '-') != NULL)
         {
         b = a; *b = 0;  b++;
         ph->area = (ushort)atol(buf);
         }
      else
         {
         b = &buf[0];  /* No area code */
         }
      }

   if ((a = strchr (b, '-')) == NULL)  { ph->area = 0; return; }
   *a = 0; a++;
   ph->prefix = (ushort)atol (b);

   if ((b = strpbrk (a, " xX")) != NULL)
      {
      *b = 0;
      b++;
      }

   ph->number = (ushort)atol (a);

   if (b != NULL)
      {
      if ((a = strpbrk (b, "xX")) != NULL)
         b = 1+a;

      ph->ext = (ulong)atol (b);
      }
}

double
tomoney (n)       /* Rounds to two decimal places of precision */
double   n;
{
   long   x;
   x = (long)((n + 0.005) * 100.0);
   return (x / 100.0);
}

int
PhaseOfMoon (dt)  /* 0-7; 0 = new moon, 4 = full moon */
mb_date      dt;
{
   int  first, second;

   if (! dt)
      {
      dt = curdate();
      }

   first  = (GetYear(dt) % 19) + 1;
   second = (11 * first + 18) % 30;

   if ((second == 25 && first > 11) || second == 24)  second++;

   return ( ((((( DayJulian(dt) +second) * 6) + 11) % 177) / 22) & 7);
}

