/*
 * Note that, as this piece of C code doesn't actually read any
 * records, there's no reason to include <example1.h> to get the
 * C structure for the relation it works with.
 *
 */

#include <mbase.h>

/*
 * PROTOTYPES -----------------------------------------------------------------
 *
 */

   void main XARGS( (void) );


/*
 * CODE -----------------------------------------------------------------------
 *
 */

void
main ()
{
   relation *rel;
   char      key[128];
   long      n;


/*
 * First, try mb_tst() to see if the relation is valid; if not, display
 * whatever error is appropriate and exit.  Note that mb_exit() isn't
 * strictly necessary here, as no relations are open--but it's good
 * practice to use it, and it won't hurt anything.
 *
 */

   if (mb_tst ("example1.rel") != MB_OKAY)
      {
      fprintf (stderr, "mb_tst() failed: %s\n", mb_error);
      mb_exit (1);
      }


/*
 * Now that we know the relation is valid, get an encryption key and
 * open it.  The only reason mb_inc() should fail here is MB_ENCRYPT.
 *
 */

   printf ("encryption key : ");
   gets (key);

   if ((rel = mb_inc ("example1.rel", key)) == RNULL)
      {
      fprintf (stderr, "mb_inc() failed: %s\n", mb_error);
      mb_exit (1);
      }


/*
 * Great; now that we've opened it, print out how many records are
 * left, and how many of those haven't been indexed yet.
 *
 */

   n = mb_num (rel);
   printf ("This relation has %ld %s.\n", n, (n==1) ? "record" : "records");

   n = mb_num_q (rel);
   printf ("Of those, %ld %s not been indexed.\n", n, (n==1) ? "has" : "have");


/*
 * Now close the relation and leave.  Again, mb_rmv() isn't strictly necessary
 * here, as mb_exit() will close all open relations...
 *
 */

   mb_rmv (rel);

   mb_exit (0);
}

