/*
 * if.c: handles the IF command for IRCII 
 *
 * Written By Michael Sandrof
 *
 * Copyright(c) 1990, 1991 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 */
#include <ctype.h>
#include "irc.h"
#include "alias.h"
#include "ircaux.h"
#include "window.h"
#include "vars.h"
#include "output.h"
extern char *arg_numword();
extern int   word_count();
extern char *stristr();
extern char *rstristr();

int     lastif;

/*
 * next_expr finds the next expression delimited by brackets. The type
 * of bracket expected is passed as a parameter. Returns NULL on error.
 */
extern  char	*next_expr(args, type)
char	**args;
char	type;
{
	char	*ptr,
		*ptr2,
		*ptr3;

	if (!*args)
		return NULL;
	ptr2 = *args;
	if (!*ptr2)
		return NULL;
	if (*ptr2 != type)
	{
		return NULL;
	}
	ptr = MatchingBracket(ptr2 + 1, type, (type == '(') ? ')' : '}');
	if (!ptr)
	{
		say("Unmatched '%c'", type);
		return NULL;
	}
	*ptr = '\0';
	do
		ptr2++;
	while (isspace(*ptr2));
	ptr3 = ptr+1;
	while (isspace(*ptr3))
		ptr3++;
	*args = ptr3;
	if (*ptr2)
	{
		ptr--;
		while (isspace(*ptr))
			*ptr-- = '\0';
	}
	return ptr2;
}

/*ARGSUSED*/
void	ifcmd(command, args, subargs)
char	*command,
	*args;
char	*subargs;
{
	char	*exp;
	char	*sub;
        char    *found;
	int	flag = 0;
	int	result;

	exp = next_expr(&args, '(');
        if (found = stristr(args,"THEN"))
	{
		if (!exp)
			exp = args;
		*found = '\0';
		args = found + 4;
		while (isspace(*args)) *args++ = '\0';
	}
	{
		if (!exp)
		{
			yell("Missing CONDITION in IF");
			return;
		}
	};
	sub = parse_inline(exp, subargs?subargs:empty_string, &flag);
	if (get_int_var(DEBUG_VAR) & DEBUG_EXPANSIONS)
		yell("If expression expands to: (%s)", sub);
	if (!sub || !*sub || *sub == '0')
		result = 0;
	else
		result = 1;
	new_free(&sub);

	/* backwards compatability is a bitch */
	exp = next_expr(&args, '{');
        if (found = rstristr(args, "ELSE"))
        {
                *found = '\0';
		if (!exp)
                	exp = args;
                args = found + 4;
                while (isspace(*args)) *args++ = '\0';
        }
        {
                if (!exp)
                {
                        yell("MISSING COMMANDS");
                        return;
                }
        }

	if (!result)
        {
                if (!args || !*args)
                        return;
		exp = args;
        }

	parse_line((char *) 0, exp, subargs ? subargs : empty_string, 0, 0);
	return;
}

/*ARGSUSED*/
void	whilecmd(command, args, subargs)
char	*command,
	*args;
char	*subargs;
{
	char	*exp = null(char *),
		*ptr,
		*body = null(char *),
		*newexp = null(char *);
	int	args_used;	/* this isn't used here, but is passed
				 * to expand_alias() */

	if ((ptr = next_expr(&args, '(')) == null(char *))
	{
		yell("WHILE: missing boolean expression");
		return;
	}
	malloc_strcpy(&exp, ptr);
	malloc_strcpy(&body, args);
	while (1)
	{
                malloc_strcpy(&newexp, exp); 
        /* I think its lame that parse_inline destroys the newexp */
		ptr = parse_inline(newexp, subargs ? subargs : empty_string,
			&args_used);
		if (*ptr && *ptr !='0')
		{
			new_free(&ptr);
			parse_line(null(char *), body, subargs ?
				subargs : empty_string, 0, 0);
		}
		else
			break;
	}
	new_free(&ptr);
	new_free(&exp);
	new_free(&body);
}

void fe();
void foreach();
void forcmd();

int     charcount(string,what)
char    *string,
        what;
{
        int     x       = 0;
        char    *place  = string-1;

        while (place = index(place+1,what)) x++;
        return x;
}

/* How it works -- if There are no parenthesis, it must be a
   foreach array command.  If there are parenthesis, and there are
   exactly two commas, it must be a C-like for command, else it must
   must be an foreach word command */
void    foreach_handler(command,args,subargs)
char    *command,
        *args,
        *subargs;
{
        char    *temp = null(char *);
        char    *placeholder;
        char    *temp2 = (char *) 0;
        int     ick=0;

        malloc_strcpy(&temp, args);
        placeholder = temp;
        if (*temp == '(')
        {
                if ((temp2 = next_expr(&temp,'(')) == (char *) 0) {
                        new_free(&placeholder);
                        return;
                }
                if (charcount(temp2,',') == 2)
                        forcmd(command,args,subargs);
                else
                        fe(command,args,subargs);
        }
        else
                foreach(command,args,subargs);
        new_free(&placeholder);
}

/*ARGSUSED*/
void	foreach(command, args, subargs)
char	*command,
	*args;
char	*subargs;
{
	char	*struc = null(char *),
		*ptr,
		*body = null(char *),
		*var = null(char *);
	char	**sublist;
	int	total;
	int	i;
	int	slen;
	int	old_display;

	if ((ptr = new_next_arg(args, &args)) == null(char *))
	{
		yell("FOREACH: missing structure expression");
		return;
	}
	malloc_strcpy(&struc, ptr);
	malloc_strcat(&struc, ".");
	upper(struc);
	if ((var = next_arg(args, &args)) == null(char *))
	{
		new_free(&struc);
		yell("FOREACH: missing variable");
		return;
	}
        while (isspace(*args))
                *args++;
	if ((body = next_expr(&args, '{')) == null(char *))
	{
		new_free(&struc);
		yell("FOREACH: missing statement");
		return;
	}
	sublist=match_alias(struc, &total, VAR_ALIAS);
    	slen=strlen(struc);
	old_display=window_display;
	for (i=0;i<total;i++)
	{
		window_display=0;
		add_alias(VAR_ALIAS, var, sublist[i]+slen);
		window_display=old_display;
		parse_line(null(char *), body, subargs ?
			subargs : empty_string, 0, 0);
		new_free(&sublist[i]);
	}
	new_free(&sublist);
	new_free(&struc);
}

/*
 * FE:  Written by Jeremy Nelson (jnelson@iastate.edu)
 *
 * FE: replaces recursion
 *
 * The thing about it is that you can nest variables, as this command calls
 * expand_alias until the list doesnt change.  So you can nest lists in
 * lists, and hopefully that will work.  However, it also makes it 
 * impossible to have $s anywhere in the list.  Maybe ill change that
 * some day.
 */

void    fe (command, args, subargs)
char    *command,
        *args,
        *subargs;
{
        char    *list = null(char *),
                *templist = null(char *),
                *placeholder,
                *oldlist = null(char *),
                *sa,
                *vars,
                *var[255],
                *word = null(char *),
                *todo = null(char *);
        int     ind, x, y, blah,args_flag;
        int     old_display;

        for (x=0;x<=255;var[x++]=(char *) 0);

        list = next_expr(&args, '(');
        if (!list) 
	{
                yell ("FE: Missing List for /FE");
                return;
        }

        sa = subargs ? subargs : " ";
        malloc_strcpy(&templist, list);
        do 
	{
                malloc_strcpy(&oldlist, templist);
                new_free(&templist);
                templist = expand_alias(null(char *),oldlist,sa,&args_flag, null(char **));
        } while (strcmp(templist, oldlist));

        new_free(&oldlist);

        if (*templist == '\0')
	{
                new_free(&templist);
                return;
        }

        vars = args;
        if (!(args = index(args, '{')))
	{
                yell ("FE: Missing commands");
                new_free(&templist);
                return;
        }
        *(args-1) = '\0';
        ind = 0;
        while (var[ind++] = next_arg(vars, &vars))
	{
                if (ind == 255) 
		{
                        yell ("FE: Too many variables");
                        new_free(&templist);
                        return;
                }
        }
        ind = ind ? ind - 1: 0;

        if (!(todo = next_expr(&args, '{'))) 
	{
                yell ("FE: Missing }");
                new_free(&templist);
                return;
        }

        blah = word_count(templist);
        old_display = window_display;
        placeholder = templist;
        for ( x = 0 ; x < blah ; )
        {
                window_display = 0;
                for ( y = 0 ; y < ind ; y++ ) 
		{
                        word = ((x+y)<blah)
                               ? next_arg(templist, &templist)
                               : null(char *);
                        add_alias(VAR_ALIAS, var[y], word);
                }
                window_display = old_display;
                x += ind;
                parse_line(null(char *), todo, 
                           subargs?subargs:empty_string, 0, 0);
        }
        window_display = 0;
        for (y=0;y<ind;y++)  {
                delete_alias(VAR_ALIAS,var[y]);
        }
        window_display = old_display;
        new_free(&placeholder);
}

/* FOR command..... prototype: 
 *  for (commence,evaluation,iteration)
 * in the same style of C's for, the for loop is just a specific
 * type of WHILE loop.
 *
 * IMPORTANT: Since ircII uses ; as a delimeter between commands,
 * commas were chosen to be the delimiter between expressions,
 * so that semicolons may be used in the expressions (think of this
 * as the reverse as C, where commas seperate commands in expressions,
 * and semicolons end expressions.
 */
/*  I suppose someone could make a case that since the
 *  foreach_handler() routine weeds out any for command that doesnt have
 *  two commans, that checking for those 2 commas is a waste.  I suppose.
 */
void forcmd (command, args, subargs)
char    *command;
char    *args;
char    *subargs;
{
    char        *working        = null(char *);
    char        *commence       = null(char *);
    char        *evaluation     = null(char *);
    char        *lameeval       = null(char *);
    char        *iteration      = null(char *);
    char        *sa             = null(char *);
    int         argsused        = 0;
    char        *blah           = null(char *);
    char        *commands       = null(char *);

    /* Get the whole () thing */
    if ((working = next_expr(&args, '(')) == null(char *)) 
    {
        yell("FOR: missing closing parenthesis");
        return;
    }
    malloc_strcpy(&commence, working);

    /* Find the beginning of the second expression */
    evaluation = index(commence, ',');
    if (!evaluation) 
    {
        yell("FOR: no components!");
        new_free(&commence);
        return;
    }
    do *evaluation++ = '\0';
    while (isspace(*evaluation));

    /* Find the beginning of the third expression */
    iteration = index(evaluation, ',');
    if (!iteration) 
    {
        yell("FOR: Only two components!");
        new_free(&commence);
        return;
    }
    do *iteration++ = '\0';
    while (isspace(*iteration));

    working = args;
    while (isspace(*working))
        *working++ = '\0';

    if ((working = next_expr(&working, '{')) == null(char *)) 
    {
        yell("FOR: badly formed commands");
        new_free(&commence);
        return;
    }

    malloc_strcpy(&commands, working);
    
    sa = subargs?subargs:empty_string;
    parse_line((char *) 0, commence, sa, 0, 0);

    while (1)
    {
                malloc_strcpy(&lameeval, evaluation);
                blah = parse_inline(lameeval,sa,&argsused);
                if (*blah && *blah != '0') 
                {
                        new_free(&blah);
                        parse_line(null(char *), commands, sa, 0, 0);
                        parse_line(null(char *), iteration, sa, 0, 0);
                }
                else break;
    }
    new_free(&blah);
    new_free(&lameeval);
    new_free(&commence);
    new_free(&commands);
}

/* fec - iterate over a list of characters */

extern  void    fec (command, args, subargs)
char    *command,
        *args,
        *subargs;
{
        char    *pointer;
        char    *list = null(char *);
        char    *var = null(char *);
        char    booya[2];
        int     args_flag = 0, old_display;
        char    *sa,*todo;
        
        list = next_expr(&args, '(');
        if (list == null(char *)) 
	{
                yell ("FEC: Missing List for /FEC");
                return;
        }

        sa = subargs ? subargs : empty_string;
        list = expand_alias(null(char *),list,sa,&args_flag,null(char **));
        pointer = list;

        var = next_arg(args, &args);
        args = index(args, '{');

        if ((todo = next_expr(&args, '{')) == (char *)NULL) 
	{
                yell ("FE: Missing }");
                return;
        }

        booya[1] = '\0';
        old_display = window_display;

        while (*pointer)
        {
                window_display = 0;
                booya[0] = *pointer++;
                add_alias(VAR_ALIAS, var, booya);
                window_display = old_display;
                parse_line((char *) 0, todo, 
                           subargs?subargs:empty_string, 0, 0);
        }
        window_display = 0;
        delete_alias(VAR_ALIAS,var);
        window_display = old_display;

        new_free(&list);
}
