;;; $Id: emacspeak-enriched.el,v 6.0 1997/05/01 18:06:27 raman Exp $
;;; $Author: raman $ 
;;; Description: Emacspeak module to speak voicify rich text
;;; Keywords:emacspeak, audio interface to emacs rich text
;;{{{  LCD Archive entry: 

;;; LCD Archive Entry:
;;; emacspeak| T. V. Raman |raman@adobe.com
;;; A speech interface to Emacs |
;;; $date: $ |
;;;  $Revision: 6.0 $ | 
;;; Location undetermined
;;;

;;}}}
;;{{{  Copyright:

;;; Copyright (c) 1995 by T. V. Raman Adobe Systems Incorporated 
;;; All Rights Reserved. 
;;;
;;; This file is not part of GNU Emacs, but the same permissions apply.
;;;
;;; GNU Emacs is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; GNU Emacs is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Emacs; see the file COPYING.  If not, write to
;;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;}}}

(require 'cl)
(declaim  (optimize  (safety 0) (speed 3)))
(require 'dtk-css-speech)
(require 'emacspeak-sounds)
(require 'emacspeak-speak)
;;{{{  Introduction

;;; emacspeak extensions to voicify rich  text.

;;}}}
;;{{{ voicify-faces 

(defun emacspeak-enriched-voiceify-faces (start end)
  "Map base fonts to voices.
Useful in voicifying rich text."
  (interactive "r")
  (ems-modify-buffer-safely
  (save-excursion
    (goto-char start)
    (let ((face nil ))
      (set (make-local-variable 'voice-lock-mode) t)
      (while (and  (not (eobp))
                        (< start end))
        (setq face (get-text-property (point) 'face ))
        (goto-char
         (or
          (next-single-property-change (point) 'face
                                       (current-buffer) end)
             end))
        (when face 
        (put-text-property start  (point)
                           'personality
                           (if (listp face) (car face) face )))
        (setq start (point)))))))

;;}}}
;;{{{  Associate faces to standard voices:

(dtk-define-voice-alias 'bold 'paul-smooth)
(dtk-define-voice-alias 'underline 'ursula)
(dtk-define-voice-alias 'fixed 'paul-monotone)
(dtk-define-voice-alias 'italic 'paul-animated)
(dtk-define-voice-alias 'excerpt 'annotation-voice )

;;}}}
;;{{{ advice enriched to automatically map faces to voices

(defadvice enriched-decode (after emacspeak pre act comp)
  "Map faces to voices. "
  (let ((start (ad-get-arg 0))
        (end (ad-get-arg 1)))
    (emacspeak-enriched-voiceify-faces start end )
    ad-return-value))

;;}}}
(provide  'emacspeak-enriched)
;;{{{  emacs local variables 

;;; local variables:
;;; folded-file: t
;;; end: 

;;}}}
