#include	<sysdep.h>
#include	<sysdeps.h>

/*
 * Copyright (c) 1993 Eric Youngdale, Peter MacDonald, David Engel
 * and Hongjiu Lu.
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Eric Youngdale,
 *      Peter MacDonald, David Engel and Hongjiu Lu.
 * 3. The name of the above contributors may not be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* Notice of general intent:
 *
 * The linux operating system generally contains large amounts of code
 * that fall under the GNU General Public License, or GPL for short.
 * This file contains source code that by it's very nature would always
 * be linked with an application program, and because of this a GPL type
 * of copyright on this file would place restrictions upon the
 * distribution of binary-only commercial software.  Since the goal of the
 * Linux project as a whole is not to discourage the development and
 * distribution of commercial software for Linux, this file has been placed
 * under a more relaxed BSD-style of copyright.
 *
 * It is the general understanding of the above contributors that a
 * program executable linked to a library containing code that falls
 * under the GPL or GLPL style of license is not subject to the terms of
 * the GPL or GLPL license if the program executable(s) that are supplied
 * are linked to a shared library form of the GPL or GLPL library, and as long
 * as the form of the shared library is such that it is possible for
 * the end user to modify and rebuild the library and use it in
 * conjunction with the program executable.
 */

	.file	"crt0.S"
	.text
	.globl	_start
/*
 *	Set up the 387 flags
 */	
_start:
	fldcw	_init_cw		/* Prime the 80486 FPU		*/
/*
 *	Compute the address of the envp and argv addresses. iBCS stores
 *	the initial stack frame as:
 *
 *	esp  ->   argument count
 *	+4        argument strings
 *   		  ...
 *		  0
 *		  environment strings
 *		  ...
 *	   	  0
 */
	popl	%eax			/* Fetch argument count		*/
	movl	%esp,%edx		/* Point to argument strings	*/
	leal	4(%edx,%eax,4),%ecx	/* Point to environment		*/
	movl	%ecx,___libc_environ	/* Store the envp address	*/
/*
 * 	Envoke the main procedure and should it return, call "exit" for
 *	it.
 */
	pushl	%ecx			/* Store the envp address	*/
	pushl	%edx			/* Store the argv address	*/
	pushl	%eax			/* Store the argc count		*/
	call	_main			/* Envoke the main program	*/

	addl	$12,%esp		/* Flush the stack frame	*/
	pushl	%eax			/* Store the return value	*/
	call	_exit			/* Terminate the program	*/
/*
 *	This should never happen. _exit() should never return. However,
 *	for the remote possibility of it happening.
 */
	movl	$__IBCS_exit,%eax	/* Load the exit code		*/
	lcall	$7,$0			/* Issue the supervisor call	*/
/*
 *      The emulator was not defined. Give the Linux user a graceful way
 *      out of the picture.
 */
	popl	%ebx			/* Fetch the result code	*/
done:
	movl	$1,%eax			/* Load the termination call	*/
	int	$0x80			/* Issue the supervisor call	*/
	jmp	done			/* Still?? well, try again ....	*/

/* Here is the dirty part. Settup up your 387 through the control word
 * (cw) register. 
 *
 *     15-13    12  11-10  9-8     7-6     5    4    3    2    1    0
 * | reserved | IC | RC  | PC | reserved | PM | UM | OM | ZM | DM | IM
 *
 * IM: Invalid operation mask
 * DM: Denormalized operand mask
 * ZM: Zero-divide mask
 * OM: Overflow mask
 * UM: Underflow mask
 * PM: Precision (inexact result) mask
 * 
 * Mask bit is 1 means no interrupt.
 *
 * PC: Precision control
 * 11 - round to extended precision
 * 10 - round to double precision
 * 00 - round to single precision
 *
 * RC: Rounding control
 * 00 - rounding to nearest
 * 01 - rounding down (toward - infinity)
 * 10 - rounding up (toward + infinity)
 * 11 - rounding toward zero
 *
 * IC: Infinity control
 * That is for 8087 and 80287 only.
 *
 * The hardware default is 0x037f. I choose 0x1372.
 */

	.align  4       /* It doesn't really matter if a word is wasted */
			/* for the 386. Do the long word alignment.	*/
	.globl	_init_cw
_init_cw:
	.word	0x1372
	.word	0
/*
 *	This is a dummy routine for the Linux compiler
 */
	.globl	___main
___main:
	ret
