# <a name="title"></a> KD Soap [![Logo](https://github.com/KDAB/KDSoap/blob/master/images/kdsoap-medium.png)](https://www.kdab.com/development-resources/qt-tools/kd-soap)
Introduction
============
KD Soap is a Qt-based client-side and server-side SOAP component.

It can be used to create client applications for web services and also provides
the means to create web services without the need for any further component such
as a dedicated web server.

KD Soap targets C++ programmers who use Qt in their applications.

For more information, see https://www.kdab.com/development-resources/qt-tools/kd-soap

Using KD Soap
=============
KD Soap requires Qt 5.7.0 or newer, and a compiler with C++11 support.
Qt6 support is added starting with KD Soap version 2.0.

See [INSTALL.txt](INSTALL.txt) for installation instructions using CMake.

After reading the introductory overview files in doc/
you will find more information at these places:

 * [detailed browsable API reference](https://docs.kdab.com/kdsoap)
 * [programmers manual with examples](doc/manual/kdsoap.pdf)
 * [our sorted example programs](examples/)

Contact
=======
* See our official home page: https://www.kdab.com/development-resources/qt-tools/kd-soap
* Visit us on GitHub: https://github.com/KDAB/KDSoap
* Email info@kdab.com for questions about copyright, licensing or commercial support.

Stay up-to-date with KDAB product announcements:

* [KDAB Newsletter](https://news.kdab.com)
* [KDAB Blogs](https://www.kdab.com/category/blogs)
* [KDAB on Twitter](https://twitter.com/KDABQt)

Get Involved
============
KDAB will happily accept external contributions, but substantial contributions require
a signed [Copyright Assignment Agreement](doc/KDSoap-CopyrightAssignmentForm.pdf).

Contact info@kdab.com for more information about the Copyright Assignment Agreement.

Please submit your contributions or issue reports from our GitHub space at
https://github.com/KDAB/KDSoap

Thanks to our [contributors](CONTRIBUTORS.txt).

License
=======
The KD Soap Software is Copyright (C) 2010-2021, Klaralvdalens Datakonsult AB,
and is available under the terms of:

* [LGPL-2.1](LICENSES/LGPL-2.1-only.txt) or [LGPL-3.0](LICENSES/LGPL-3.0-only.txt)
    (except libkdsoap-server, see [LicenseRef-KDAB-KDSoap-AGPL3-Modified.txt](LICENSES/LicenseRef-KDAB-KDSoap-AGPL3-Modified.txt))
* [GPL-2.0](LICENSES/GPL-2.0-only.txt) or [GPL-3.0](LICENSES/GPL-3.0-only.txt)
    (except libkdsoap-server, see [LicenseRef-KDAB-KDSoap-AGPL3-Modified.txt](LICENSES/LicenseRef-KDAB-KDSoap-AGPL3-Modified.txt))
* the KDAB commercial license, provided that you buy a license.
  please contact info@kdab.com if you are interested in buying commercial licenses.

Commercial licensing terms are available in
[LicenseRef-KDAB-KDSoap.txt](LICENSES/LicenseRef-KDAB-KDSoap.txt),
[LicenseRef-KDAB-KDSoap-US.txt](LICENSES/LicenseRef-KDAB-KDSoap-US.txt).

See [README-commercial.txt](README-commercial.txt) for more details.

About KDAB
==========
KD Soap is supported and maintained by Klarälvdalens Datakonsult AB (KDAB).

The KDAB Group is the global No.1 software consultancy for Qt, C++ and
OpenGL applications across desktop, embedded and mobile platforms.

The KDAB Group provides consulting and mentoring for developing Qt applications
from scratch and in porting from all popular and legacy frameworks to Qt.
We continue to help develop parts of Qt and are one of the major contributors
to the Qt Project. We can give advanced or standard trainings anywhere
around the globe on Qt as well as C++, OpenGL, 3D and more.

Please visit https://www.kdab.com to meet the people who write code like this.

KD SOAP and the KD SOAP logo are registered trademarks of Klaralvdalens Datakonsult AB
in the European Union, the United States, and/or other countries.  Other product and
company names and logos may be trademarks or registered trademarks of their respective companies.
