; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mcpu=pwr9 -mtriple=powerpc64-ibm-aix-xcoff \
; RUN:   -verify-machineinstrs < %s | FileCheck -check-prefixes=CHECK-64,CHECK-64-OPT %s
; RUN: llc -O0 -mcpu=pwr9 -mtriple=powerpc64-ibm-aix-xcoff \
; RUN:   -verify-machineinstrs < %s | FileCheck -check-prefixes=CHECK-64,CHECK-64-O0 %s
; RUN: llc -mcpu=pwr9 -mtriple=powerpc-ibm-aix-xcoff \
; RUN:   -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK-32,CHECK-32-OPT
; RUN: llc -O0 -mcpu=pwr9 -mtriple=powerpc-ibm-aix-xcoff \
; RUN:   -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK-32,CHECK-32-O0

; The following testcases take one halfword element from the second vector and
; inserts it at various locations in the first vector
define <8 x i16> @shuffle_vector_halfword_0_8(<8 x i16> %a, <8 x i16> %b) {
; CHECK-64-LABEL: shuffle_vector_halfword_0_8:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vsldoi 3, 3, 3, 10
; CHECK-64-NEXT:    vinserth 2, 3, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_halfword_0_8:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vsldoi 3, 3, 3, 10
; CHECK-32-NEXT:    vinserth 2, 3, 0
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <8 x i16> %a, <8 x i16> %b, <8 x i32> <i32 8, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i16> %vecins
}

define <8 x i16> @shuffle_vector_halfword_1_15(<8 x i16> %a, <8 x i16> %b) {
; CHECK-64-LABEL: shuffle_vector_halfword_1_15:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vsldoi 3, 3, 3, 8
; CHECK-64-NEXT:    vinserth 2, 3, 2
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_halfword_1_15:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vsldoi 3, 3, 3, 8
; CHECK-32-NEXT:    vinserth 2, 3, 2
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <8 x i16> %a, <8 x i16> %b, <8 x i32> <i32 0, i32 15, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i16> %vecins
}

define <8 x i16> @shuffle_vector_halfword_2_9(<8 x i16> %a, <8 x i16> %b) {
; CHECK-64-LABEL: shuffle_vector_halfword_2_9:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vsldoi 3, 3, 3, 12
; CHECK-64-NEXT:    vinserth 2, 3, 4
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_halfword_2_9:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vsldoi 3, 3, 3, 12
; CHECK-32-NEXT:    vinserth 2, 3, 4
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <8 x i16> %a, <8 x i16> %b, <8 x i32> <i32 0, i32 1, i32 9, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i16> %vecins
}

define <8 x i16> @shuffle_vector_halfword_3_13(<8 x i16> %a, <8 x i16> %b) {
; CHECK-64-LABEL: shuffle_vector_halfword_3_13:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vsldoi 3, 3, 3, 4
; CHECK-64-NEXT:    vinserth 2, 3, 6
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_halfword_3_13:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vsldoi 3, 3, 3, 4
; CHECK-32-NEXT:    vinserth 2, 3, 6
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <8 x i16> %a, <8 x i16> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 13, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i16> %vecins
}

define <8 x i16> @shuffle_vector_halfword_4_10(<8 x i16> %a, <8 x i16> %b) {
; CHECK-64-LABEL: shuffle_vector_halfword_4_10:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vsldoi 3, 3, 3, 14
; CHECK-64-NEXT:    vinserth 2, 3, 8
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_halfword_4_10:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vsldoi 3, 3, 3, 14
; CHECK-32-NEXT:    vinserth 2, 3, 8
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <8 x i16> %a, <8 x i16> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 10, i32 5, i32 6, i32 7>
  ret <8 x i16> %vecins
}

define <8 x i16> @shuffle_vector_halfword_5_14(<8 x i16> %a, <8 x i16> %b) {
; CHECK-64-LABEL: shuffle_vector_halfword_5_14:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vsldoi 3, 3, 3, 6
; CHECK-64-NEXT:    vinserth 2, 3, 10
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_halfword_5_14:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vsldoi 3, 3, 3, 6
; CHECK-32-NEXT:    vinserth 2, 3, 10
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <8 x i16> %a, <8 x i16> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 14, i32 6, i32 7>
  ret <8 x i16> %vecins
}

define <8 x i16> @shuffle_vector_halfword_6_11(<8 x i16> %a, <8 x i16> %b) {
; CHECK-64-LABEL: shuffle_vector_halfword_6_11:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vinserth 2, 3, 12
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_halfword_6_11:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vinserth 2, 3, 12
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <8 x i16> %a, <8 x i16> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 11, i32 7>
  ret <8 x i16> %vecins
}

define <8 x i16> @shuffle_vector_halfword_7_12(<8 x i16> %a, <8 x i16> %b) {
; CHECK-64-LABEL: shuffle_vector_halfword_7_12:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vsldoi 3, 3, 3, 2
; CHECK-64-NEXT:    vinserth 2, 3, 14
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_halfword_7_12:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vsldoi 3, 3, 3, 2
; CHECK-32-NEXT:    vinserth 2, 3, 14
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <8 x i16> %a, <8 x i16> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 12>
  ret <8 x i16> %vecins
}

define <8 x i16> @shuffle_vector_halfword_8_1(<8 x i16> %a, <8 x i16> %b) {
; CHECK-64-OPT-LABEL: shuffle_vector_halfword_8_1:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    vsldoi 2, 2, 2, 12
; CHECK-64-OPT-NEXT:    vinserth 3, 2, 0
; CHECK-64-OPT-NEXT:    vmr 2, 3
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: shuffle_vector_halfword_8_1:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-64-O0-NEXT:    vmr 3, 2
; CHECK-64-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-64-O0-NEXT:    vsldoi 3, 3, 3, 12
; CHECK-64-O0-NEXT:    vinserth 2, 3, 0
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: shuffle_vector_halfword_8_1:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    vsldoi 2, 2, 2, 12
; CHECK-32-OPT-NEXT:    vinserth 3, 2, 0
; CHECK-32-OPT-NEXT:    vmr 2, 3
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: shuffle_vector_halfword_8_1:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-32-O0-NEXT:    vmr 3, 2
; CHECK-32-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-32-O0-NEXT:    vsldoi 3, 3, 3, 12
; CHECK-32-O0-NEXT:    vinserth 2, 3, 0
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = shufflevector <8 x i16> %a, <8 x i16> %b, <8 x i32> <i32 1, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <8 x i16> %vecins
}

; The following testcases take one halfword element from the first vector and
; inserts it at various locations in the second vector
define <8 x i16> @shuffle_vector_halfword_9_7(<8 x i16> %a, <8 x i16> %b) {
; CHECK-64-OPT-LABEL: shuffle_vector_halfword_9_7:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    vsldoi 2, 2, 2, 8
; CHECK-64-OPT-NEXT:    vinserth 3, 2, 2
; CHECK-64-OPT-NEXT:    vmr 2, 3
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: shuffle_vector_halfword_9_7:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-64-O0-NEXT:    vmr 3, 2
; CHECK-64-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-64-O0-NEXT:    vsldoi 3, 3, 3, 8
; CHECK-64-O0-NEXT:    vinserth 2, 3, 2
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: shuffle_vector_halfword_9_7:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    vsldoi 2, 2, 2, 8
; CHECK-32-OPT-NEXT:    vinserth 3, 2, 2
; CHECK-32-OPT-NEXT:    vmr 2, 3
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: shuffle_vector_halfword_9_7:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-32-O0-NEXT:    vmr 3, 2
; CHECK-32-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-32-O0-NEXT:    vsldoi 3, 3, 3, 8
; CHECK-32-O0-NEXT:    vinserth 2, 3, 2
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = shufflevector <8 x i16> %a, <8 x i16> %b, <8 x i32> <i32 8, i32 7, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <8 x i16> %vecins
}

define <8 x i16> @shuffle_vector_halfword_10_4(<8 x i16> %a, <8 x i16> %b) {
; CHECK-64-OPT-LABEL: shuffle_vector_halfword_10_4:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    vsldoi 2, 2, 2, 2
; CHECK-64-OPT-NEXT:    vinserth 3, 2, 4
; CHECK-64-OPT-NEXT:    vmr 2, 3
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: shuffle_vector_halfword_10_4:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-64-O0-NEXT:    vmr 3, 2
; CHECK-64-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-64-O0-NEXT:    vsldoi 3, 3, 3, 2
; CHECK-64-O0-NEXT:    vinserth 2, 3, 4
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: shuffle_vector_halfword_10_4:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    vsldoi 2, 2, 2, 2
; CHECK-32-OPT-NEXT:    vinserth 3, 2, 4
; CHECK-32-OPT-NEXT:    vmr 2, 3
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: shuffle_vector_halfword_10_4:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-32-O0-NEXT:    vmr 3, 2
; CHECK-32-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-32-O0-NEXT:    vsldoi 3, 3, 3, 2
; CHECK-32-O0-NEXT:    vinserth 2, 3, 4
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = shufflevector <8 x i16> %a, <8 x i16> %b, <8 x i32> <i32 8, i32 9, i32 4, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <8 x i16> %vecins
}

define <8 x i16> @shuffle_vector_halfword_11_2(<8 x i16> %a, <8 x i16> %b) {
; CHECK-64-OPT-LABEL: shuffle_vector_halfword_11_2:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    vsldoi 2, 2, 2, 14
; CHECK-64-OPT-NEXT:    vinserth 3, 2, 6
; CHECK-64-OPT-NEXT:    vmr 2, 3
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: shuffle_vector_halfword_11_2:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-64-O0-NEXT:    vmr 3, 2
; CHECK-64-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-64-O0-NEXT:    vsldoi 3, 3, 3, 14
; CHECK-64-O0-NEXT:    vinserth 2, 3, 6
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: shuffle_vector_halfword_11_2:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    vsldoi 2, 2, 2, 14
; CHECK-32-OPT-NEXT:    vinserth 3, 2, 6
; CHECK-32-OPT-NEXT:    vmr 2, 3
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: shuffle_vector_halfword_11_2:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-32-O0-NEXT:    vmr 3, 2
; CHECK-32-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-32-O0-NEXT:    vsldoi 3, 3, 3, 14
; CHECK-32-O0-NEXT:    vinserth 2, 3, 6
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = shufflevector <8 x i16> %a, <8 x i16> %b, <8 x i32> <i32 8, i32 9, i32 10, i32 2, i32 12, i32 13, i32 14, i32 15>
  ret <8 x i16> %vecins
}

define <8 x i16> @shuffle_vector_halfword_12_6(<8 x i16> %a, <8 x i16> %b) {
; CHECK-64-OPT-LABEL: shuffle_vector_halfword_12_6:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    vsldoi 2, 2, 2, 6
; CHECK-64-OPT-NEXT:    vinserth 3, 2, 8
; CHECK-64-OPT-NEXT:    vmr 2, 3
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: shuffle_vector_halfword_12_6:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-64-O0-NEXT:    vmr 3, 2
; CHECK-64-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-64-O0-NEXT:    vsldoi 3, 3, 3, 6
; CHECK-64-O0-NEXT:    vinserth 2, 3, 8
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: shuffle_vector_halfword_12_6:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    vsldoi 2, 2, 2, 6
; CHECK-32-OPT-NEXT:    vinserth 3, 2, 8
; CHECK-32-OPT-NEXT:    vmr 2, 3
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: shuffle_vector_halfword_12_6:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-32-O0-NEXT:    vmr 3, 2
; CHECK-32-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-32-O0-NEXT:    vsldoi 3, 3, 3, 6
; CHECK-32-O0-NEXT:    vinserth 2, 3, 8
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = shufflevector <8 x i16> %a, <8 x i16> %b, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 6, i32 13, i32 14, i32 15>
  ret <8 x i16> %vecins
}

define <8 x i16> @shuffle_vector_halfword_13_3(<8 x i16> %a, <8 x i16> %b) {
; CHECK-64-OPT-LABEL: shuffle_vector_halfword_13_3:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    vinserth 3, 2, 10
; CHECK-64-OPT-NEXT:    vmr 2, 3
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: shuffle_vector_halfword_13_3:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-64-O0-NEXT:    vmr 3, 2
; CHECK-64-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-64-O0-NEXT:    vinserth 2, 3, 10
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: shuffle_vector_halfword_13_3:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    vinserth 3, 2, 10
; CHECK-32-OPT-NEXT:    vmr 2, 3
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: shuffle_vector_halfword_13_3:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-32-O0-NEXT:    vmr 3, 2
; CHECK-32-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-32-O0-NEXT:    vinserth 2, 3, 10
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = shufflevector <8 x i16> %a, <8 x i16> %b, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 3, i32 14, i32 15>
  ret <8 x i16> %vecins
}

define <8 x i16> @shuffle_vector_halfword_14_5(<8 x i16> %a, <8 x i16> %b) {
; CHECK-64-OPT-LABEL: shuffle_vector_halfword_14_5:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    vsldoi 2, 2, 2, 4
; CHECK-64-OPT-NEXT:    vinserth 3, 2, 12
; CHECK-64-OPT-NEXT:    vmr 2, 3
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: shuffle_vector_halfword_14_5:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-64-O0-NEXT:    vmr 3, 2
; CHECK-64-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-64-O0-NEXT:    vsldoi 3, 3, 3, 4
; CHECK-64-O0-NEXT:    vinserth 2, 3, 12
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: shuffle_vector_halfword_14_5:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    vsldoi 2, 2, 2, 4
; CHECK-32-OPT-NEXT:    vinserth 3, 2, 12
; CHECK-32-OPT-NEXT:    vmr 2, 3
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: shuffle_vector_halfword_14_5:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-32-O0-NEXT:    vmr 3, 2
; CHECK-32-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-32-O0-NEXT:    vsldoi 3, 3, 3, 4
; CHECK-32-O0-NEXT:    vinserth 2, 3, 12
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = shufflevector <8 x i16> %a, <8 x i16> %b, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 5, i32 15>
  ret <8 x i16> %vecins
}

define <8 x i16> @shuffle_vector_halfword_15_0(<8 x i16> %a, <8 x i16> %b) {
; CHECK-64-OPT-LABEL: shuffle_vector_halfword_15_0:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    vsldoi 2, 2, 2, 10
; CHECK-64-OPT-NEXT:    vinserth 3, 2, 14
; CHECK-64-OPT-NEXT:    vmr 2, 3
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: shuffle_vector_halfword_15_0:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-64-O0-NEXT:    vmr 3, 2
; CHECK-64-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-64-O0-NEXT:    vsldoi 3, 3, 3, 10
; CHECK-64-O0-NEXT:    vinserth 2, 3, 14
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: shuffle_vector_halfword_15_0:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    vsldoi 2, 2, 2, 10
; CHECK-32-OPT-NEXT:    vinserth 3, 2, 14
; CHECK-32-OPT-NEXT:    vmr 2, 3
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: shuffle_vector_halfword_15_0:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-32-O0-NEXT:    vmr 3, 2
; CHECK-32-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-32-O0-NEXT:    vsldoi 3, 3, 3, 10
; CHECK-32-O0-NEXT:    vinserth 2, 3, 14
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = shufflevector <8 x i16> %a, <8 x i16> %b, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 0>
  ret <8 x i16> %vecins
}

; The following testcases use the same vector in both arguments of the
; shufflevector.  If halfword element 3 in BE mode(or 4 in LE mode) is the one
; we're attempting to insert, then we can use the vector insert instruction
define <8 x i16> @shuffle_vector_halfword_0_4(<8 x i16> %a) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vinserth 2, 2, 14
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_halfword_0_4:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    addis 3, 2, .LCPI16_0@toc@ha
; CHECK-BE-NEXT:    addi 3, 3, .LCPI16_0@toc@l
; CHECK-BE-NEXT:    lxvx 35, 0, 3
; CHECK-BE-NEXT:    vperm 2, 2, 2, 3
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_halfword_0_4:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    ld 3, L..C0(2)
; CHECK-64-NEXT:    lxv 35, 0(3)
; CHECK-64-NEXT:    vperm 2, 2, 2, 3
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_halfword_0_4:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    lwz 3, L..C0(2)
; CHECK-32-NEXT:    lxv 35, 0(3)
; CHECK-32-NEXT:    vperm 2, 2, 2, 3
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <8 x i16> %a, <8 x i16> %a, <8 x i32> <i32 4, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i16> %vecins
}

define <8 x i16> @shuffle_vector_halfword_1_3(<8 x i16> %a) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 3, 2, .LCPI17_0@toc@ha
; CHECK-NEXT:    addi 3, 3, .LCPI17_0@toc@l
; CHECK-NEXT:    lxvx 35, 0, 3
; CHECK-NEXT:    vperm 2, 2, 2, 3
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_halfword_1_3:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vinserth 2, 2, 2
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_halfword_1_3:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vinserth 2, 2, 2
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_halfword_1_3:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vinserth 2, 2, 2
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <8 x i16> %a, <8 x i16> %a, <8 x i32> <i32 0, i32 3, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i16> %vecins
}

define <8 x i16> @shuffle_vector_halfword_2_3(<8 x i16> %a) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 3, 2, .LCPI18_0@toc@ha
; CHECK-NEXT:    addi 3, 3, .LCPI18_0@toc@l
; CHECK-NEXT:    lxvx 35, 0, 3
; CHECK-NEXT:    vperm 2, 2, 2, 3
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_halfword_2_3:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vinserth 2, 2, 4
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_halfword_2_3:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vinserth 2, 2, 4
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_halfword_2_3:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vinserth 2, 2, 4
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <8 x i16> %a, <8 x i16> %a, <8 x i32> <i32 0, i32 1, i32 3, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i16> %vecins
}

define <8 x i16> @shuffle_vector_halfword_3_4(<8 x i16> %a) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vinserth 2, 2, 8
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_halfword_3_4:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    addis 3, 2, .LCPI19_0@toc@ha
; CHECK-BE-NEXT:    addi 3, 3, .LCPI19_0@toc@l
; CHECK-BE-NEXT:    lxvx 35, 0, 3
; CHECK-BE-NEXT:    vperm 2, 2, 2, 3
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_halfword_3_4:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    ld 3, L..C1(2)
; CHECK-64-NEXT:    lxv 35, 0(3)
; CHECK-64-NEXT:    vperm 2, 2, 2, 3
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_halfword_3_4:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    lwz 3, L..C1(2)
; CHECK-32-NEXT:    lxv 35, 0(3)
; CHECK-32-NEXT:    vperm 2, 2, 2, 3
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <8 x i16> %a, <8 x i16> %a, <8 x i32> <i32 0, i32 1, i32 2, i32 4, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i16> %vecins
}

define <8 x i16> @shuffle_vector_halfword_4_3(<8 x i16> %a) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 3, 2, .LCPI20_0@toc@ha
; CHECK-NEXT:    addi 3, 3, .LCPI20_0@toc@l
; CHECK-NEXT:    lxvx 35, 0, 3
; CHECK-NEXT:    vperm 2, 2, 2, 3
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_halfword_4_3:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vinserth 2, 2, 8
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_halfword_4_3:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vinserth 2, 2, 8
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_halfword_4_3:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vinserth 2, 2, 8
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <8 x i16> %a, <8 x i16> %a, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 3, i32 5, i32 6, i32 7>
  ret <8 x i16> %vecins
}

define <8 x i16> @shuffle_vector_halfword_5_3(<8 x i16> %a) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 3, 2, .LCPI21_0@toc@ha
; CHECK-NEXT:    addi 3, 3, .LCPI21_0@toc@l
; CHECK-NEXT:    lxvx 35, 0, 3
; CHECK-NEXT:    vperm 2, 2, 2, 3
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_halfword_5_3:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vinserth 2, 2, 10
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_halfword_5_3:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vinserth 2, 2, 10
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_halfword_5_3:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vinserth 2, 2, 10
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <8 x i16> %a, <8 x i16> %a, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 3, i32 6, i32 7>
  ret <8 x i16> %vecins
}

define <8 x i16> @shuffle_vector_halfword_6_4(<8 x i16> %a) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vinserth 2, 2, 2
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_halfword_6_4:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    addis 3, 2, .LCPI22_0@toc@ha
; CHECK-BE-NEXT:    addi 3, 3, .LCPI22_0@toc@l
; CHECK-BE-NEXT:    lxvx 35, 0, 3
; CHECK-BE-NEXT:    vperm 2, 2, 2, 3
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_halfword_6_4:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    ld 3, L..C2(2)
; CHECK-64-NEXT:    lxv 35, 0(3)
; CHECK-64-NEXT:    vperm 2, 2, 2, 3
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_halfword_6_4:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    lwz 3, L..C2(2)
; CHECK-32-NEXT:    lxv 35, 0(3)
; CHECK-32-NEXT:    vperm 2, 2, 2, 3
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <8 x i16> %a, <8 x i16> %a, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 4, i32 7>
  ret <8 x i16> %vecins
}

define <8 x i16> @shuffle_vector_halfword_7_4(<8 x i16> %a) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vinserth 2, 2, 0
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_halfword_7_4:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    addis 3, 2, .LCPI23_0@toc@ha
; CHECK-BE-NEXT:    addi 3, 3, .LCPI23_0@toc@l
; CHECK-BE-NEXT:    lxvx 35, 0, 3
; CHECK-BE-NEXT:    vperm 2, 2, 2, 3
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_halfword_7_4:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    ld 3, L..C3(2)
; CHECK-64-NEXT:    lxv 35, 0(3)
; CHECK-64-NEXT:    vperm 2, 2, 2, 3
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_halfword_7_4:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    lwz 3, L..C3(2)
; CHECK-32-NEXT:    lxv 35, 0(3)
; CHECK-32-NEXT:    vperm 2, 2, 2, 3
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <8 x i16> %a, <8 x i16> %a, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 4>
  ret <8 x i16> %vecins
}

; The following testcases take one byte element from the second vector and
; inserts it at various locations in the first vector
define <16 x i8> @shuffle_vector_byte_0_16(<16 x i8> %a, <16 x i8> %b) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsldoi 3, 3, 3, 8
; CHECK-NEXT:    vinsertb 2, 3, 15
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_0_16:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vsldoi 3, 3, 3, 9
; CHECK-BE-NEXT:    vinsertb 2, 3, 0
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_0_16:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vsldoi 3, 3, 3, 9
; CHECK-64-NEXT:    vinsertb 2, 3, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_0_16:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vsldoi 3, 3, 3, 9
; CHECK-32-NEXT:    vinsertb 2, 3, 0
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 16, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_1_25(<16 x i8> %a, <16 x i8> %b) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsldoi 3, 3, 3, 15
; CHECK-NEXT:    vinsertb 2, 3, 14
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_1_25:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vsldoi 3, 3, 3, 2
; CHECK-BE-NEXT:    vinsertb 2, 3, 1
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_1_25:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vsldoi 3, 3, 3, 2
; CHECK-64-NEXT:    vinsertb 2, 3, 1
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_1_25:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vsldoi 3, 3, 3, 2
; CHECK-32-NEXT:    vinsertb 2, 3, 1
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 0, i32 25, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_2_18(<16 x i8> %a, <16 x i8> %b) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsldoi 3, 3, 3, 6
; CHECK-NEXT:    vinsertb 2, 3, 13
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_2_18:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vsldoi 3, 3, 3, 11
; CHECK-BE-NEXT:    vinsertb 2, 3, 2
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_2_18:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vsldoi 3, 3, 3, 11
; CHECK-64-NEXT:    vinsertb 2, 3, 2
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_2_18:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vsldoi 3, 3, 3, 11
; CHECK-32-NEXT:    vinsertb 2, 3, 2
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 0, i32 1, i32 18, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_3_27(<16 x i8> %a, <16 x i8> %b) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsldoi 3, 3, 3, 13
; CHECK-NEXT:    vinsertb 2, 3, 12
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_3_27:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vsldoi 3, 3, 3, 4
; CHECK-BE-NEXT:    vinsertb 2, 3, 3
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_3_27:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vsldoi 3, 3, 3, 4
; CHECK-64-NEXT:    vinsertb 2, 3, 3
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_3_27:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vsldoi 3, 3, 3, 4
; CHECK-32-NEXT:    vinsertb 2, 3, 3
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 0, i32 1, i32 2, i32 27, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_4_20(<16 x i8> %a, <16 x i8> %b) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsldoi 3, 3, 3, 4
; CHECK-NEXT:    vinsertb 2, 3, 11
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_4_20:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vsldoi 3, 3, 3, 13
; CHECK-BE-NEXT:    vinsertb 2, 3, 4
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_4_20:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vsldoi 3, 3, 3, 13
; CHECK-64-NEXT:    vinsertb 2, 3, 4
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_4_20:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vsldoi 3, 3, 3, 13
; CHECK-32-NEXT:    vinsertb 2, 3, 4
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 20, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_5_29(<16 x i8> %a, <16 x i8> %b) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsldoi 3, 3, 3, 11
; CHECK-NEXT:    vinsertb 2, 3, 10
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_5_29:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vsldoi 3, 3, 3, 6
; CHECK-BE-NEXT:    vinsertb 2, 3, 5
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_5_29:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vsldoi 3, 3, 3, 6
; CHECK-64-NEXT:    vinsertb 2, 3, 5
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_5_29:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vsldoi 3, 3, 3, 6
; CHECK-32-NEXT:    vinsertb 2, 3, 5
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 29, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_6_22(<16 x i8> %a, <16 x i8> %b) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsldoi 3, 3, 3, 2
; CHECK-NEXT:    vinsertb 2, 3, 9
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_6_22:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vsldoi 3, 3, 3, 15
; CHECK-BE-NEXT:    vinsertb 2, 3, 6
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_6_22:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vsldoi 3, 3, 3, 15
; CHECK-64-NEXT:    vinsertb 2, 3, 6
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_6_22:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vsldoi 3, 3, 3, 15
; CHECK-32-NEXT:    vinsertb 2, 3, 6
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 22, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_7_31(<16 x i8> %a, <16 x i8> %b) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsldoi 3, 3, 3, 9
; CHECK-NEXT:    vinsertb 2, 3, 8
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_7_31:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vsldoi 3, 3, 3, 8
; CHECK-BE-NEXT:    vinsertb 2, 3, 7
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_7_31:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vsldoi 3, 3, 3, 8
; CHECK-64-NEXT:    vinsertb 2, 3, 7
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_7_31:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vsldoi 3, 3, 3, 8
; CHECK-32-NEXT:    vinsertb 2, 3, 7
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 31, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_8_24(<16 x i8> %a, <16 x i8> %b) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vinsertb 2, 3, 7
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_8_24:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vsldoi 3, 3, 3, 1
; CHECK-BE-NEXT:    vinsertb 2, 3, 8
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_8_24:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vsldoi 3, 3, 3, 1
; CHECK-64-NEXT:    vinsertb 2, 3, 8
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_8_24:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vsldoi 3, 3, 3, 1
; CHECK-32-NEXT:    vinsertb 2, 3, 8
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 24, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_9_17(<16 x i8> %a, <16 x i8> %b) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsldoi 3, 3, 3, 7
; CHECK-NEXT:    vinsertb 2, 3, 6
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_9_17:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vsldoi 3, 3, 3, 10
; CHECK-BE-NEXT:    vinsertb 2, 3, 9
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_9_17:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vsldoi 3, 3, 3, 10
; CHECK-64-NEXT:    vinsertb 2, 3, 9
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_9_17:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vsldoi 3, 3, 3, 10
; CHECK-32-NEXT:    vinsertb 2, 3, 9
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 17, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_10_26(<16 x i8> %a, <16 x i8> %b) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsldoi 3, 3, 3, 14
; CHECK-NEXT:    vinsertb 2, 3, 5
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_10_26:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vsldoi 3, 3, 3, 3
; CHECK-BE-NEXT:    vinsertb 2, 3, 10
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_10_26:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vsldoi 3, 3, 3, 3
; CHECK-64-NEXT:    vinsertb 2, 3, 10
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_10_26:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vsldoi 3, 3, 3, 3
; CHECK-32-NEXT:    vinsertb 2, 3, 10
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 26, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_11_19(<16 x i8> %a, <16 x i8> %b) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsldoi 3, 3, 3, 5
; CHECK-NEXT:    vinsertb 2, 3, 4
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_11_19:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vsldoi 3, 3, 3, 12
; CHECK-BE-NEXT:    vinsertb 2, 3, 11
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_11_19:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vsldoi 3, 3, 3, 12
; CHECK-64-NEXT:    vinsertb 2, 3, 11
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_11_19:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vsldoi 3, 3, 3, 12
; CHECK-32-NEXT:    vinsertb 2, 3, 11
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 19, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_12_28(<16 x i8> %a, <16 x i8> %b) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsldoi 3, 3, 3, 12
; CHECK-NEXT:    vinsertb 2, 3, 3
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_12_28:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vsldoi 3, 3, 3, 5
; CHECK-BE-NEXT:    vinsertb 2, 3, 12
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_12_28:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vsldoi 3, 3, 3, 5
; CHECK-64-NEXT:    vinsertb 2, 3, 12
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_12_28:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vsldoi 3, 3, 3, 5
; CHECK-32-NEXT:    vinsertb 2, 3, 12
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 28, i32 13, i32 14, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_13_21(<16 x i8> %a, <16 x i8> %b) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsldoi 3, 3, 3, 3
; CHECK-NEXT:    vinsertb 2, 3, 2
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_13_21:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vsldoi 3, 3, 3, 14
; CHECK-BE-NEXT:    vinsertb 2, 3, 13
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_13_21:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vsldoi 3, 3, 3, 14
; CHECK-64-NEXT:    vinsertb 2, 3, 13
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_13_21:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vsldoi 3, 3, 3, 14
; CHECK-32-NEXT:    vinsertb 2, 3, 13
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 21, i32 14, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_14_30(<16 x i8> %a, <16 x i8> %b) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsldoi 3, 3, 3, 10
; CHECK-NEXT:    vinsertb 2, 3, 1
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_14_30:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vsldoi 3, 3, 3, 7
; CHECK-BE-NEXT:    vinsertb 2, 3, 14
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_14_30:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vsldoi 3, 3, 3, 7
; CHECK-64-NEXT:    vinsertb 2, 3, 14
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_14_30:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vsldoi 3, 3, 3, 7
; CHECK-32-NEXT:    vinsertb 2, 3, 14
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 30, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_15_23(<16 x i8> %a, <16 x i8> %b) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsldoi 3, 3, 3, 1
; CHECK-NEXT:    vinsertb 2, 3, 0
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_15_23:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vinsertb 2, 3, 15
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_15_23:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vinsertb 2, 3, 15
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_15_23:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vinsertb 2, 3, 15
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 23>
  ret <16 x i8> %vecins
}

; The following testcases take one byte element from the first vector and
; inserts it at various locations in the second vector
define <16 x i8> @shuffle_vector_byte_16_8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-64-OPT-LABEL: shuffle_vector_byte_16_8:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    vsldoi 2, 2, 2, 1
; CHECK-64-OPT-NEXT:    vinsertb 3, 2, 0
; CHECK-64-OPT-NEXT:    vmr 2, 3
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: shuffle_vector_byte_16_8:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-64-O0-NEXT:    vmr 3, 2
; CHECK-64-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-64-O0-NEXT:    vsldoi 3, 3, 3, 1
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 0
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: shuffle_vector_byte_16_8:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    vsldoi 2, 2, 2, 1
; CHECK-32-OPT-NEXT:    vinsertb 3, 2, 0
; CHECK-32-OPT-NEXT:    vmr 2, 3
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: shuffle_vector_byte_16_8:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-32-O0-NEXT:    vmr 3, 2
; CHECK-32-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-32-O0-NEXT:    vsldoi 3, 3, 3, 1
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 0
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 8, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_17_1(<16 x i8> %a, <16 x i8> %b) {
; CHECK-64-OPT-LABEL: shuffle_vector_byte_17_1:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    vsldoi 2, 2, 2, 10
; CHECK-64-OPT-NEXT:    vinsertb 3, 2, 1
; CHECK-64-OPT-NEXT:    vmr 2, 3
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: shuffle_vector_byte_17_1:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-64-O0-NEXT:    vmr 3, 2
; CHECK-64-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-64-O0-NEXT:    vsldoi 3, 3, 3, 10
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 1
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: shuffle_vector_byte_17_1:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    vsldoi 2, 2, 2, 10
; CHECK-32-OPT-NEXT:    vinsertb 3, 2, 1
; CHECK-32-OPT-NEXT:    vmr 2, 3
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: shuffle_vector_byte_17_1:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-32-O0-NEXT:    vmr 3, 2
; CHECK-32-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-32-O0-NEXT:    vsldoi 3, 3, 3, 10
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 1
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 16, i32 1, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_18_10(<16 x i8> %a, <16 x i8> %b) {
; CHECK-64-OPT-LABEL: shuffle_vector_byte_18_10:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    vsldoi 2, 2, 2, 3
; CHECK-64-OPT-NEXT:    vinsertb 3, 2, 2
; CHECK-64-OPT-NEXT:    vmr 2, 3
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: shuffle_vector_byte_18_10:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-64-O0-NEXT:    vmr 3, 2
; CHECK-64-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-64-O0-NEXT:    vsldoi 3, 3, 3, 3
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 2
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: shuffle_vector_byte_18_10:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    vsldoi 2, 2, 2, 3
; CHECK-32-OPT-NEXT:    vinsertb 3, 2, 2
; CHECK-32-OPT-NEXT:    vmr 2, 3
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: shuffle_vector_byte_18_10:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-32-O0-NEXT:    vmr 3, 2
; CHECK-32-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-32-O0-NEXT:    vsldoi 3, 3, 3, 3
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 2
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 16, i32 17, i32 10, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_19_3(<16 x i8> %a, <16 x i8> %b) {
; CHECK-64-OPT-LABEL: shuffle_vector_byte_19_3:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    vsldoi 2, 2, 2, 12
; CHECK-64-OPT-NEXT:    vinsertb 3, 2, 3
; CHECK-64-OPT-NEXT:    vmr 2, 3
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: shuffle_vector_byte_19_3:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-64-O0-NEXT:    vmr 3, 2
; CHECK-64-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-64-O0-NEXT:    vsldoi 3, 3, 3, 12
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 3
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: shuffle_vector_byte_19_3:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    vsldoi 2, 2, 2, 12
; CHECK-32-OPT-NEXT:    vinsertb 3, 2, 3
; CHECK-32-OPT-NEXT:    vmr 2, 3
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: shuffle_vector_byte_19_3:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-32-O0-NEXT:    vmr 3, 2
; CHECK-32-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-32-O0-NEXT:    vsldoi 3, 3, 3, 12
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 3
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 16, i32 17, i32 18, i32 3, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_20_12(<16 x i8> %a, <16 x i8> %b) {
; CHECK-64-OPT-LABEL: shuffle_vector_byte_20_12:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    vsldoi 2, 2, 2, 5
; CHECK-64-OPT-NEXT:    vinsertb 3, 2, 4
; CHECK-64-OPT-NEXT:    vmr 2, 3
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: shuffle_vector_byte_20_12:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-64-O0-NEXT:    vmr 3, 2
; CHECK-64-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-64-O0-NEXT:    vsldoi 3, 3, 3, 5
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 4
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: shuffle_vector_byte_20_12:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    vsldoi 2, 2, 2, 5
; CHECK-32-OPT-NEXT:    vinsertb 3, 2, 4
; CHECK-32-OPT-NEXT:    vmr 2, 3
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: shuffle_vector_byte_20_12:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-32-O0-NEXT:    vmr 3, 2
; CHECK-32-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-32-O0-NEXT:    vsldoi 3, 3, 3, 5
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 4
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 16, i32 17, i32 18, i32 19, i32 12, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_21_5(<16 x i8> %a, <16 x i8> %b) {
; CHECK-64-OPT-LABEL: shuffle_vector_byte_21_5:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    vsldoi 2, 2, 2, 14
; CHECK-64-OPT-NEXT:    vinsertb 3, 2, 5
; CHECK-64-OPT-NEXT:    vmr 2, 3
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: shuffle_vector_byte_21_5:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-64-O0-NEXT:    vmr 3, 2
; CHECK-64-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-64-O0-NEXT:    vsldoi 3, 3, 3, 14
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 5
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: shuffle_vector_byte_21_5:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    vsldoi 2, 2, 2, 14
; CHECK-32-OPT-NEXT:    vinsertb 3, 2, 5
; CHECK-32-OPT-NEXT:    vmr 2, 3
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: shuffle_vector_byte_21_5:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-32-O0-NEXT:    vmr 3, 2
; CHECK-32-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-32-O0-NEXT:    vsldoi 3, 3, 3, 14
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 5
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 5, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_22_14(<16 x i8> %a, <16 x i8> %b) {
; CHECK-64-OPT-LABEL: shuffle_vector_byte_22_14:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    vsldoi 2, 2, 2, 7
; CHECK-64-OPT-NEXT:    vinsertb 3, 2, 6
; CHECK-64-OPT-NEXT:    vmr 2, 3
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: shuffle_vector_byte_22_14:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-64-O0-NEXT:    vmr 3, 2
; CHECK-64-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-64-O0-NEXT:    vsldoi 3, 3, 3, 7
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 6
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: shuffle_vector_byte_22_14:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    vsldoi 2, 2, 2, 7
; CHECK-32-OPT-NEXT:    vinsertb 3, 2, 6
; CHECK-32-OPT-NEXT:    vmr 2, 3
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: shuffle_vector_byte_22_14:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-32-O0-NEXT:    vmr 3, 2
; CHECK-32-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-32-O0-NEXT:    vsldoi 3, 3, 3, 7
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 6
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 14, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_23_7(<16 x i8> %a, <16 x i8> %b) {
; CHECK-64-OPT-LABEL: shuffle_vector_byte_23_7:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    vinsertb 3, 2, 7
; CHECK-64-OPT-NEXT:    vmr 2, 3
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: shuffle_vector_byte_23_7:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-64-O0-NEXT:    vmr 3, 2
; CHECK-64-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 7
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: shuffle_vector_byte_23_7:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    vinsertb 3, 2, 7
; CHECK-32-OPT-NEXT:    vmr 2, 3
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: shuffle_vector_byte_23_7:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-32-O0-NEXT:    vmr 3, 2
; CHECK-32-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 7
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 7, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_24_0(<16 x i8> %a, <16 x i8> %b) {
; CHECK-64-OPT-LABEL: shuffle_vector_byte_24_0:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    vsldoi 2, 2, 2, 9
; CHECK-64-OPT-NEXT:    vinsertb 3, 2, 8
; CHECK-64-OPT-NEXT:    vmr 2, 3
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: shuffle_vector_byte_24_0:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-64-O0-NEXT:    vmr 3, 2
; CHECK-64-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-64-O0-NEXT:    vsldoi 3, 3, 3, 9
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 8
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: shuffle_vector_byte_24_0:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    vsldoi 2, 2, 2, 9
; CHECK-32-OPT-NEXT:    vinsertb 3, 2, 8
; CHECK-32-OPT-NEXT:    vmr 2, 3
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: shuffle_vector_byte_24_0:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-32-O0-NEXT:    vmr 3, 2
; CHECK-32-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-32-O0-NEXT:    vsldoi 3, 3, 3, 9
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 8
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 0, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_25_9(<16 x i8> %a, <16 x i8> %b) {
; CHECK-64-OPT-LABEL: shuffle_vector_byte_25_9:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    vsldoi 2, 2, 2, 2
; CHECK-64-OPT-NEXT:    vinsertb 3, 2, 9
; CHECK-64-OPT-NEXT:    vmr 2, 3
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: shuffle_vector_byte_25_9:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-64-O0-NEXT:    vmr 3, 2
; CHECK-64-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-64-O0-NEXT:    vsldoi 3, 3, 3, 2
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 9
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: shuffle_vector_byte_25_9:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    vsldoi 2, 2, 2, 2
; CHECK-32-OPT-NEXT:    vinsertb 3, 2, 9
; CHECK-32-OPT-NEXT:    vmr 2, 3
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: shuffle_vector_byte_25_9:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-32-O0-NEXT:    vmr 3, 2
; CHECK-32-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-32-O0-NEXT:    vsldoi 3, 3, 3, 2
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 9
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 9, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_26_2(<16 x i8> %a, <16 x i8> %b) {
; CHECK-64-OPT-LABEL: shuffle_vector_byte_26_2:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    vsldoi 2, 2, 2, 11
; CHECK-64-OPT-NEXT:    vinsertb 3, 2, 10
; CHECK-64-OPT-NEXT:    vmr 2, 3
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: shuffle_vector_byte_26_2:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-64-O0-NEXT:    vmr 3, 2
; CHECK-64-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-64-O0-NEXT:    vsldoi 3, 3, 3, 11
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 10
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: shuffle_vector_byte_26_2:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    vsldoi 2, 2, 2, 11
; CHECK-32-OPT-NEXT:    vinsertb 3, 2, 10
; CHECK-32-OPT-NEXT:    vmr 2, 3
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: shuffle_vector_byte_26_2:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-32-O0-NEXT:    vmr 3, 2
; CHECK-32-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-32-O0-NEXT:    vsldoi 3, 3, 3, 11
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 10
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 2, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_27_11(<16 x i8> %a, <16 x i8> %b) {
; CHECK-64-OPT-LABEL: shuffle_vector_byte_27_11:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    vsldoi 2, 2, 2, 4
; CHECK-64-OPT-NEXT:    vinsertb 3, 2, 11
; CHECK-64-OPT-NEXT:    vmr 2, 3
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: shuffle_vector_byte_27_11:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-64-O0-NEXT:    vmr 3, 2
; CHECK-64-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-64-O0-NEXT:    vsldoi 3, 3, 3, 4
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 11
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: shuffle_vector_byte_27_11:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    vsldoi 2, 2, 2, 4
; CHECK-32-OPT-NEXT:    vinsertb 3, 2, 11
; CHECK-32-OPT-NEXT:    vmr 2, 3
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: shuffle_vector_byte_27_11:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-32-O0-NEXT:    vmr 3, 2
; CHECK-32-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-32-O0-NEXT:    vsldoi 3, 3, 3, 4
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 11
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 11, i32 28, i32 29, i32 30, i32 31>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_28_4(<16 x i8> %a, <16 x i8> %b) {
; CHECK-64-OPT-LABEL: shuffle_vector_byte_28_4:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    vsldoi 2, 2, 2, 13
; CHECK-64-OPT-NEXT:    vinsertb 3, 2, 12
; CHECK-64-OPT-NEXT:    vmr 2, 3
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: shuffle_vector_byte_28_4:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-64-O0-NEXT:    vmr 3, 2
; CHECK-64-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-64-O0-NEXT:    vsldoi 3, 3, 3, 13
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 12
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: shuffle_vector_byte_28_4:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    vsldoi 2, 2, 2, 13
; CHECK-32-OPT-NEXT:    vinsertb 3, 2, 12
; CHECK-32-OPT-NEXT:    vmr 2, 3
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: shuffle_vector_byte_28_4:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-32-O0-NEXT:    vmr 3, 2
; CHECK-32-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-32-O0-NEXT:    vsldoi 3, 3, 3, 13
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 12
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 4, i32 29, i32 30, i32 31>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_29_13(<16 x i8> %a, <16 x i8> %b) {
; CHECK-64-OPT-LABEL: shuffle_vector_byte_29_13:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    vsldoi 2, 2, 2, 6
; CHECK-64-OPT-NEXT:    vinsertb 3, 2, 13
; CHECK-64-OPT-NEXT:    vmr 2, 3
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: shuffle_vector_byte_29_13:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-64-O0-NEXT:    vmr 3, 2
; CHECK-64-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-64-O0-NEXT:    vsldoi 3, 3, 3, 6
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 13
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: shuffle_vector_byte_29_13:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    vsldoi 2, 2, 2, 6
; CHECK-32-OPT-NEXT:    vinsertb 3, 2, 13
; CHECK-32-OPT-NEXT:    vmr 2, 3
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: shuffle_vector_byte_29_13:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-32-O0-NEXT:    vmr 3, 2
; CHECK-32-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-32-O0-NEXT:    vsldoi 3, 3, 3, 6
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 13
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 13, i32 30, i32 31>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_30_6(<16 x i8> %a, <16 x i8> %b) {
; CHECK-64-OPT-LABEL: shuffle_vector_byte_30_6:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    vsldoi 2, 2, 2, 15
; CHECK-64-OPT-NEXT:    vinsertb 3, 2, 14
; CHECK-64-OPT-NEXT:    vmr 2, 3
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: shuffle_vector_byte_30_6:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-64-O0-NEXT:    vmr 3, 2
; CHECK-64-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-64-O0-NEXT:    vsldoi 3, 3, 3, 15
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 14
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: shuffle_vector_byte_30_6:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    vsldoi 2, 2, 2, 15
; CHECK-32-OPT-NEXT:    vinsertb 3, 2, 14
; CHECK-32-OPT-NEXT:    vmr 2, 3
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: shuffle_vector_byte_30_6:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-32-O0-NEXT:    vmr 3, 2
; CHECK-32-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-32-O0-NEXT:    vsldoi 3, 3, 3, 15
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 14
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 6, i32 31>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_31_15(<16 x i8> %a, <16 x i8> %b) {
; CHECK-64-OPT-LABEL: shuffle_vector_byte_31_15:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    vsldoi 2, 2, 2, 8
; CHECK-64-OPT-NEXT:    vinsertb 3, 2, 15
; CHECK-64-OPT-NEXT:    vmr 2, 3
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: shuffle_vector_byte_31_15:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-64-O0-NEXT:    vmr 3, 2
; CHECK-64-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-64-O0-NEXT:    vsldoi 3, 3, 3, 8
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 15
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: shuffle_vector_byte_31_15:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    vsldoi 2, 2, 2, 8
; CHECK-32-OPT-NEXT:    vinsertb 3, 2, 15
; CHECK-32-OPT-NEXT:    vmr 2, 3
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: shuffle_vector_byte_31_15:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    stxv 35, -16(1) # 16-byte Folded Spill
; CHECK-32-O0-NEXT:    vmr 3, 2
; CHECK-32-O0-NEXT:    lxv 34, -16(1) # 16-byte Folded Reload
; CHECK-32-O0-NEXT:    vsldoi 3, 3, 3, 8
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 15
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 15>
  ret <16 x i8> %vecins
}

; The following testcases use the same vector in both arguments of the
; shufflevector.  If byte element 7 in BE mode(or 8 in LE mode) is the one
; we're attempting to insert, then we can use the vector insert instruction
define <16 x i8> @shuffle_vector_byte_0_7(<16 x i8> %a) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 3, 2, .LCPI56_0@toc@ha
; CHECK-NEXT:    addi 3, 3, .LCPI56_0@toc@l
; CHECK-NEXT:    lxvx 35, 0, 3
; CHECK-NEXT:    vperm 2, 2, 2, 3
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_0_7:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vinsertb 2, 2, 0
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_0_7:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vinsertb 2, 2, 0
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_0_7:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vinsertb 2, 2, 0
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %a, <16 x i32> <i32 7, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_1_8(<16 x i8> %a) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vinsertb 2, 2, 14
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_1_8:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    addis 3, 2, .LCPI57_0@toc@ha
; CHECK-BE-NEXT:    addi 3, 3, .LCPI57_0@toc@l
; CHECK-BE-NEXT:    lxvx 35, 0, 3
; CHECK-BE-NEXT:    vperm 2, 2, 2, 3
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_1_8:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    ld 3, L..C4(2)
; CHECK-64-NEXT:    lxv 35, 0(3)
; CHECK-64-NEXT:    vperm 2, 2, 2, 3
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_1_8:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    lwz 3, L..C4(2)
; CHECK-32-NEXT:    lxv 35, 0(3)
; CHECK-32-NEXT:    vperm 2, 2, 2, 3
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %a, <16 x i32> <i32 0, i32 8, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_2_8(<16 x i8> %a) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vinsertb 2, 2, 13
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_2_8:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    addis 3, 2, .LCPI58_0@toc@ha
; CHECK-BE-NEXT:    addi 3, 3, .LCPI58_0@toc@l
; CHECK-BE-NEXT:    lxvx 35, 0, 3
; CHECK-BE-NEXT:    vperm 2, 2, 2, 3
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_2_8:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    ld 3, L..C5(2)
; CHECK-64-NEXT:    lxv 35, 0(3)
; CHECK-64-NEXT:    vperm 2, 2, 2, 3
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_2_8:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    lwz 3, L..C5(2)
; CHECK-32-NEXT:    lxv 35, 0(3)
; CHECK-32-NEXT:    vperm 2, 2, 2, 3
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %a, <16 x i32> <i32 0, i32 1, i32 8, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_3_7(<16 x i8> %a) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 3, 2, .LCPI59_0@toc@ha
; CHECK-NEXT:    addi 3, 3, .LCPI59_0@toc@l
; CHECK-NEXT:    lxvx 35, 0, 3
; CHECK-NEXT:    vperm 2, 2, 2, 3
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_3_7:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vinsertb 2, 2, 3
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_3_7:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vinsertb 2, 2, 3
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_3_7:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vinsertb 2, 2, 3
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %a, <16 x i32> <i32 0, i32 1, i32 2, i32 7, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_4_7(<16 x i8> %a) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 3, 2, .LCPI60_0@toc@ha
; CHECK-NEXT:    addi 3, 3, .LCPI60_0@toc@l
; CHECK-NEXT:    lxvx 35, 0, 3
; CHECK-NEXT:    vperm 2, 2, 2, 3
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_4_7:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vinsertb 2, 2, 4
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_4_7:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vinsertb 2, 2, 4
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_4_7:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vinsertb 2, 2, 4
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %a, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 7, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_5_8(<16 x i8> %a) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vinsertb 2, 2, 10
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_5_8:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    addis 3, 2, .LCPI61_0@toc@ha
; CHECK-BE-NEXT:    addi 3, 3, .LCPI61_0@toc@l
; CHECK-BE-NEXT:    lxvx 35, 0, 3
; CHECK-BE-NEXT:    vperm 2, 2, 2, 3
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_5_8:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    ld 3, L..C6(2)
; CHECK-64-NEXT:    lxv 35, 0(3)
; CHECK-64-NEXT:    vperm 2, 2, 2, 3
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_5_8:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    lwz 3, L..C6(2)
; CHECK-32-NEXT:    lxv 35, 0(3)
; CHECK-32-NEXT:    vperm 2, 2, 2, 3
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %a, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 8, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_6_8(<16 x i8> %a) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vinsertb 2, 2, 9
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_6_8:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    addis 3, 2, .LCPI62_0@toc@ha
; CHECK-BE-NEXT:    addi 3, 3, .LCPI62_0@toc@l
; CHECK-BE-NEXT:    lxvx 35, 0, 3
; CHECK-BE-NEXT:    vperm 2, 2, 2, 3
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_6_8:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    ld 3, L..C7(2)
; CHECK-64-NEXT:    lxv 35, 0(3)
; CHECK-64-NEXT:    vperm 2, 2, 2, 3
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_6_8:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    lwz 3, L..C7(2)
; CHECK-32-NEXT:    lxv 35, 0(3)
; CHECK-32-NEXT:    vperm 2, 2, 2, 3
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %a, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 8, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_7_8(<16 x i8> %a) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vinsertb 2, 2, 8
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_7_8:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    addis 3, 2, .LCPI63_0@toc@ha
; CHECK-BE-NEXT:    addi 3, 3, .LCPI63_0@toc@l
; CHECK-BE-NEXT:    lxvx 35, 0, 3
; CHECK-BE-NEXT:    vperm 2, 2, 2, 3
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_7_8:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    ld 3, L..C8(2)
; CHECK-64-NEXT:    lxv 35, 0(3)
; CHECK-64-NEXT:    vperm 2, 2, 2, 3
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_7_8:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    lwz 3, L..C8(2)
; CHECK-32-NEXT:    lxv 35, 0(3)
; CHECK-32-NEXT:    vperm 2, 2, 2, 3
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %a, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 8, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_8_7(<16 x i8> %a) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 3, 2, .LCPI64_0@toc@ha
; CHECK-NEXT:    addi 3, 3, .LCPI64_0@toc@l
; CHECK-NEXT:    lxvx 35, 0, 3
; CHECK-NEXT:    vperm 2, 2, 2, 3
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_8_7:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vinsertb 2, 2, 8
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_8_7:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vinsertb 2, 2, 8
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_8_7:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vinsertb 2, 2, 8
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %a, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 7, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_9_7(<16 x i8> %a) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 3, 2, .LCPI65_0@toc@ha
; CHECK-NEXT:    addi 3, 3, .LCPI65_0@toc@l
; CHECK-NEXT:    lxvx 35, 0, 3
; CHECK-NEXT:    vperm 2, 2, 2, 3
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_9_7:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vinsertb 2, 2, 9
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_9_7:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vinsertb 2, 2, 9
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_9_7:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vinsertb 2, 2, 9
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %a, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 7, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_10_7(<16 x i8> %a) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 3, 2, .LCPI66_0@toc@ha
; CHECK-NEXT:    addi 3, 3, .LCPI66_0@toc@l
; CHECK-NEXT:    lxvx 35, 0, 3
; CHECK-NEXT:    vperm 2, 2, 2, 3
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_10_7:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vinsertb 2, 2, 10
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_10_7:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vinsertb 2, 2, 10
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_10_7:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vinsertb 2, 2, 10
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %a, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 7, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_11_8(<16 x i8> %a) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vinsertb 2, 2, 4
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_11_8:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    addis 3, 2, .LCPI67_0@toc@ha
; CHECK-BE-NEXT:    addi 3, 3, .LCPI67_0@toc@l
; CHECK-BE-NEXT:    lxvx 35, 0, 3
; CHECK-BE-NEXT:    vperm 2, 2, 2, 3
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_11_8:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    ld 3, L..C9(2)
; CHECK-64-NEXT:    lxv 35, 0(3)
; CHECK-64-NEXT:    vperm 2, 2, 2, 3
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_11_8:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    lwz 3, L..C9(2)
; CHECK-32-NEXT:    lxv 35, 0(3)
; CHECK-32-NEXT:    vperm 2, 2, 2, 3
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %a, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 8, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_12_8(<16 x i8> %a) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vinsertb 2, 2, 3
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_12_8:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    addis 3, 2, .LCPI68_0@toc@ha
; CHECK-BE-NEXT:    addi 3, 3, .LCPI68_0@toc@l
; CHECK-BE-NEXT:    lxvx 35, 0, 3
; CHECK-BE-NEXT:    vperm 2, 2, 2, 3
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_12_8:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    ld 3, L..C10(2)
; CHECK-64-NEXT:    lxv 35, 0(3)
; CHECK-64-NEXT:    vperm 2, 2, 2, 3
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_12_8:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    lwz 3, L..C10(2)
; CHECK-32-NEXT:    lxv 35, 0(3)
; CHECK-32-NEXT:    vperm 2, 2, 2, 3
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %a, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 8, i32 13, i32 14, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_13_7(<16 x i8> %a) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 3, 2, .LCPI69_0@toc@ha
; CHECK-NEXT:    addi 3, 3, .LCPI69_0@toc@l
; CHECK-NEXT:    lxvx 35, 0, 3
; CHECK-NEXT:    vperm 2, 2, 2, 3
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_13_7:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vinsertb 2, 2, 13
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_13_7:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vinsertb 2, 2, 13
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_13_7:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vinsertb 2, 2, 13
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %a, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 7, i32 14, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_14_7(<16 x i8> %a) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis 3, 2, .LCPI70_0@toc@ha
; CHECK-NEXT:    addi 3, 3, .LCPI70_0@toc@l
; CHECK-NEXT:    lxvx 35, 0, 3
; CHECK-NEXT:    vperm 2, 2, 2, 3
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_14_7:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vinsertb 2, 2, 14
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_14_7:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    vinsertb 2, 2, 14
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_14_7:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    vinsertb 2, 2, 14
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %a, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 7, i32 15>
  ret <16 x i8> %vecins
}

define <16 x i8> @shuffle_vector_byte_15_8(<16 x i8> %a) {
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vinsertb 2, 2, 0
; CHECK-NEXT:    blr
; CHECK-BE-LABEL: shuffle_vector_byte_15_8:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    addis 3, 2, .LCPI71_0@toc@ha
; CHECK-BE-NEXT:    addi 3, 3, .LCPI71_0@toc@l
; CHECK-BE-NEXT:    lxvx 35, 0, 3
; CHECK-BE-NEXT:    vperm 2, 2, 2, 3
; CHECK-BE-NEXT:    blr
; CHECK-64-LABEL: shuffle_vector_byte_15_8:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    ld 3, L..C11(2)
; CHECK-64-NEXT:    lxv 35, 0(3)
; CHECK-64-NEXT:    vperm 2, 2, 2, 3
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: shuffle_vector_byte_15_8:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    lwz 3, L..C11(2)
; CHECK-32-NEXT:    lxv 35, 0(3)
; CHECK-32-NEXT:    vperm 2, 2, 2, 3
; CHECK-32-NEXT:    blr
entry:
  %vecins = shufflevector <16 x i8> %a, <16 x i8> %a, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 8>
  ret <16 x i8> %vecins
}

; The following tests try to insert one halfword element into the vector.  We
; should always be using the 'vinserth' instruction.
define <8 x i16> @insert_halfword_0(<8 x i16> %a, i16 %b) {
; CHECK-64-OPT-LABEL: insert_halfword_0:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-64-OPT-NEXT:    vinserth 2, 3, 0
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: insert_halfword_0:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; CHECK-64-O0-NEXT:    mtfprwz 0, 3
; CHECK-64-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-64-O0-NEXT:    vinserth 2, 3, 0
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: insert_halfword_0:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-32-OPT-NEXT:    vinserth 2, 3, 0
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: insert_halfword_0:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    # kill: def $r4 killed $r3
; CHECK-32-O0-NEXT:    mtfprwz 0, 3
; CHECK-32-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-32-O0-NEXT:    vinserth 2, 3, 0
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = insertelement <8 x i16> %a, i16 %b, i32 0
  ret <8 x i16> %vecins
}

define <8 x i16> @insert_halfword_1(<8 x i16> %a, i16 %b) {
; CHECK-64-OPT-LABEL: insert_halfword_1:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-64-OPT-NEXT:    vinserth 2, 3, 2
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: insert_halfword_1:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; CHECK-64-O0-NEXT:    mtfprwz 0, 3
; CHECK-64-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-64-O0-NEXT:    vinserth 2, 3, 2
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: insert_halfword_1:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-32-OPT-NEXT:    vinserth 2, 3, 2
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: insert_halfword_1:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    # kill: def $r4 killed $r3
; CHECK-32-O0-NEXT:    mtfprwz 0, 3
; CHECK-32-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-32-O0-NEXT:    vinserth 2, 3, 2
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = insertelement <8 x i16> %a, i16 %b, i32 1
  ret <8 x i16> %vecins
}

define <8 x i16> @insert_halfword_2(<8 x i16> %a, i16 %b) {
; CHECK-64-OPT-LABEL: insert_halfword_2:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-64-OPT-NEXT:    vinserth 2, 3, 4
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: insert_halfword_2:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; CHECK-64-O0-NEXT:    mtfprwz 0, 3
; CHECK-64-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-64-O0-NEXT:    vinserth 2, 3, 4
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: insert_halfword_2:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-32-OPT-NEXT:    vinserth 2, 3, 4
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: insert_halfword_2:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    # kill: def $r4 killed $r3
; CHECK-32-O0-NEXT:    mtfprwz 0, 3
; CHECK-32-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-32-O0-NEXT:    vinserth 2, 3, 4
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = insertelement <8 x i16> %a, i16 %b, i32 2
  ret <8 x i16> %vecins
}

define <8 x i16> @insert_halfword_3(<8 x i16> %a, i16 %b) {
; CHECK-64-OPT-LABEL: insert_halfword_3:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-64-OPT-NEXT:    vinserth 2, 3, 6
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: insert_halfword_3:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; CHECK-64-O0-NEXT:    mtfprwz 0, 3
; CHECK-64-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-64-O0-NEXT:    vinserth 2, 3, 6
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: insert_halfword_3:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-32-OPT-NEXT:    vinserth 2, 3, 6
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: insert_halfword_3:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    # kill: def $r4 killed $r3
; CHECK-32-O0-NEXT:    mtfprwz 0, 3
; CHECK-32-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-32-O0-NEXT:    vinserth 2, 3, 6
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = insertelement <8 x i16> %a, i16 %b, i32 3
  ret <8 x i16> %vecins
}

define <8 x i16> @insert_halfword_4(<8 x i16> %a, i16 %b) {
; CHECK-64-OPT-LABEL: insert_halfword_4:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-64-OPT-NEXT:    vinserth 2, 3, 8
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: insert_halfword_4:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; CHECK-64-O0-NEXT:    mtfprwz 0, 3
; CHECK-64-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-64-O0-NEXT:    vinserth 2, 3, 8
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: insert_halfword_4:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-32-OPT-NEXT:    vinserth 2, 3, 8
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: insert_halfword_4:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    # kill: def $r4 killed $r3
; CHECK-32-O0-NEXT:    mtfprwz 0, 3
; CHECK-32-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-32-O0-NEXT:    vinserth 2, 3, 8
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = insertelement <8 x i16> %a, i16 %b, i32 4
  ret <8 x i16> %vecins
}

define <8 x i16> @insert_halfword_5(<8 x i16> %a, i16 %b) {
; CHECK-64-OPT-LABEL: insert_halfword_5:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-64-OPT-NEXT:    vinserth 2, 3, 10
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: insert_halfword_5:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; CHECK-64-O0-NEXT:    mtfprwz 0, 3
; CHECK-64-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-64-O0-NEXT:    vinserth 2, 3, 10
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: insert_halfword_5:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-32-OPT-NEXT:    vinserth 2, 3, 10
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: insert_halfword_5:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    # kill: def $r4 killed $r3
; CHECK-32-O0-NEXT:    mtfprwz 0, 3
; CHECK-32-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-32-O0-NEXT:    vinserth 2, 3, 10
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = insertelement <8 x i16> %a, i16 %b, i32 5
  ret <8 x i16> %vecins
}

define <8 x i16> @insert_halfword_6(<8 x i16> %a, i16 %b) {
; CHECK-64-OPT-LABEL: insert_halfword_6:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-64-OPT-NEXT:    vinserth 2, 3, 12
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: insert_halfword_6:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; CHECK-64-O0-NEXT:    mtfprwz 0, 3
; CHECK-64-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-64-O0-NEXT:    vinserth 2, 3, 12
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: insert_halfword_6:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-32-OPT-NEXT:    vinserth 2, 3, 12
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: insert_halfword_6:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    # kill: def $r4 killed $r3
; CHECK-32-O0-NEXT:    mtfprwz 0, 3
; CHECK-32-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-32-O0-NEXT:    vinserth 2, 3, 12
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = insertelement <8 x i16> %a, i16 %b, i32 6
  ret <8 x i16> %vecins
}

define <8 x i16> @insert_halfword_7(<8 x i16> %a, i16 %b) {
; CHECK-64-OPT-LABEL: insert_halfword_7:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-64-OPT-NEXT:    vinserth 2, 3, 14
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: insert_halfword_7:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; CHECK-64-O0-NEXT:    mtfprwz 0, 3
; CHECK-64-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-64-O0-NEXT:    vinserth 2, 3, 14
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: insert_halfword_7:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-32-OPT-NEXT:    vinserth 2, 3, 14
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: insert_halfword_7:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    # kill: def $r4 killed $r3
; CHECK-32-O0-NEXT:    mtfprwz 0, 3
; CHECK-32-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-32-O0-NEXT:    vinserth 2, 3, 14
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = insertelement <8 x i16> %a, i16 %b, i32 7
  ret <8 x i16> %vecins
}

; The following tests try to insert one byte element into the vector.  We
; should always be using the 'vinsertb' instruction.
define <16 x i8> @insert_byte_0(<16 x i8> %a, i8 %b) {
; CHECK-64-OPT-LABEL: insert_byte_0:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-64-OPT-NEXT:    vinsertb 2, 3, 0
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: insert_byte_0:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; CHECK-64-O0-NEXT:    mtfprwz 0, 3
; CHECK-64-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 0
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: insert_byte_0:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-32-OPT-NEXT:    vinsertb 2, 3, 0
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: insert_byte_0:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    # kill: def $r4 killed $r3
; CHECK-32-O0-NEXT:    mtfprwz 0, 3
; CHECK-32-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 0
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = insertelement <16 x i8> %a, i8 %b, i32 0
  ret <16 x i8> %vecins
}

define <16 x i8> @insert_byte_1(<16 x i8> %a, i8 %b) {
; CHECK-64-OPT-LABEL: insert_byte_1:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-64-OPT-NEXT:    vinsertb 2, 3, 1
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: insert_byte_1:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; CHECK-64-O0-NEXT:    mtfprwz 0, 3
; CHECK-64-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 1
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: insert_byte_1:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-32-OPT-NEXT:    vinsertb 2, 3, 1
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: insert_byte_1:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    # kill: def $r4 killed $r3
; CHECK-32-O0-NEXT:    mtfprwz 0, 3
; CHECK-32-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 1
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = insertelement <16 x i8> %a, i8 %b, i32 1
  ret <16 x i8> %vecins
}

define <16 x i8> @insert_byte_2(<16 x i8> %a, i8 %b) {
; CHECK-64-OPT-LABEL: insert_byte_2:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-64-OPT-NEXT:    vinsertb 2, 3, 2
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: insert_byte_2:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; CHECK-64-O0-NEXT:    mtfprwz 0, 3
; CHECK-64-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 2
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: insert_byte_2:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-32-OPT-NEXT:    vinsertb 2, 3, 2
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: insert_byte_2:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    # kill: def $r4 killed $r3
; CHECK-32-O0-NEXT:    mtfprwz 0, 3
; CHECK-32-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 2
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = insertelement <16 x i8> %a, i8 %b, i32 2
  ret <16 x i8> %vecins
}

define <16 x i8> @insert_byte_3(<16 x i8> %a, i8 %b) {
; CHECK-64-OPT-LABEL: insert_byte_3:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-64-OPT-NEXT:    vinsertb 2, 3, 3
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: insert_byte_3:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; CHECK-64-O0-NEXT:    mtfprwz 0, 3
; CHECK-64-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 3
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: insert_byte_3:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-32-OPT-NEXT:    vinsertb 2, 3, 3
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: insert_byte_3:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    # kill: def $r4 killed $r3
; CHECK-32-O0-NEXT:    mtfprwz 0, 3
; CHECK-32-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 3
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = insertelement <16 x i8> %a, i8 %b, i32 3
  ret <16 x i8> %vecins
}

define <16 x i8> @insert_byte_4(<16 x i8> %a, i8 %b) {
; CHECK-64-OPT-LABEL: insert_byte_4:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-64-OPT-NEXT:    vinsertb 2, 3, 4
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: insert_byte_4:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; CHECK-64-O0-NEXT:    mtfprwz 0, 3
; CHECK-64-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 4
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: insert_byte_4:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-32-OPT-NEXT:    vinsertb 2, 3, 4
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: insert_byte_4:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    # kill: def $r4 killed $r3
; CHECK-32-O0-NEXT:    mtfprwz 0, 3
; CHECK-32-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 4
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = insertelement <16 x i8> %a, i8 %b, i32 4
  ret <16 x i8> %vecins
}

define <16 x i8> @insert_byte_5(<16 x i8> %a, i8 %b) {
; CHECK-64-OPT-LABEL: insert_byte_5:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-64-OPT-NEXT:    vinsertb 2, 3, 5
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: insert_byte_5:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; CHECK-64-O0-NEXT:    mtfprwz 0, 3
; CHECK-64-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 5
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: insert_byte_5:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-32-OPT-NEXT:    vinsertb 2, 3, 5
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: insert_byte_5:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    # kill: def $r4 killed $r3
; CHECK-32-O0-NEXT:    mtfprwz 0, 3
; CHECK-32-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 5
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = insertelement <16 x i8> %a, i8 %b, i32 5
  ret <16 x i8> %vecins
}

define <16 x i8> @insert_byte_6(<16 x i8> %a, i8 %b) {
; CHECK-64-OPT-LABEL: insert_byte_6:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-64-OPT-NEXT:    vinsertb 2, 3, 6
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: insert_byte_6:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; CHECK-64-O0-NEXT:    mtfprwz 0, 3
; CHECK-64-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 6
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: insert_byte_6:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-32-OPT-NEXT:    vinsertb 2, 3, 6
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: insert_byte_6:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    # kill: def $r4 killed $r3
; CHECK-32-O0-NEXT:    mtfprwz 0, 3
; CHECK-32-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 6
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = insertelement <16 x i8> %a, i8 %b, i32 6
  ret <16 x i8> %vecins
}

define <16 x i8> @insert_byte_7(<16 x i8> %a, i8 %b) {
; CHECK-64-OPT-LABEL: insert_byte_7:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-64-OPT-NEXT:    vinsertb 2, 3, 7
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: insert_byte_7:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; CHECK-64-O0-NEXT:    mtfprwz 0, 3
; CHECK-64-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 7
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: insert_byte_7:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-32-OPT-NEXT:    vinsertb 2, 3, 7
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: insert_byte_7:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    # kill: def $r4 killed $r3
; CHECK-32-O0-NEXT:    mtfprwz 0, 3
; CHECK-32-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 7
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = insertelement <16 x i8> %a, i8 %b, i32 7
  ret <16 x i8> %vecins
}

define <16 x i8> @insert_byte_8(<16 x i8> %a, i8 %b) {
; CHECK-64-OPT-LABEL: insert_byte_8:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-64-OPT-NEXT:    vinsertb 2, 3, 8
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: insert_byte_8:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; CHECK-64-O0-NEXT:    mtfprwz 0, 3
; CHECK-64-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 8
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: insert_byte_8:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-32-OPT-NEXT:    vinsertb 2, 3, 8
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: insert_byte_8:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    # kill: def $r4 killed $r3
; CHECK-32-O0-NEXT:    mtfprwz 0, 3
; CHECK-32-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 8
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = insertelement <16 x i8> %a, i8 %b, i32 8
  ret <16 x i8> %vecins
}

define <16 x i8> @insert_byte_9(<16 x i8> %a, i8 %b) {
; CHECK-64-OPT-LABEL: insert_byte_9:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-64-OPT-NEXT:    vinsertb 2, 3, 9
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: insert_byte_9:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; CHECK-64-O0-NEXT:    mtfprwz 0, 3
; CHECK-64-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 9
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: insert_byte_9:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-32-OPT-NEXT:    vinsertb 2, 3, 9
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: insert_byte_9:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    # kill: def $r4 killed $r3
; CHECK-32-O0-NEXT:    mtfprwz 0, 3
; CHECK-32-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 9
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = insertelement <16 x i8> %a, i8 %b, i32 9
  ret <16 x i8> %vecins
}

define <16 x i8> @insert_byte_10(<16 x i8> %a, i8 %b) {
; CHECK-64-OPT-LABEL: insert_byte_10:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-64-OPT-NEXT:    vinsertb 2, 3, 10
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: insert_byte_10:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; CHECK-64-O0-NEXT:    mtfprwz 0, 3
; CHECK-64-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 10
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: insert_byte_10:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-32-OPT-NEXT:    vinsertb 2, 3, 10
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: insert_byte_10:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    # kill: def $r4 killed $r3
; CHECK-32-O0-NEXT:    mtfprwz 0, 3
; CHECK-32-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 10
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = insertelement <16 x i8> %a, i8 %b, i32 10
  ret <16 x i8> %vecins
}

define <16 x i8> @insert_byte_11(<16 x i8> %a, i8 %b) {
; CHECK-64-OPT-LABEL: insert_byte_11:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-64-OPT-NEXT:    vinsertb 2, 3, 11
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: insert_byte_11:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; CHECK-64-O0-NEXT:    mtfprwz 0, 3
; CHECK-64-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 11
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: insert_byte_11:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-32-OPT-NEXT:    vinsertb 2, 3, 11
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: insert_byte_11:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    # kill: def $r4 killed $r3
; CHECK-32-O0-NEXT:    mtfprwz 0, 3
; CHECK-32-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 11
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = insertelement <16 x i8> %a, i8 %b, i32 11
  ret <16 x i8> %vecins
}

define <16 x i8> @insert_byte_12(<16 x i8> %a, i8 %b) {
; CHECK-64-OPT-LABEL: insert_byte_12:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-64-OPT-NEXT:    vinsertb 2, 3, 12
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: insert_byte_12:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; CHECK-64-O0-NEXT:    mtfprwz 0, 3
; CHECK-64-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 12
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: insert_byte_12:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-32-OPT-NEXT:    vinsertb 2, 3, 12
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: insert_byte_12:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    # kill: def $r4 killed $r3
; CHECK-32-O0-NEXT:    mtfprwz 0, 3
; CHECK-32-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 12
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = insertelement <16 x i8> %a, i8 %b, i32 12
  ret <16 x i8> %vecins
}

define <16 x i8> @insert_byte_13(<16 x i8> %a, i8 %b) {
; CHECK-64-OPT-LABEL: insert_byte_13:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-64-OPT-NEXT:    vinsertb 2, 3, 13
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: insert_byte_13:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; CHECK-64-O0-NEXT:    mtfprwz 0, 3
; CHECK-64-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 13
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: insert_byte_13:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-32-OPT-NEXT:    vinsertb 2, 3, 13
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: insert_byte_13:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    # kill: def $r4 killed $r3
; CHECK-32-O0-NEXT:    mtfprwz 0, 3
; CHECK-32-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 13
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = insertelement <16 x i8> %a, i8 %b, i32 13
  ret <16 x i8> %vecins
}

define <16 x i8> @insert_byte_14(<16 x i8> %a, i8 %b) {
; CHECK-64-OPT-LABEL: insert_byte_14:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-64-OPT-NEXT:    vinsertb 2, 3, 14
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: insert_byte_14:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; CHECK-64-O0-NEXT:    mtfprwz 0, 3
; CHECK-64-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 14
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: insert_byte_14:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-32-OPT-NEXT:    vinsertb 2, 3, 14
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: insert_byte_14:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    # kill: def $r4 killed $r3
; CHECK-32-O0-NEXT:    mtfprwz 0, 3
; CHECK-32-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 14
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = insertelement <16 x i8> %a, i8 %b, i32 14
  ret <16 x i8> %vecins
}

define <16 x i8> @insert_byte_15(<16 x i8> %a, i8 %b) {
; CHECK-64-OPT-LABEL: insert_byte_15:
; CHECK-64-OPT:       # %bb.0: # %entry
; CHECK-64-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-64-OPT-NEXT:    vinsertb 2, 3, 15
; CHECK-64-OPT-NEXT:    blr
;
; CHECK-64-O0-LABEL: insert_byte_15:
; CHECK-64-O0:       # %bb.0: # %entry
; CHECK-64-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; CHECK-64-O0-NEXT:    mtfprwz 0, 3
; CHECK-64-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-64-O0-NEXT:    vinsertb 2, 3, 15
; CHECK-64-O0-NEXT:    blr
;
; CHECK-32-OPT-LABEL: insert_byte_15:
; CHECK-32-OPT:       # %bb.0: # %entry
; CHECK-32-OPT-NEXT:    mtvsrwz 35, 3
; CHECK-32-OPT-NEXT:    vinsertb 2, 3, 15
; CHECK-32-OPT-NEXT:    blr
;
; CHECK-32-O0-LABEL: insert_byte_15:
; CHECK-32-O0:       # %bb.0: # %entry
; CHECK-32-O0-NEXT:    # kill: def $r4 killed $r3
; CHECK-32-O0-NEXT:    mtfprwz 0, 3
; CHECK-32-O0-NEXT:    xscpsgndp 35, 0, 0
; CHECK-32-O0-NEXT:    vinsertb 2, 3, 15
; CHECK-32-O0-NEXT:    blr
entry:
  %vecins = insertelement <16 x i8> %a, i8 %b, i32 15
  ret <16 x i8> %vecins
}
