"use strict";

module.exports = { // eslint-disable-line no-undef
  "extends": [
    "../../../testing/mochitest/browser.eslintrc.js"
  ],
  // All globals made available in the test environment.
  "globals": {
    // Content scripts have global 'content' object
    "content": true,

    "add_task": true,

    // Defined in accessible/tests/mochitest/ common.js, name.js, states.js
    "prettyName": true,
    "statesToString": true,
    "eventTypeToString": true,
    "testAttrs": true,
    "testAbsentAttrs": true,
    "testName": true,
    "testDescr": true,
    "testStates": true,
    "testRelation": true,
    "testValue": true,
    "testAccessibleTree": true,
    "isAccessible": true,
    "getAccessibleDOMNodeID": true,

    // Defined for all top level accessibility browser tests.
    "setE10sPrefs": true,
    "unsetE10sPrefs": true,
    "initPromise": true,
    "shutdownPromise": true,
    "forceGC": true,

    // Defined for all e10s accessibility browser tests.
    "addAccessibleTask": true,
    "BrowserTestUtils": true,
    "ContentTask": true,
    "gBrowser": true,
    "isDefunct": true,
    "loadScripts": true,
    "loadFrameScripts": true,
    "Logger": true,
    "MOCHITESTS_DIR": true,
    "waitForEvent": true,
    "waitForMultipleEvents": true,
    "invokeSetAttribute": true,
    "invokeSetStyle": true,
    "invokeFocus": true,
    "findAccessibleChildByID": true
  },
  "rules": {
    "mozilla/no-aArgs": "warn",
    "mozilla/no-cpows-in-tests": "warn",
    "mozilla/reject-importGlobalProperties": "warn",
    "mozilla/var-only-at-top-level": "warn",

    "block-scoped-var": "error",
    "brace-style": ["error", "1tbs"],
    "camelcase": "error",
    "comma-dangle": ["error", "never"],
    "comma-spacing": "error",
    "comma-style": ["error", "last"],
    "complexity": ["error", 35],
    "consistent-this": "off",
    "curly": ["error", "multi-line"],
    "default-case": "off",
    "dot-location": ["error", "property"],
    "dot-notation": "error",
    "eol-last": "error",
    "eqeqeq": "off",
    "func-names": "off",
    "func-style": "off",
    "generator-star": "off",
    "global-strict": "off",
    "handle-callback-err": ["error", "er"],
    "indent": ["error", 2, {"SwitchCase": 1}],
    "key-spacing": ["error", {"beforeColon": false, "afterColon": true}],
    "linebreak-style": "off",
    "max-depth": "off",
    "max-nested-callbacks": ["error", 4],
    "max-params": "off",
    "max-statements": "off",
    "new-cap": ["error", {"capIsNew": false}],
    "new-parens": "error",
    "no-array-constructor": "error",
    "no-bitwise": "off",
    "no-caller": "error",
    "no-catch-shadow": "error",
    "no-comma-dangle": "off",
    "no-cond-assign": "error",
    "no-console": "off",
    "no-constant-condition": "off",
    "no-continue": "off",
    "no-control-regex": "error",
    "no-debugger": "error",
    "no-delete-var": "error",
    "no-div-regex": "off",
    "no-dupe-args": "error",
    "no-dupe-keys": "error",
    "no-duplicate-case": "error",
    "no-else-return": "error",
    "no-empty": "error",
    "no-empty-character-class": "error",
    "no-eval": "error",
    "no-ex-assign": "error",
    "no-extend-native": "error",
    "no-extra-bind": "error",
    "no-extra-boolean-cast": "error",
    "no-extra-parens": "off",
    "no-extra-semi": "error",
    "no-extra-strict": "off",
    "no-fallthrough": "error",
    "no-floating-decimal": "off",
    "no-inline-comments": "off",
    "no-lonely-if": "error",
    "no-mixed-requires": "off",
    "no-mixed-spaces-and-tabs": "error",
    "no-multi-spaces": "error",
    "no-multi-str": "error",
    "no-multiple-empty-lines": ["error", {"max": 1}],
    "no-native-reassign": "error",
    "no-nested-ternary": "error",
    "no-new-require": "off",
    "no-octal": "error",
    "no-param-reassign": "off",
    "no-path-concat": "off",
    "no-plusplus": "off",
    "no-process-env": "off",
    "no-process-exit": "off",
    "no-proto": "error",
    "no-redeclare": "error",
    "no-regex-spaces": "error",
    "no-reserved-keys": "off",
    "no-restricted-modules": "off",
    "no-return-assign": "error",
    "no-script-url": "off",
    "no-self-compare": "error",
    "no-sequences": "error",
    "no-shadow": "error",
    "no-shadow-restricted-names": "error",
    "no-space-before-semi": "off",
    "no-spaced-func": "error",
    "no-sparse-arrays": "error",
    "no-sync": "off",
    "no-ternary": "off",
    "no-throw-literal": "error",
    "no-trailing-spaces": "error",
    "no-undef": "error",
    "no-underscore-dangle": "off",
    "no-undefined": "off",
    "no-unneeded-ternary": "error",
    "no-unreachable": "error",
    "no-unused-vars": ["error", {"vars": "all", "args": "none"}],
    "no-use-before-define": "off",
    "no-var": "off",
    "no-warning-comments": "off",
    "no-with": "error",
    "object-shorthand": "off",
    "one-var": ["error", "never"],
    "padded-blocks": ["error", "never"],
    "quote-props": "off",
    "radix": "error",
    "semi": ["error", "always"],
    "semi-spacing": ["error", {"before": false, "after": true}],
    "sort-vars": "off",
    "space-after-function-name": "off",
    "keyword-spacing": "error",
    "space-before-blocks": "error",
    "space-before-function-parentheses": "off",
    "space-before-function-paren": ["error", "never"],
    "space-in-brackets": "off",
    "space-in-parens": ["error", "never"],
    "space-infix-ops": ["error", {"int32Hint": true}],
    "space-unary-ops": ["error", { "words": true, "nonwords": false }],
    "space-unary-word-ops": "off",
    "spaced-comment": ["error", "always"],
    "strict": ["error", "global"],
    "use-isnan": "error",
    "valid-jsdoc": "off",
    "valid-typeof": "error",
    "vars-on-top": "off",
    "wrap-iife": "off",
    "wrap-regex": "off",
    "yoda": "error",

    "guard-for-in": "off",
    "newline-after-var": "off",
    "no-alert": "off",
    "no-eq-null": "off",
    "no-func-assign": "off",
    "no-implied-eval": "off",
    "no-inner-declarations": "off",
    "no-invalid-regexp": "off",
    "no-irregular-whitespace": "off",
    "no-iterator": "off",
    "no-label-var": "off",
    "no-labels": "error",
    "no-lone-blocks": "off",
    "no-loop-func": "off",
    "no-negated-in-lhs": "off",
    "no-new": "off",
    "no-new-func": "off",
    "no-new-object": "off",
    "no-new-wrappers": "off",
    "no-obj-calls": "off",
    "no-octal-escape": "off",
    "no-undef-init": "error",
    "no-unexpected-multiline": "error",
    "object-curly-spacing": "off",
    "no-unused-expressions": "off",
    "no-void": "off",
    "no-wrap-func": "off",
    "operator-assignment": "off",
    "operator-linebreak": ["error", "after"]
  }
};
