/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import virtuoso.jdbc2.VirtuosoConnection;
import virtuoso.jdbc2.VirtuosoException;
import virtuoso.jdbc2.VirtuosoPreparedStatement;
import virtuoso.sql.RdfBox;

public class VirtuosoRdfBox
implements RdfBox {
    public short rb_type;
    public short rb_lang;
    public boolean rb_is_complete;
    public boolean rb_is_outlined;
    public boolean rb_chksum_tail;
    public boolean rb_is_text_index;
    public long rb_ro_id;
    public Object rb_box;
    public static final int RDF_BOX_DEFAULT_TYPE = 257;
    public static final int RDF_BOX_DEFAULT_LANG = 257;
    public static final int RBS_OUTLINED = 1;
    public static final int RBS_COMPLETE = 2;
    public static final int RBS_HAS_LANG = 4;
    public static final int RBS_HAS_TYPE = 8;
    public static final int RBS_CHKSUM = 16;
    public static final int RBS_64 = 32;
    private VirtuosoConnection connection = null;

    public VirtuosoRdfBox(VirtuosoConnection virtuosoConnection, Object object, boolean bl, short s, short s2, long l) {
        this.connection = virtuosoConnection;
        this.rb_box = object;
        this.rb_type = s;
        this.rb_lang = s2;
        this.rb_is_complete = bl;
        this.rb_ro_id = l;
        this.rb_is_outlined = false;
        this.rb_chksum_tail = false;
    }

    public VirtuosoRdfBox(Connection connection, Object object, String string, String string2) {
        this.connection = (VirtuosoConnection)connection;
        this.rb_box = object;
        long l = this.rdfMakeObj(object, string, string2);
        this.rb_type = this.getTypeKey(string);
        this.rb_lang = this.getLangKey(string2);
        this.rb_is_complete = false;
        this.rb_ro_id = l;
        this.rb_is_outlined = false;
        this.rb_chksum_tail = false;
    }

    private long rdfMakeObj(Object object, String string, String string2) {
        long l = 0L;
        try {
            VirtuosoPreparedStatement virtuosoPreparedStatement = (VirtuosoPreparedStatement)this.connection.prepareStatement("DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL (?, ?, ?)");
            virtuosoPreparedStatement.setObject(1, object);
            virtuosoPreparedStatement.setString(2, string);
            virtuosoPreparedStatement.setString(3, string2);
            VirtuosoPreparedStatement virtuosoPreparedStatement2 = (VirtuosoPreparedStatement)this.connection.prepareStatement("select rdf_box_ro_id (?)");
            virtuosoPreparedStatement2.setObject(1, object);
            try {
                long l2;
                virtuosoPreparedStatement.executeQuery();
                ResultSet resultSet = virtuosoPreparedStatement2.executeQuery();
                while (resultSet.next()) {
                }
                l = l2 = resultSet.getLong(1);
                virtuosoPreparedStatement.close();
                this.connection.rdf_lang_hash.clear();
                this.connection.rdf_type_hash.clear();
                this.connection.rdf_lang_rev.clear();
                this.connection.rdf_type_rev.clear();
            }
            catch (SQLException sQLException) {}
        }
        catch (VirtuosoException virtuosoException) {
            // empty catch block
        }
        return l;
    }

    public short getLangKey(String string) {
        if (string == null) {
            return 257;
        }
        this.ensureLangHash();
        Integer n = (Integer)this.connection.rdf_lang_rev.get(string);
        return n != null ? (short)n.shortValue() : (short)257;
    }

    public short getTypeKey(String string) {
        if (string == null) {
            return 257;
        }
        this.ensureTypeHash();
        Integer n = (Integer)this.connection.rdf_type_rev.get(string);
        return n != null ? (short)n.shortValue() : (short)257;
    }

    private void fillHashFromSQL(Hashtable hashtable, Hashtable hashtable2, String string) {
        try {
            Statement statement = this.connection.createStatement();
            try {
                statement.execute(string);
                ResultSet resultSet = statement.getResultSet();
                while (resultSet.next()) {
                    Integer n = (Integer)resultSet.getObject(1);
                    String string2 = resultSet.getString(2);
                    hashtable.put(n, string2);
                    hashtable2.put(string2, n);
                }
                statement.close();
            }
            catch (SQLException sQLException) {}
        }
        catch (VirtuosoException virtuosoException) {
            // empty catch block
        }
    }

    private void ensureTypeHash() {
        if (this.connection.rdf_type_hash.isEmpty()) {
            this.fillHashFromSQL(this.connection.rdf_type_hash, this.connection.rdf_type_rev, "select RDT_TWOBYTE, RDT_QNAME from DB.DBA.RDF_DATATYPE");
        }
    }

    private void ensureLangHash() {
        if (this.connection.rdf_lang_hash.isEmpty()) {
            this.fillHashFromSQL(this.connection.rdf_lang_hash, this.connection.rdf_lang_rev, "select RL_TWOBYTE, RL_ID from DB.DBA.RDF_LANGUAGE");
        }
    }

    public String getType() {
        this.ensureTypeHash();
        String string = (String)this.connection.rdf_type_hash.get(new Integer(this.rb_type));
        return string;
    }

    public String getLang() {
        this.ensureLangHash();
        String string = (String)this.connection.rdf_lang_hash.get(new Integer(this.rb_lang));
        return string;
    }

    public String toString() {
        return this.rb_box.toString();
    }
}

