/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(DOM_STORAGE)

#include "JSStorage.h"

#include "AtomicString.h"
#include "JSStorageCustom.h"
#include "KURL.h"
#include "Storage.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSStorage);

/* Hash table */

static const HashTableValue JSStorageTableValues[3] =
{
    { "length", DontDelete|DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStorageLength), (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStorageConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSStorageTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSStorageTableValues, 0 };
#else
    { 5, 3, JSStorageTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSStorageConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSStorageConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSStorageConstructorTableValues, 0 };
#else
    { 1, 0, JSStorageConstructorTableValues, 0 };
#endif

class JSStorageConstructor : public DOMConstructorObject {
public:
    JSStorageConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSStorageConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSStoragePrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSStorageConstructor::s_info = { "StorageConstructor", 0, &JSStorageConstructorTable, 0 };

bool JSStorageConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSStorageConstructor, DOMObject>(exec, &JSStorageConstructorTable, this, propertyName, slot);
}

bool JSStorageConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSStorageConstructor, DOMObject>(exec, &JSStorageConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSStoragePrototypeTableValues[6] =
{
    { "key", DontDelete|DontEnum|Function, (intptr_t)static_cast<NativeFunction>(jsStoragePrototypeFunctionKey), (intptr_t)1 },
    { "getItem", DontDelete|DontEnum|Function, (intptr_t)static_cast<NativeFunction>(jsStoragePrototypeFunctionGetItem), (intptr_t)1 },
    { "setItem", DontDelete|DontEnum|Function, (intptr_t)static_cast<NativeFunction>(jsStoragePrototypeFunctionSetItem), (intptr_t)2 },
    { "removeItem", DontDelete|DontEnum|Function, (intptr_t)static_cast<NativeFunction>(jsStoragePrototypeFunctionRemoveItem), (intptr_t)1 },
    { "clear", DontDelete|DontEnum|Function, (intptr_t)static_cast<NativeFunction>(jsStoragePrototypeFunctionClear), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSStoragePrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSStoragePrototypeTableValues, 0 };
#else
    { 17, 15, JSStoragePrototypeTableValues, 0 };
#endif

const ClassInfo JSStoragePrototype::s_info = { "StoragePrototype", 0, &JSStoragePrototypeTable, 0 };

JSObject* JSStoragePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSStorage>(exec, globalObject);
}

bool JSStoragePrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSStoragePrototypeTable, this, propertyName, slot);
}

bool JSStoragePrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSStoragePrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSStorage::s_info = { "Storage", 0, &JSStorageTable, 0 };

JSStorage::JSStorage(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<Storage> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSStorage::~JSStorage()
{
    forgetDOMObject(this, impl());
}

JSObject* JSStorage::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSStoragePrototype(JSStoragePrototype::createStructure(globalObject->objectPrototype()));
}

bool JSStorage::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = JSStorageTable.entry(exec, propertyName);
    if (entry) {
        slot.setCustom(this, entry->propertyGetter());
        return true;
    }
    if (canGetItemsForName(exec, static_cast<Storage*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    return getStaticValueSlot<JSStorage, Base>(exec, &JSStorageTable, this, propertyName, slot);
}

bool JSStorage::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    const HashEntry* entry = JSStorageTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(this, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    if (canGetItemsForName(exec, static_cast<Storage*>(impl()), propertyName)) {
        PropertySlot slot;
        slot.setCustom(this, nameGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), ReadOnly | DontDelete | DontEnum);
        return true;
    }
    return getStaticValueDescriptor<JSStorage, Base>(exec, &JSStorageTable, this, propertyName, descriptor);
}

JSValue jsStorageLength(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSStorage* castedThis = static_cast<JSStorage*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Storage* imp = static_cast<Storage*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->length());
    return result;
}

JSValue jsStorageConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSStorage* domObject = static_cast<JSStorage*>(asObject(slotBase));
    return JSStorage::getConstructor(exec, domObject->globalObject());
}
void JSStorage::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    if (putDelegate(exec, propertyName, value, slot))
        return;
    Base::put(exec, propertyName, value, slot);
}

JSValue JSStorage::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSStorageConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsStoragePrototypeFunctionKey(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSStorage::s_info))
        return throwError(exec, TypeError);
    JSStorage* castedThisObj = static_cast<JSStorage*>(asObject(thisValue));
    Storage* imp = static_cast<Storage*>(castedThisObj->impl());
    unsigned index = args.at(0).toInt32(exec);


    JSC::JSValue result = jsStringOrNull(exec, imp->key(index));
    return result;
}

JSValue JSC_HOST_CALL jsStoragePrototypeFunctionGetItem(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSStorage::s_info))
        return throwError(exec, TypeError);
    JSStorage* castedThisObj = static_cast<JSStorage*>(asObject(thisValue));
    Storage* imp = static_cast<Storage*>(castedThisObj->impl());
    const UString& key = args.at(0).toString(exec);


    JSC::JSValue result = jsStringOrNull(exec, imp->getItem(key));
    return result;
}

JSValue JSC_HOST_CALL jsStoragePrototypeFunctionSetItem(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSStorage::s_info))
        return throwError(exec, TypeError);
    JSStorage* castedThisObj = static_cast<JSStorage*>(asObject(thisValue));
    Storage* imp = static_cast<Storage*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& key = args.at(0).toString(exec);
    const UString& data = args.at(1).toString(exec);

    imp->setItem(key, data, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsStoragePrototypeFunctionRemoveItem(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSStorage::s_info))
        return throwError(exec, TypeError);
    JSStorage* castedThisObj = static_cast<JSStorage*>(asObject(thisValue));
    Storage* imp = static_cast<Storage*>(castedThisObj->impl());
    const UString& key = args.at(0).toString(exec);

    imp->removeItem(key);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsStoragePrototypeFunctionClear(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSStorage::s_info))
        return throwError(exec, TypeError);
    JSStorage* castedThisObj = static_cast<JSStorage*>(asObject(thisValue));
    Storage* imp = static_cast<Storage*>(castedThisObj->impl());

    imp->clear();
    return jsUndefined();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Storage* object)
{
    return getDOMObjectWrapper<JSStorage>(exec, globalObject, object);
}
Storage* toStorage(JSC::JSValue value)
{
    return value.inherits(&JSStorage::s_info) ? static_cast<JSStorage*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(DOM_STORAGE)
