/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"

#include <glib-object.h>

#include "libgimpmath/gimpmath.h"

#include "pdb-types.h"

#include "core/gimpdrawable.h"
#include "core/gimppaintinfo.h"
#include "core/gimpparamspecs.h"
#include "paint/gimppaintcore-stroke.h"
#include "paint/gimppaintcore.h"
#include "paint/gimppaintoptions.h"

#include "gimppdb.h"
#include "gimppdb-utils.h"
#include "gimpprocedure.h"
#include "internal-procs.h"


static const GimpCoords default_coords = GIMP_COORDS_DEFAULT_VALUES;

static gboolean
paint_tools_stroke (Gimp              *gimp,
                    GimpContext       *context,
                    GimpPaintOptions  *options,
                    GimpDrawable      *drawable,
                    gint               n_strokes,
                    const gdouble     *strokes,
                    GError           **error,
                    const gchar       *first_property_name,
                    ...)
{
  GimpPaintCore *core;
  GimpCoords    *coords;
  gboolean       retval;
  gint           i;
  va_list        args;

  n_strokes /= 2;  /* #doubles -> #points */

  /*  undefine the paint-relevant context properties and get them
   *  from the current context
   */
  gimp_context_define_properties (GIMP_CONTEXT (options),
                                  GIMP_CONTEXT_PAINT_PROPS_MASK,
                                  FALSE);
  gimp_context_set_parent (GIMP_CONTEXT (options), context);

  va_start (args, first_property_name);
  core = GIMP_PAINT_CORE (g_object_new_valist (options->paint_info->paint_type,
                                               first_property_name, args));
  va_end (args);

  coords = g_new (GimpCoords, n_strokes);

  for (i = 0; i < n_strokes; i++)
    {
      coords[i]   = default_coords;
      coords[i].x = strokes[2 * i];
      coords[i].y = strokes[2 * i + 1];
    }

  retval = gimp_paint_core_stroke (core, drawable, options,
                                   coords, n_strokes,
                                   error);

  g_free (coords);

  g_object_unref (core);
  g_object_unref (options);

  return retval;
}

static GValueArray *
airbrush_invoker (GimpProcedure      *procedure,
                  Gimp               *gimp,
                  GimpContext        *context,
                  GimpProgress       *progress,
                  const GValueArray  *args,
                  GError            **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gdouble pressure;
  gint32 num_strokes;
  const gdouble *strokes;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  pressure = g_value_get_double (&args->values[1]);
  num_strokes = g_value_get_int (&args->values[2]);
  strokes = gimp_value_get_floatarray (&args->values[3]);

  if (success)
    {
      GimpPaintInfo *info = gimp_pdb_get_paint_info (gimp, "gimp-airbrush", error);

      if (info && gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error))
        {
          GimpPaintOptions *options = gimp_paint_options_new (info);

          g_object_set (options,
                        "pressure", pressure,
                        NULL);

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", info->blurb,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
airbrush_default_invoker (GimpProcedure      *procedure,
                          Gimp               *gimp,
                          GimpContext        *context,
                          GimpProgress       *progress,
                          const GValueArray  *args,
                          GError            **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 num_strokes;
  const gdouble *strokes;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  num_strokes = g_value_get_int (&args->values[1]);
  strokes = gimp_value_get_floatarray (&args->values[2]);

  if (success)
    {
      GimpPaintInfo *info = gimp_pdb_get_paint_info (gimp, "gimp-airbrush", error);

      if (info && gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error))
        {
          GimpPaintOptions *options = gimp_paint_options_new (info);

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", info->blurb,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
clone_invoker (GimpProcedure      *procedure,
               Gimp               *gimp,
               GimpContext        *context,
               GimpProgress       *progress,
               const GValueArray  *args,
               GError            **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  GimpDrawable *src_drawable;
  gint32 clone_type;
  gdouble src_x;
  gdouble src_y;
  gint32 num_strokes;
  const gdouble *strokes;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  src_drawable = gimp_value_get_drawable (&args->values[1], gimp);
  clone_type = g_value_get_enum (&args->values[2]);
  src_x = g_value_get_double (&args->values[3]);
  src_y = g_value_get_double (&args->values[4]);
  num_strokes = g_value_get_int (&args->values[5]);
  strokes = gimp_value_get_floatarray (&args->values[6]);

  if (success)
    {
      GimpPaintInfo *info = gimp_pdb_get_paint_info (gimp, "gimp-clone", error);

      if (info && gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error))
        {
          GimpPaintOptions *options = gimp_paint_options_new (info);

          g_object_set (options,
                        "clone-type", clone_type,
                        NULL);

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc",    info->blurb,
                                        "src-drawable", src_drawable,
                                        "src-x",        src_x,
                                        "src-y",        src_y,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
clone_default_invoker (GimpProcedure      *procedure,
                       Gimp               *gimp,
                       GimpContext        *context,
                       GimpProgress       *progress,
                       const GValueArray  *args,
                       GError            **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 num_strokes;
  const gdouble *strokes;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  num_strokes = g_value_get_int (&args->values[1]);
  strokes = gimp_value_get_floatarray (&args->values[2]);

  if (success)
    {
      GimpPaintInfo *info = gimp_pdb_get_paint_info (gimp, "gimp-clone", error);

      if (info && gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error))
        {
          GimpPaintOptions *options = gimp_paint_options_new (info);

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", info->blurb,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
convolve_invoker (GimpProcedure      *procedure,
                  Gimp               *gimp,
                  GimpContext        *context,
                  GimpProgress       *progress,
                  const GValueArray  *args,
                  GError            **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gdouble pressure;
  gint32 convolve_type;
  gint32 num_strokes;
  const gdouble *strokes;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  pressure = g_value_get_double (&args->values[1]);
  convolve_type = g_value_get_enum (&args->values[2]);
  num_strokes = g_value_get_int (&args->values[3]);
  strokes = gimp_value_get_floatarray (&args->values[4]);

  if (success)
    {
      GimpPaintInfo *info = gimp_pdb_get_paint_info (gimp, "gimp-convolve", error);

      if (info && gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error))
        {
          GimpPaintOptions *options = gimp_paint_options_new (info);

          g_object_set (options,
                        "type", convolve_type,
                        "rate", pressure,
                        NULL);

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", info->blurb,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
convolve_default_invoker (GimpProcedure      *procedure,
                          Gimp               *gimp,
                          GimpContext        *context,
                          GimpProgress       *progress,
                          const GValueArray  *args,
                          GError            **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 num_strokes;
  const gdouble *strokes;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  num_strokes = g_value_get_int (&args->values[1]);
  strokes = gimp_value_get_floatarray (&args->values[2]);

  if (success)
    {
      GimpPaintInfo *info = gimp_pdb_get_paint_info (gimp, "gimp-convolve", error);

      if (info && gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error))
        {
          GimpPaintOptions *options = gimp_paint_options_new (info);

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", info->blurb,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
dodgeburn_invoker (GimpProcedure      *procedure,
                   Gimp               *gimp,
                   GimpContext        *context,
                   GimpProgress       *progress,
                   const GValueArray  *args,
                   GError            **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gdouble exposure;
  gint32 dodgeburn_type;
  gint32 dodgeburn_mode;
  gint32 num_strokes;
  const gdouble *strokes;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  exposure = g_value_get_double (&args->values[1]);
  dodgeburn_type = g_value_get_enum (&args->values[2]);
  dodgeburn_mode = g_value_get_enum (&args->values[3]);
  num_strokes = g_value_get_int (&args->values[4]);
  strokes = gimp_value_get_floatarray (&args->values[5]);

  if (success)
    {
      GimpPaintInfo *info = gimp_pdb_get_paint_info (gimp, "gimp-dodge-burn", error);

      if (info && gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error))
        {
          GimpPaintOptions *options = gimp_paint_options_new (info);

          g_object_set (options,
                        "type",     dodgeburn_type,
                        "mode",     dodgeburn_mode,
                        "exposure", exposure,
                        NULL);

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", info->blurb,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
dodgeburn_default_invoker (GimpProcedure      *procedure,
                           Gimp               *gimp,
                           GimpContext        *context,
                           GimpProgress       *progress,
                           const GValueArray  *args,
                           GError            **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 num_strokes;
  const gdouble *strokes;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  num_strokes = g_value_get_int (&args->values[1]);
  strokes = gimp_value_get_floatarray (&args->values[2]);

  if (success)
    {
      GimpPaintInfo *info = gimp_pdb_get_paint_info (gimp, "gimp-dodge-burn", error);

      if (info && gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error))
        {
          GimpPaintOptions *options = gimp_paint_options_new (info);

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", info->blurb,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
eraser_invoker (GimpProcedure      *procedure,
                Gimp               *gimp,
                GimpContext        *context,
                GimpProgress       *progress,
                const GValueArray  *args,
                GError            **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 num_strokes;
  const gdouble *strokes;
  gint32 hardness;
  gint32 method;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  num_strokes = g_value_get_int (&args->values[1]);
  strokes = gimp_value_get_floatarray (&args->values[2]);
  hardness = g_value_get_enum (&args->values[3]);
  method = g_value_get_enum (&args->values[4]);

  if (success)
    {
      GimpPaintInfo *info = gimp_pdb_get_paint_info (gimp, "gimp-eraser", error);

      if (info && gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error))
        {
          GimpPaintOptions *options = gimp_paint_options_new (info);

          g_object_set (options,
                        "application-mode", method,
                        "hard",             hardness,
                        NULL);

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", info->blurb,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
eraser_default_invoker (GimpProcedure      *procedure,
                        Gimp               *gimp,
                        GimpContext        *context,
                        GimpProgress       *progress,
                        const GValueArray  *args,
                        GError            **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 num_strokes;
  const gdouble *strokes;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  num_strokes = g_value_get_int (&args->values[1]);
  strokes = gimp_value_get_floatarray (&args->values[2]);

  if (success)
    {
      GimpPaintInfo *info = gimp_pdb_get_paint_info (gimp, "gimp-eraser", error);

      if (info && gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error))
        {
          GimpPaintOptions *options = gimp_paint_options_new (info);

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", info->blurb,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
heal_invoker (GimpProcedure      *procedure,
              Gimp               *gimp,
              GimpContext        *context,
              GimpProgress       *progress,
              const GValueArray  *args,
              GError            **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  GimpDrawable *src_drawable;
  gdouble src_x;
  gdouble src_y;
  gint32 num_strokes;
  const gdouble *strokes;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  src_drawable = gimp_value_get_drawable (&args->values[1], gimp);
  src_x = g_value_get_double (&args->values[2]);
  src_y = g_value_get_double (&args->values[3]);
  num_strokes = g_value_get_int (&args->values[4]);
  strokes = gimp_value_get_floatarray (&args->values[5]);

  if (success)
    {
      GimpPaintInfo *info = gimp_pdb_get_paint_info (gimp, "gimp-heal", error);

      if (info && gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error))
        {
          GimpPaintOptions *options = gimp_paint_options_new (info);

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc",    info->blurb,
                                        "src-drawable", src_drawable,
                                        "src-x",        src_x,
                                        "src-y",        src_y,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
heal_default_invoker (GimpProcedure      *procedure,
                      Gimp               *gimp,
                      GimpContext        *context,
                      GimpProgress       *progress,
                      const GValueArray  *args,
                      GError            **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 num_strokes;
  const gdouble *strokes;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  num_strokes = g_value_get_int (&args->values[1]);
  strokes = gimp_value_get_floatarray (&args->values[2]);

  if (success)
    {
      GimpPaintInfo *info = gimp_pdb_get_paint_info (gimp, "gimp-heal", error);

      if (info && gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error))
        {
          GimpPaintOptions *options = gimp_paint_options_new (info);

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", info->blurb,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
paintbrush_invoker (GimpProcedure      *procedure,
                    Gimp               *gimp,
                    GimpContext        *context,
                    GimpProgress       *progress,
                    const GValueArray  *args,
                    GError            **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gdouble fade_out;
  gint32 num_strokes;
  const gdouble *strokes;
  gint32 method;
  gdouble gradient_length;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  fade_out = g_value_get_double (&args->values[1]);
  num_strokes = g_value_get_int (&args->values[2]);
  strokes = gimp_value_get_floatarray (&args->values[3]);
  method = g_value_get_enum (&args->values[4]);
  gradient_length = g_value_get_double (&args->values[5]);

  if (success)
    {
      GimpPaintInfo *info = gimp_pdb_get_paint_info (gimp, "gimp-paintbrush", error);

      if (info && gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error))
        {
          GimpPaintOptions *options = gimp_paint_options_new (info);

          g_object_set (options,
                        "application-mode", method,
                        "use-fade",         fade_out > 0.0,
                        "fade-length",      fade_out,
                        "use-gradient",     gradient_length > 0.0,
                        "gradient-length",  gradient_length,
                        NULL);

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", info->blurb,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
paintbrush_default_invoker (GimpProcedure      *procedure,
                            Gimp               *gimp,
                            GimpContext        *context,
                            GimpProgress       *progress,
                            const GValueArray  *args,
                            GError            **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 num_strokes;
  const gdouble *strokes;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  num_strokes = g_value_get_int (&args->values[1]);
  strokes = gimp_value_get_floatarray (&args->values[2]);

  if (success)
    {
      GimpPaintInfo *info = gimp_pdb_get_paint_info (gimp, "gimp-paintbrush", error);

      if (info && gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error))
        {
          GimpPaintOptions *options = gimp_paint_options_new (info);

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", info->blurb,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
pencil_invoker (GimpProcedure      *procedure,
                Gimp               *gimp,
                GimpContext        *context,
                GimpProgress       *progress,
                const GValueArray  *args,
                GError            **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 num_strokes;
  const gdouble *strokes;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  num_strokes = g_value_get_int (&args->values[1]);
  strokes = gimp_value_get_floatarray (&args->values[2]);

  if (success)
    {
      GimpPaintInfo *info = gimp_pdb_get_paint_info (gimp, "gimp-pencil", error);

      if (info && gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error))
        {
          GimpPaintOptions *options = gimp_paint_options_new (info);

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", info->blurb,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
smudge_invoker (GimpProcedure      *procedure,
                Gimp               *gimp,
                GimpContext        *context,
                GimpProgress       *progress,
                const GValueArray  *args,
                GError            **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gdouble pressure;
  gint32 num_strokes;
  const gdouble *strokes;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  pressure = g_value_get_double (&args->values[1]);
  num_strokes = g_value_get_int (&args->values[2]);
  strokes = gimp_value_get_floatarray (&args->values[3]);

  if (success)
    {
      GimpPaintInfo *info = gimp_pdb_get_paint_info (gimp, "gimp-smudge", error);

      if (info && gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error))
        {
          GimpPaintOptions *options = gimp_paint_options_new (info);

          g_object_set (options,
                        "rate", pressure,
                        NULL);

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", info->blurb,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
smudge_default_invoker (GimpProcedure      *procedure,
                        Gimp               *gimp,
                        GimpContext        *context,
                        GimpProgress       *progress,
                        const GValueArray  *args,
                        GError            **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 num_strokes;
  const gdouble *strokes;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  num_strokes = g_value_get_int (&args->values[1]);
  strokes = gimp_value_get_floatarray (&args->values[2]);

  if (success)
    {
      GimpPaintInfo *info = gimp_pdb_get_paint_info (gimp, "gimp-smudge", error);

      if (info && gimp_pdb_item_is_attached (GIMP_ITEM (drawable), error))
        {
          GimpPaintOptions *options = gimp_paint_options_new (info);

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", info->blurb,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

void
register_paint_tools_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-airbrush
   */
  procedure = gimp_procedure_new (airbrush_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-airbrush");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-airbrush",
                                     "Paint in the current brush with varying pressure. Paint application is time-dependent.",
                                     "This tool simulates the use of an airbrush. Paint pressure represents the relative intensity of the paint application. High pressure results in a thicker layer of paint while low pressure results in a thinner layer.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("pressure",
                                                    "pressure",
                                                    "The pressure of the airbrush strokes",
                                                    0, 100, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("num-strokes",
                                                      "num strokes",
                                                      "Number of stroke control points (count each coordinate as 2 points)",
                                                      2, G_MAXINT32, 2,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_float_array ("strokes",
                                                            "strokes",
                                                            "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                            GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-airbrush-default
   */
  procedure = gimp_procedure_new (airbrush_default_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-airbrush-default");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-airbrush-default",
                                     "Paint in the current brush with varying pressure. Paint application is time-dependent.",
                                     "This tool simulates the use of an airbrush. It is similar to 'gimp-airbrush' except that the pressure is derived from the airbrush tools options box. It the option has not been set the default for the option will be used.",
                                     "Andy Thomas",
                                     "Andy Thomas",
                                     "1999",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("num-strokes",
                                                      "num strokes",
                                                      "Number of stroke control points (count each coordinate as 2 points)",
                                                      2, G_MAXINT32, 2,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_float_array ("strokes",
                                                            "strokes",
                                                            "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                            GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-clone
   */
  procedure = gimp_procedure_new (clone_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-clone");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-clone",
                                     "Clone from the source to the dest drawable using the current brush",
                                     "This tool clones (copies) from the source drawable starting at the specified source coordinates to the dest drawable. If the \"clone_type\" argument is set to PATTERN-CLONE, then the current pattern is used as the source and the \"src_drawable\" argument is ignored. Pattern cloning assumes a tileable pattern and mods the sum of the src coordinates and subsequent stroke offsets with the width and height of the pattern. For image cloning, if the sum of the src coordinates and subsequent stroke offsets exceeds the extents of the src drawable, then no paint is transferred. The clone tool is capable of transforming between any image types including RGB->Indexed--although converting from any type to indexed is significantly slower.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("src-drawable",
                                                            "src drawable",
                                                            "The source drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("clone-type",
                                                  "clone type",
                                                  "The type of clone",
                                                  GIMP_TYPE_CLONE_TYPE,
                                                  GIMP_IMAGE_CLONE,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("src-x",
                                                    "src x",
                                                    "The x coordinate in the source image",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("src-y",
                                                    "src y",
                                                    "The y coordinate in the source image",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("num-strokes",
                                                      "num strokes",
                                                      "Number of stroke control points (count each coordinate as 2 points)",
                                                      2, G_MAXINT32, 2,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_float_array ("strokes",
                                                            "strokes",
                                                            "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                            GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-clone-default
   */
  procedure = gimp_procedure_new (clone_default_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-clone-default");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-clone-default",
                                     "Clone from the source to the dest drawable using the current brush",
                                     "This tool clones (copies) from the source drawable starting at the specified source coordinates to the dest drawable. This function performs exactly the same as the 'gimp-clone' function except that the tools arguments are obtained from the clones option dialog. It this dialog has not been activated then the dialogs default values will be used.",
                                     "Andy Thomas",
                                     "Andy Thomas",
                                     "1999",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("num-strokes",
                                                      "num strokes",
                                                      "Number of stroke control points (count each coordinate as 2 points)",
                                                      2, G_MAXINT32, 2,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_float_array ("strokes",
                                                            "strokes",
                                                            "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                            GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-convolve
   */
  procedure = gimp_procedure_new (convolve_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-convolve");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-convolve",
                                     "Convolve (Blur, Sharpen) using the current brush.",
                                     "This tool convolves the specified drawable with either a sharpening or blurring kernel. The pressure parameter controls the magnitude of the operation. Like the paintbrush, this tool linearly interpolates between the specified stroke coordinates.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("pressure",
                                                    "pressure",
                                                    "The pressure",
                                                    0, 100, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("convolve-type",
                                                  "convolve type",
                                                  "Convolve type",
                                                  GIMP_TYPE_CONVOLVE_TYPE,
                                                  GIMP_BLUR_CONVOLVE,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("num-strokes",
                                                      "num strokes",
                                                      "Number of stroke control points (count each coordinate as 2 points)",
                                                      2, G_MAXINT32, 2,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_float_array ("strokes",
                                                            "strokes",
                                                            "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                            GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-convolve-default
   */
  procedure = gimp_procedure_new (convolve_default_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-convolve-default");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-convolve-default",
                                     "Convolve (Blur, Sharpen) using the current brush.",
                                     "This tool convolves the specified drawable with either a sharpening or blurring kernel. This function performs exactly the same as the 'gimp-convolve' function except that the tools arguments are obtained from the convolve option dialog. It this dialog has not been activated then the dialogs default values will be used.",
                                     "Andy Thomas",
                                     "Andy Thomas",
                                     "1999",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("num-strokes",
                                                      "num strokes",
                                                      "Number of stroke control points (count each coordinate as 2 points)",
                                                      2, G_MAXINT32, 2,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_float_array ("strokes",
                                                            "strokes",
                                                            "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                            GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-dodgeburn
   */
  procedure = gimp_procedure_new (dodgeburn_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-dodgeburn");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-dodgeburn",
                                     "Dodgeburn image with varying exposure.",
                                     "Dodgeburn. More details here later.",
                                     "Andy Thomas",
                                     "Andy Thomas",
                                     "1999",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("exposure",
                                                    "exposure",
                                                    "The exposure of the strokes",
                                                    0, 100, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("dodgeburn-type",
                                                  "dodgeburn type",
                                                  "The type either dodge or burn",
                                                  GIMP_TYPE_DODGE_BURN_TYPE,
                                                  GIMP_DODGE,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("dodgeburn-mode",
                                                  "dodgeburn mode",
                                                  "The mode",
                                                  GIMP_TYPE_TRANSFER_MODE,
                                                  GIMP_SHADOWS,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("num-strokes",
                                                      "num strokes",
                                                      "Number of stroke control points (count each coordinate as 2 points)",
                                                      2, G_MAXINT32, 2,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_float_array ("strokes",
                                                            "strokes",
                                                            "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                            GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-dodgeburn-default
   */
  procedure = gimp_procedure_new (dodgeburn_default_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-dodgeburn-default");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-dodgeburn-default",
                                     "Dodgeburn image with varying exposure. This is the same as the gimp_dodgeburn() function except that the exposure, type and mode are taken from the tools option dialog. If the dialog has not been activated then the defaults as used by the dialog will be used.",
                                     "Dodgeburn. More details here later.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("num-strokes",
                                                      "num strokes",
                                                      "Number of stroke control points (count each coordinate as 2 points)",
                                                      2, G_MAXINT32, 2,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_float_array ("strokes",
                                                            "strokes",
                                                            "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                            GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-eraser
   */
  procedure = gimp_procedure_new (eraser_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-eraser");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-eraser",
                                     "Erase using the current brush.",
                                     "This tool erases using the current brush mask. If the specified drawable contains an alpha channel, then the erased pixels will become transparent. Otherwise, the eraser tool replaces the contents of the drawable with the background color. Like paintbrush, this tool linearly interpolates between the specified stroke coordinates.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("num-strokes",
                                                      "num strokes",
                                                      "Number of stroke control points (count each coordinate as 2 points)",
                                                      2, G_MAXINT32, 2,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_float_array ("strokes",
                                                            "strokes",
                                                            "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("hardness",
                                                  "hardness",
                                                  "How to apply the brush",
                                                  GIMP_TYPE_BRUSH_APPLICATION_MODE,
                                                  GIMP_BRUSH_HARD,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("method",
                                                  "method",
                                                  "The paint method to use",
                                                  GIMP_TYPE_PAINT_APPLICATION_MODE,
                                                  GIMP_PAINT_CONSTANT,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-eraser-default
   */
  procedure = gimp_procedure_new (eraser_default_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-eraser-default");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-eraser-default",
                                     "Erase using the current brush.",
                                     "This tool erases using the current brush mask. This function performs exactly the same as the 'gimp-eraser' function except that the tools arguments are obtained from the eraser option dialog. It this dialog has not been activated then the dialogs default values will be used.",
                                     "Andy Thomas",
                                     "Andy Thomas",
                                     "1999",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("num-strokes",
                                                      "num strokes",
                                                      "Number of stroke control points (count each coordinate as 2 points)",
                                                      2, G_MAXINT32, 2,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_float_array ("strokes",
                                                            "strokes",
                                                            "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                            GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-heal
   */
  procedure = gimp_procedure_new (heal_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-heal");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-heal",
                                     "Heal from the source to the dest drawable using the current brush",
                                     "This tool heals the source drawable starting at the specified source coordinates to the dest drawable. For image healing, if the sum of the src coordinates and subsequent stroke offsets exceeds the extents of the src drawable, then no paint is transferred. The healing tool is capable of transforming between any image types except RGB->Indexed.",
                                     "Kevin Sookocheff",
                                     "Kevin Sookocheff",
                                     "2006",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("src-drawable",
                                                            "src drawable",
                                                            "The source drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("src-x",
                                                    "src x",
                                                    "The x coordinate in the source image",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("src-y",
                                                    "src y",
                                                    "The y coordinate in the source image",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("num-strokes",
                                                      "num strokes",
                                                      "Number of stroke control points (count each coordinate as 2 points)",
                                                      2, G_MAXINT32, 2,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_float_array ("strokes",
                                                            "strokes",
                                                            "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                            GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-heal-default
   */
  procedure = gimp_procedure_new (heal_default_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-heal-default");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-heal-default",
                                     "Heal from the source to the dest drawable using the current brush",
                                     "This tool heals from the source drawable starting at the specified source coordinates to the dest drawable. This function performs exactly the same as the 'gimp-heal' function except that the tools arguments are obtained from the healing option dialog. It this dialog has not been activated then the dialogs default values will be used.",
                                     "Kevin Sookocheff",
                                     "Kevin Sookocheff",
                                     "2006",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("num-strokes",
                                                      "num strokes",
                                                      "Number of stroke control points (count each coordinate as 2 points)",
                                                      2, G_MAXINT32, 2,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_float_array ("strokes",
                                                            "strokes",
                                                            "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                            GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-paintbrush
   */
  procedure = gimp_procedure_new (paintbrush_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-paintbrush");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-paintbrush",
                                     "Paint in the current brush with optional fade out parameter and pull colors from a gradient.",
                                     "This tool is the standard paintbrush. It draws linearly interpolated lines through the specified stroke coordinates. It operates on the specified drawable in the foreground color with the active brush. The 'fade-out' parameter is measured in pixels and allows the brush stroke to linearly fall off. The pressure is set to the maximum at the beginning of the stroke. As the distance of the stroke nears the fade-out value, the pressure will approach zero. The gradient-length is the distance to spread the gradient over. It is measured in pixels. If the gradient-length is 0, no gradient is used.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("fade-out",
                                                    "fade out",
                                                    "Fade out parameter",
                                                    0, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("num-strokes",
                                                      "num strokes",
                                                      "Number of stroke control points (count each coordinate as 2 points)",
                                                      2, G_MAXINT32, 2,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_float_array ("strokes",
                                                            "strokes",
                                                            "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("method",
                                                  "method",
                                                  "The paint method to use",
                                                  GIMP_TYPE_PAINT_APPLICATION_MODE,
                                                  GIMP_PAINT_CONSTANT,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("gradient-length",
                                                    "gradient length",
                                                    "Length of gradient to draw",
                                                    0, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-paintbrush-default
   */
  procedure = gimp_procedure_new (paintbrush_default_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-paintbrush-default");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-paintbrush-default",
                                     "Paint in the current brush. The fade out parameter and pull colors from a gradient parameter are set from the paintbrush options dialog. If this dialog has not been activated then the dialog defaults will be used.",
                                     "This tool is similar to the standard paintbrush. It draws linearly interpolated lines through the specified stroke coordinates. It operates on the specified drawable in the foreground color with the active brush. The 'fade-out' parameter is measured in pixels and allows the brush stroke to linearly fall off (value obtained from the option dialog). The pressure is set to the maximum at the beginning of the stroke. As the distance of the stroke nears the fade-out value, the pressure will approach zero. The gradient-length (value obtained from the option dialog) is the distance to spread the gradient over. It is measured in pixels. If the gradient-length is 0, no gradient is used.",
                                     "Andy Thomas",
                                     "Andy Thomas",
                                     "1999",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("num-strokes",
                                                      "num strokes",
                                                      "Number of stroke control points (count each coordinate as 2 points)",
                                                      2, G_MAXINT32, 2,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_float_array ("strokes",
                                                            "strokes",
                                                            "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                            GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pencil
   */
  procedure = gimp_procedure_new (pencil_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pencil");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-pencil",
                                     "Paint in the current brush without sub-pixel sampling.",
                                     "This tool is the standard pencil. It draws linearly interpolated lines through the specified stroke coordinates. It operates on the specified drawable in the foreground color with the active brush. The brush mask is treated as though it contains only black and white values. Any value below half is treated as black; any above half, as white.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("num-strokes",
                                                      "num strokes",
                                                      "Number of stroke control points (count each coordinate as 2 points)",
                                                      2, G_MAXINT32, 2,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_float_array ("strokes",
                                                            "strokes",
                                                            "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                            GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-smudge
   */
  procedure = gimp_procedure_new (smudge_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-smudge");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-smudge",
                                     "Smudge image with varying pressure.",
                                     "This tool simulates a smudge using the current brush. High pressure results in a greater smudge of paint while low pressure results in a lesser smudge.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("pressure",
                                                    "pressure",
                                                    "The pressure of the smudge strokes",
                                                    0, 100, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("num-strokes",
                                                      "num strokes",
                                                      "Number of stroke control points (count each coordinate as 2 points)",
                                                      2, G_MAXINT32, 2,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_float_array ("strokes",
                                                            "strokes",
                                                            "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                            GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-smudge-default
   */
  procedure = gimp_procedure_new (smudge_default_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-smudge-default");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-smudge-default",
                                     "Smudge image with varying pressure.",
                                     "This tool simulates a smudge using the current brush. It behaves exactly the same as 'gimp-smudge' except that the pressure value is taken from the smudge tool options or the options default if the tools option dialog has not been activated.",
                                     "Andy Thomas",
                                     "Andy Thomas",
                                     "1999",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("num-strokes",
                                                      "num strokes",
                                                      "Number of stroke control points (count each coordinate as 2 points)",
                                                      2, G_MAXINT32, 2,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_float_array ("strokes",
                                                            "strokes",
                                                            "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                            GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
