#!/usr/bin/perl
#
# Methods of using the special Composite methods
# which require extra arguments
# (given as the mis-named blend=> parameter )
#
# Essentually each image is equivelent to
#   convert -size 60x06 gradient:black-white \
#           \( logo: -crop 80x80+140+60 +repage -alpha set \) \
#           miff:- |\
#    composite -   -dissolve 70x30   show:
# for various composition methods.
#
use strict;
use Image::Magick;

# read image
my $dest=Image::Magick->new();
$dest->Read('logo:');
$dest->Crop('100x100+100+60');
$dest->Set(page=>'0x0+0+0');
$dest->Set(alpha=>'Set');

my $src=Image::Magick->new();
$src->Set(size=>'80x80');
$src->Read('gradient:black-white');

# ----------------------------------------
my $results=Image::Magick->new();
my $clone;

# over                src 'over' dest
$clone=$dest->Clone();
$clone->Label('Over\n(normal compose)');
$clone->Composite(
  image=>$src,
  compose=>'over',
  geometry=>'+10+10',
);
push(@$results, $clone);

# blend  70x30                0.7*src 'plus' 0.3*dest
$clone=$dest->Clone();
$clone->Label('Blend 70x30\n(blended plus)');
$clone->Composite(
  image=>$src,
  compose=>'blend',
  blend=>'70x30',
  geometry=>'+10+10',
);
push(@$results, $clone);

# dissolve 70x30             0.7*src 'over' 0.3*dest
$clone=$dest->Clone();
$clone->Label('Dissolve 70x30\n(blended over)');
$clone->Composite(
  image=>$src,
  compose=>'dissolve',
  blend=>'70x30',
  geometry=>'+10+10',
);
push(@$results, $clone);

# displace x=40              displace horizontally
$clone=$dest->Clone();
#$clone->Set('interpolate'=>'nearest-neighbour');
$clone->Set('virtual-pixel'=>'gray');
$clone->Label('Displace 50x0\n(displace horiz)');
$clone->Composite(
  image=>$src,
  compose=>'displace',
  blend=>'50x0',
  geometry=>'+10+10',
);
push(@$results, $clone);

# displace y=40              compress vertically
$clone=$dest->Clone();
#$clone->Set('interpolate'=>'nearest-neighbour');
$clone->Set('virtual-pixel'=>'gray');
$clone->Label('Displace 0x50\n(compress vert)');
$clone->Composite(
  image=>$src,
  compose=>'displace',
  blend=>'0x50',
  geometry=>'+10+10',
);
push(@$results, $clone);

# displace                 displace diagonally
$clone=$dest->Clone();
#$clone->Set('interpolate'=>'nearest-neighbour');
$clone->Set('virtual-pixel'=>'gray');
$clone->Label('Displace 50x50\n(diagonal)');
$clone->Composite(
  image=>$src,
  compose=>'displace',
  blend=>'50x50',
  geometry=>'+10+10',
);
push(@$results, $clone);

# ----------------------------------------
# Output the changed pixels
my $montage=$results->Montage(
  geometry=>'+10+10',
  frame=>'6x6+2+2',
  shadow=>'True',
);
$montage->Write('show:');
$montage->Write('compose_specials.jpg');

