/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.serql;

import java.util.LinkedHashSet;
import java.util.Set;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.parser.serql.ASTVisitorBase;
import org.openrdf.query.parser.serql.ast.ASTProjectionElem;
import org.openrdf.query.parser.serql.ast.ASTQueryContainer;
import org.openrdf.query.parser.serql.ast.ASTSelect;
import org.openrdf.query.parser.serql.ast.ASTVar;
import org.openrdf.query.parser.serql.ast.ASTWhere;
import org.openrdf.query.parser.serql.ast.VisitorException;

class WildcardProjectionProcessor
extends ASTVisitorBase {
    WildcardProjectionProcessor() {
    }

    public static void process(ASTQueryContainer qc) throws MalformedQueryException {
        try {
            qc.jjtAccept(new WildcardProjectionProcessor(), null);
        }
        catch (VisitorException e) {
            throw new MalformedQueryException(e.getMessage(), e);
        }
    }

    public Object visit(ASTSelect node, Object data) throws VisitorException {
        if (node.isWildcard()) {
            ProjectionVariableCollector visitor = new ProjectionVariableCollector();
            node.jjtGetParent().jjtAccept(visitor, null);
            for (String varName : visitor.getVariableNames()) {
                ASTProjectionElem projElemNode = new ASTProjectionElem(11);
                node.jjtAppendChild(projElemNode);
                projElemNode.jjtSetParent(node);
                ASTVar varNode = new ASTVar(42);
                varNode.setName(varName);
                projElemNode.jjtAppendChild(varNode);
                varNode.jjtSetParent(projElemNode);
            }
            node.setWildcard(false);
        }
        return data;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProjectionVariableCollector
    extends ASTVisitorBase {
        private Set<String> variableNames = new LinkedHashSet<String>();

        private ProjectionVariableCollector() {
        }

        public Set<String> getVariableNames() {
            return this.variableNames;
        }

        @Override
        public Object visit(ASTWhere node, Object data) throws VisitorException {
            return data;
        }

        @Override
        public Object visit(ASTVar node, Object data) throws VisitorException {
            this.variableNames.add(node.getName());
            return super.visit(node, data);
        }
    }
}

