/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.webclient.repository.query;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.http.webclient.repository.query.QueryFormController;
import org.openrdf.http.webclient.repository.query.SelectQueryInfo;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.http.HTTPQueryEvaluationException;
import org.openrdf.repository.http.HTTPRepository;
import org.openrdf.repository.http.HTTPTupleQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;

public class SelectQueryFormController
extends QueryFormController {
    final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        ModelAndView result = null;
        HTTPRepository repo = (HTTPRepository)request.getSession().getAttribute("openrdf-repository");
        SelectQueryInfo qInfo = (SelectQueryInfo)command;
        TupleQueryResult queryResult = null;
        RepositoryConnection conn = null;
        try {
            conn = repo.getConnection();
            HTTPTupleQuery query = (HTTPTupleQuery)conn.prepareTupleQuery(qInfo.getQueryLanguage(), qInfo.getQueryString());
            query.setIncludeInferred(qInfo.isIncludeInferred());
            try {
                queryResult = query.evaluate();
            }
            catch (HTTPQueryEvaluationException e) {
                if (e.isCausedByMalformedQueryException()) {
                    throw e.getCauseAsMalformedQueryException();
                }
                if (e.isCausedByRepositoryException()) {
                    throw e.getCauseAsRepositoryException();
                }
                if (e.isCausedByIOException()) {
                    throw e.getCauseAsIOException();
                }
                throw e;
            }
        }
        catch (RepositoryException e) {
            this.logger.info("Unable to process query", (Throwable)e);
            errors.reject("repository.error");
        }
        catch (MalformedQueryException e) {
            errors.rejectValue("queryString", "repository.query.error.malformed", (Object[])new String[]{e.getMessage()}, "Malformed query");
        }
        catch (QueryEvaluationException e) {
            errors.reject("repository.query.error.evaluation");
        }
        if (errors.hasErrors()) {
            result = this.showForm(request, response, errors, errors.getModel());
        } else {
            Map model = errors.getModel();
            model.put("bindingNames", queryResult.getBindingNames());
            model.put("solutions", queryResult);
            result = new ModelAndView(this.getSuccessView(), model);
        }
        return result;
    }
}

