/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.services;

import jep.AppletHandlerFactory;
import sun.plugin.services.BrowserService;

public class ServiceProvider {
    private static BrowserService service = null;

    public static synchronized BrowserService getService() {
        if (service == null) {
            try {
                Class<?> c = Class.forName("sun.plugin.services.DefaultBrowserService");
                service = (BrowserService)c.newInstance();
            }
            catch (Throwable e) {
                System.err.println("ServiceProvider.getService(): exception: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return service;
    }

    public static synchronized void setService(int browserType) {
        Class<?> c = null;
        try {
            switch (browserType) {
                case 5: {
                    c = Class.forName("sun.plugin.services.AxBridgeBrowserService");
                    break;
                }
                case 17: {
                    c = Class.forName("sun.plugin.services.MacOSXBrowserService");
                    break;
                }
                case 21: {
                    c = Class.forName("sun.plugin.services.WebKitBrowserService");
                    break;
                }
                case 257: {
                    c = Class.forName("sun.plugin.services.WIExplorerBrowserService");
                    break;
                }
                case 258: {
                    c = Class.forName("sun.plugin.services.WNetscape4BrowserService");
                    break;
                }
                case 259: {
                    c = Class.forName("sun.plugin.services.WNetscape6BrowserService");
                    break;
                }
                case 666: {
                    if (AppletHandlerFactory.isJava142()) {
                        c = Class.forName("sun.plugin.services.JEPBrowserService142");
                        break;
                    }
                    c = Class.forName("sun.plugin.services.JEPBrowserService141");
                    break;
                }
                case 4098: {
                    c = Class.forName("sun.plugin.services.MNetscape4BrowserService");
                    break;
                }
                case 4099: {
                    c = Class.forName("sun.plugin.services.MNetscape6BrowserService");
                    break;
                }
                default: {
                    c = Class.forName("sun.plugin.services.DefaultBrowserService");
                }
            }
            service = (BrowserService)c.newInstance();
        }
        catch (Throwable e) {
            System.err.println("ServiceProvider.setService(): exception: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

