/* keyfileutils.h: useful functions for GKeyFile
 * 
 * Copyright (C) 2007 Vincent Untz <vuntz@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
 */

#include <glib.h>

#define GROUP_DESKTOP_ENTRY "Desktop Entry"

gboolean dfu_key_file_rename_group (GKeyFile   *keyfile,
                                    const char *oldgroup,
                                    const char *newgroup);

gboolean dfu_key_file_copy_key     (GKeyFile   *keyfile,
                                    const char *fromgroup,
                                    const char *fromkey,
                                    const char *togroup,
                                    const char *tokey);

void     dfu_key_file_merge_list   (GKeyFile   *keyfile,
                                    const char *group,
                                    const char *key,
                                    const char *to_merge);

void     dfu_key_file_remove_list  (GKeyFile   *keyfile,
                                    const char *group,
                                    const char *key,
                                    const char *to_remove);

gboolean dfu_key_file_to_file      (GKeyFile     *keyfile,
                                    const char   *file,
                                    GError      **error);
