'\" t
.TH PR3287 1 "02 February 2007"
.SH "NAME"
pr3287 \-
\s-1IBM\s+1
host printing tool
.SH "SYNOPSIS"
\fBpr3287\fP
[ \fIoptions\fP ]       
[ L: ] [[ \fILUname\fP [, \fILUname\fP ...]@] \fIhostname\fP [: \fIport\fP ]] 
.SH "DESCRIPTION"
\fBpr3287\fP
opens a telnet connection to an
\s-1IBM\s+1
host, and emulates an \s-1IBM\s+1 3287 printer.
It implements RFCs 2355 (TN3270E), 1576 (TN3270) and 1646 (LU name selection).
.LP
If the \fIhostname\fP is prefixed with \fBL:\fP, the connection will be made
through an SSL tunnel.
\fBpr3287\fP also supports TELNET START-TLS option negotiation without any
need for command-line options.
.LP
A specific LU name to use may be specified by prepending it to the
\fIhostname\fP
with an
`\fB@\fP'.
Multiple LU names to try can be separated by commas.
An empty LU can be placed in the list with an extra comma.
.LP
The port to connect to defaults to
\fBtelnet\fP.
This can be overridden by appending a
\fIport\fP
to the
\fIhostname\fP
with a colon
`\fB:\fP'.
.SH "OPTIONS"
\fBpr3287\fP
understands the following options:
.TP
\fB\-assoc\fP \fILUname\fP
Causes the session to be associated with the specified
\fILUname\fP.
.TP
\fB\-blanklines\fP
In LU3 formatted mode, print blank lines even if they are all NULLs or control
characters.
(This is a violation of the 3270 printer protocol, but some hosts require it.)
.TP
\fB\-charset\fP \fIname\fP
Specifies an alternate \s-1EBCDIC\s+1-to-\s-1ASCII\s+1 mapping.
The default maps the EBCDIC U.S. English character set to \s-1ISO\s+1 8859-1.
Other built-in character sets are \fBbracket\fP, which corresponds to
many older \s-1IBM\s+1 hosts' mapping of the \fB[\fP and \fB]\fP characters,
and the non-U.S. character sets \fBgerman\fP, \fBfinnish\fP, \fBuk\fP,
\fBnorwegian\fP, \fBfrench\fP, \fBicelandic\fP and \fBbelgian\fP.
These correspond to the \fBx3270\fP character sets of the same names.
.IP
If \fIname\fP begins with an \fB@\fP, then the balance is intepreted as
the name of a file containing character mappings.
The file contains whitespace-separated tokens.
Each token is a number specifying an EBCDIC code, an \fB=\fP character,
and a number specifying the 8-bit ASCII character used to print that code.
Blank lines and lines beginning with \fB#\fP are ignored.
.IP
If \fIname\fP begins with an \fB=\fP, then the balance is intepreted as
a string containing mapping tokens, as in a file.
.IP
For example, a file defining the \fBuk\fP character set would look like
this:
.IP
.RS
.br
# UK character set
.br
0x4a=0x24 0x5b=0xa3 0xa1=0xaf
.br
0xb0=0xa2 0xb1=0x5b 0xba=0x5e
.br
0xbc=0x7e
.RE
.TP
\fB\-command\fP \fIcommand\fP
Specifies the command to run for each print job.
The default is
\fBlpr\fP.
.TP
\fB\-crlf\fP
Causes newline characters in the output to be expanded to
carriage-return/linefeed sequences.
.TP
\fB\-daemon\fP
Causes
\fIpr3287\fP
to become a daemon (background) process.
.TP
\fB\-eojtimeout\fP \fIseconds\fP
Causes \fIpr3287\fP to flush the print job after \fIseconds\fP seconds
of inactivity.
.TP
\fB\-ignoreeoj\fP
Ignore TN3270E PRINT-EOJ commands, relying on UNBIND commands to indicate
the ends of print jobs.
.TP
\fB\-ffskip\fP
Causes \fIpr3287\fP to ignore a FF (formfeed) order if it occurs
at the top of a page.
.TP
\fB\-ffthru\fP
In SCS mode, causes \fIpr3287\fP to pass FF (formfeed) orders through to the
printer as ASCII formfeed characters, rather than simulating them based on the
values of the MPL (maximum presentation line) and TM (top margin) parameters.
.TP
\fB\-reconnect\fP
Causes \fIpr3287\fP to reconnect to the host, whenever the connection is
broken.
There is a 5-second delay between reconnect attempts, to reduce network
thrashing for down or misconfigured hosts.
.TP
\fB\-trace\fP
Turns on data stream tracing.
Trace information is usually saved in the file
\fB/tmp/x3trc.\fP\fIpid\fP.
.TP
\fB\-tracedir\fP \fIdir\fP
Specifies the directory to save trace files in, instead of \fB/tmp\fP.
.SH "SIGNALS"
SIGINT, SIGHUP and SIGTERM cause the current print job to be flushed (any
pending data to be printed) and \fIpr3287\fP to exit.
.LP
SIGUSR1 causes the current print job to be flushed without otherwise
affecting the \fIpr3287\fP process.
.SH "SEE ALSO"
x3270(1), telnet(1), tn3270(1)
.br
Data Stream Programmer's Reference, IBM GA23\-0059
.br
Character Set Reference, IBM GA27\-3831
.br
3174 Establishment Controller Functional Description, IBM GA23\-0218
.br
RFC 1576, TN3270 Current Practices
.br
RFC 1646, TN3270 Extensions for LUname and Printer Selection
.br
RFC 2355, TN3270 Enhancements
.SH "COPYRIGHTS"
.LP
Modifications Copyright  1993-1996, 1997, 1999-2005 by Paul Mattes.
.br
Original X11 Port Copyright 1990 by Jeff Sparkes.
.RS
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.
.RE
Copyright 1989 by Georgia Tech Research Corporation, Atlanta, GA 30332.
.RS
All Rights Reserved.  GTRC hereby grants public use of this software.
Derivative works based on this software must incorporate this copyright
notice.
.RE
.SH "VERSION"
pr3287 3.3.5
