/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.nio.ch.ChannelInputStream;
import sun.nio.ch.Net;
import sun.nio.ch.OptionAdaptor;
import sun.nio.ch.SocketChannelImpl;
import sun.nio.ch.Util;

public class SocketAdaptor
extends Socket {
    private final SocketChannelImpl sc;
    private volatile OptionAdaptor opts = null;
    private volatile int timeout = 0;
    private volatile int trafficClass = 0;
    private InputStream socketInputStream = null;

    private SocketAdaptor(SocketChannelImpl socketChannelImpl) {
        this.sc = socketChannelImpl;
    }

    public static Socket create(SocketChannelImpl socketChannelImpl) {
        return new SocketAdaptor(socketChannelImpl);
    }

    public SocketChannel getChannel() {
        return this.sc;
    }

    public void connect(SocketAddress socketAddress) throws IOException {
        this.connect(socketAddress, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(SocketAddress socketAddress, int n) throws IOException {
        if (socketAddress == null) {
            throw new IllegalArgumentException("connect: The address can't be null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("connect: timeout can't be negative");
        }
        Object object = this.sc.blockingLock();
        synchronized (object) {
            block22: {
                if (!this.sc.isBlocking()) {
                    throw new IllegalBlockingModeException();
                }
                try {
                    if (n == 0) {
                        this.sc.connect(socketAddress);
                        return;
                    }
                    SelectionKey selectionKey = null;
                    Selector selector = null;
                    this.sc.configureBlocking(false);
                    try {
                        long l;
                        if (this.sc.connect(socketAddress)) {
                            return;
                        }
                        selector = Util.getTemporarySelector(this.sc);
                        selectionKey = this.sc.register(selector, 8);
                        long l2 = n;
                        do {
                            if (!this.sc.isOpen()) {
                                throw new ClosedChannelException();
                            }
                            l = System.currentTimeMillis();
                            int n2 = selector.select(l2);
                            if (n2 > 0 && selectionKey.isConnectable() && this.sc.finishConnect()) {
                                break block22;
                            }
                            selector.selectedKeys().remove(selectionKey);
                        } while ((l2 -= System.currentTimeMillis() - l) > 0L);
                        try {
                            this.sc.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw new SocketTimeoutException();
                    }
                    finally {
                        if (selectionKey != null) {
                            selectionKey.cancel();
                        }
                        if (this.sc.isOpen()) {
                            this.sc.configureBlocking(true);
                        }
                        if (selector != null) {
                            Util.releaseTemporarySelector(selector);
                        }
                    }
                }
                catch (Exception exception) {
                    Net.translateException(exception, true);
                }
            }
        }
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        try {
            if (socketAddress == null) {
                socketAddress = new InetSocketAddress(0);
            }
            this.sc.bind(socketAddress);
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    public InetAddress getInetAddress() {
        if (!this.sc.isConnected()) {
            return null;
        }
        return Net.asInetSocketAddress(this.sc.remoteAddress()).getAddress();
    }

    public InetAddress getLocalAddress() {
        if (!this.sc.isBound()) {
            return new InetSocketAddress(0).getAddress();
        }
        return Net.asInetSocketAddress(this.sc.localAddress()).getAddress();
    }

    public int getPort() {
        if (!this.sc.isConnected()) {
            return 0;
        }
        return Net.asInetSocketAddress(this.sc.remoteAddress()).getPort();
    }

    public int getLocalPort() {
        if (!this.sc.isBound()) {
            return 0;
        }
        return Net.asInetSocketAddress(this.sc.localAddress()).getPort();
    }

    public InputStream getInputStream() throws IOException {
        if (!this.sc.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.sc.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (!this.sc.isInputOpen()) {
            throw new SocketException("Socket input is shutdown");
        }
        if (this.socketInputStream == null) {
            try {
                this.socketInputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return new SocketInputStream();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
        }
        return this.socketInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.sc.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.sc.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (!this.sc.isOutputOpen()) {
            throw new SocketException("Socket output is shutdown");
        }
        OutputStream outputStream = null;
        try {
            outputStream = (OutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return Channels.newOutputStream(SocketAdaptor.this.sc);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        return outputStream;
    }

    private OptionAdaptor opts() {
        if (this.opts == null) {
            this.opts = new OptionAdaptor(this.sc);
        }
        return this.opts;
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.opts().setTcpNoDelay(bl);
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.opts().getTcpNoDelay();
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        this.opts().setSoLinger(bl, n);
    }

    public int getSoLinger() throws SocketException {
        return this.opts().getSoLinger();
    }

    public void sendUrgentData(int n) throws IOException {
        throw new SocketException("Urgent data not supported");
    }

    public void setOOBInline(boolean bl) throws SocketException {
        this.opts().setOOBInline(bl);
    }

    public boolean getOOBInline() throws SocketException {
        return this.opts().getOOBInline();
    }

    public void setSoTimeout(int n) throws SocketException {
        if (n < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        this.timeout = n;
    }

    public int getSoTimeout() throws SocketException {
        return this.timeout;
    }

    public void setSendBufferSize(int n) throws SocketException {
        this.opts().setSendBufferSize(n);
    }

    public int getSendBufferSize() throws SocketException {
        return this.opts().getSendBufferSize();
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        this.opts().setReceiveBufferSize(n);
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.opts().getReceiveBufferSize();
    }

    public void setKeepAlive(boolean bl) throws SocketException {
        this.opts().setKeepAlive(bl);
    }

    public boolean getKeepAlive() throws SocketException {
        return this.opts().getKeepAlive();
    }

    public void setTrafficClass(int n) throws SocketException {
        this.opts().setTrafficClass(n);
        this.trafficClass = n;
    }

    public int getTrafficClass() throws SocketException {
        int n = this.opts().getTrafficClass();
        if (n < 0) {
            n = this.trafficClass;
        }
        return n;
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        this.opts().setReuseAddress(bl);
    }

    public boolean getReuseAddress() throws SocketException {
        return this.opts().getReuseAddress();
    }

    public void close() throws IOException {
        try {
            this.sc.close();
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    public void shutdownInput() throws IOException {
        try {
            this.sc.shutdownInput();
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    public void shutdownOutput() throws IOException {
        try {
            this.sc.shutdownOutput();
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    public String toString() {
        if (this.sc.isConnected()) {
            return "Socket[addr=" + this.getInetAddress() + ",port=" + this.getPort() + ",localport=" + this.getLocalPort() + "]";
        }
        return "Socket[unconnected]";
    }

    public boolean isConnected() {
        return this.sc.isConnected();
    }

    public boolean isBound() {
        return this.sc.isBound();
    }

    public boolean isClosed() {
        return !this.sc.isOpen();
    }

    public boolean isInputShutdown() {
        return !this.sc.isInputOpen();
    }

    public boolean isOutputShutdown() {
        return !this.sc.isOutputOpen();
    }

    static /* synthetic */ int access$100(SocketAdaptor socketAdaptor) {
        return socketAdaptor.timeout;
    }

    private class SocketInputStream
    extends ChannelInputStream {
        private SocketInputStream() {
            super(SocketAdaptor.this.sc);
        }

        /*
         * Exception decompiling
         */
        protected int read(ByteBuffer var1_1) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 9[DOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

